/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.function.UnaryOperator;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.validation.Schema;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.UseLegacyMetadata;
import org.apache.sis.xml.OutputFactory;
import org.apache.sis.xml.Pooled;
import org.apache.sis.xml.TransformVersion;
import org.apache.sis.xml.TransformingWriter;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

final class PooledMarshaller
extends Pooled
implements Marshaller {
    private final Marshaller marshaller;
    private int specificBitMasks;

    PooledMarshaller(Marshaller marshaller, Pooled pooled) throws JAXBException {
        super(pooled);
        this.marshaller = marshaller;
        this.initialize(pooled);
    }

    @Override
    protected void reset(Object object, Object object2) throws JAXBException {
        if (object instanceof String) {
            String string = (String)object;
            if (object2 == null && (string.endsWith(".xmlHeaders") || string.equals("jaxb.schemaLocation"))) {
                object2 = "";
            }
            this.marshaller.setProperty(string, object2);
        } else if (object == AttachmentMarshaller.class) {
            this.marshaller.setAttachmentMarshaller((AttachmentMarshaller)object2);
        } else if (object == Schema.class) {
            this.marshaller.setSchema((Schema)object2);
        } else if (object == Marshaller.Listener.class) {
            this.marshaller.setListener((Marshaller.Listener)object2);
        } else if (object == ValidationEventHandler.class) {
            this.marshaller.setEventHandler((ValidationEventHandler)object2);
        } else {
            this.marshaller.setAdapter((Class)object, (XmlAdapter)object2);
        }
    }

    private String getEncoding() throws PropertyException {
        return (String)this.marshaller.getProperty("jaxb.encoding");
    }

    @Override
    final int specificBitMasks() {
        return this.specificBitMasks;
    }

    private Object toImplementation(Object object) {
        this.specificBitMasks = object.getClass().isAnnotationPresent(UseLegacyMetadata.class) ? 32 : 0;
        UnaryOperator<Object>[] unaryOperatorArray = this.getRootAdapters();
        if (unaryOperatorArray != null) {
            for (UnaryOperator<Object> unaryOperator : unaryOperatorArray) {
                Object r = unaryOperator.apply(object);
                if (r == null) continue;
                return r;
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void marshal(Object object, XMLEventWriter xMLEventWriter, TransformVersion transformVersion) throws XMLStreamException, JAXBException {
        xMLEventWriter = new TransformingWriter(xMLEventWriter, transformVersion);
        Context context = this.begin();
        try {
            this.marshaller.marshal(object, xMLEventWriter);
        }
        finally {
            context.finish();
        }
        xMLEventWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Object object, Result result) throws JAXBException {
        object = this.toImplementation(object);
        TransformVersion transformVersion = this.getTransformVersion();
        if (transformVersion != null) {
            try {
                this.marshal(object, OutputFactory.createXMLEventWriter(result), transformVersion);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new JAXBException((Throwable)xMLStreamException);
            }
        }
        Context context = this.begin();
        try {
            this.marshaller.marshal(object, result);
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Object object, OutputStream outputStream) throws JAXBException {
        object = this.toImplementation(object);
        TransformVersion transformVersion = this.getTransformVersion();
        if (transformVersion != null) {
            try {
                this.marshal(object, OutputFactory.createXMLEventWriter(outputStream, this.getEncoding()), transformVersion);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new JAXBException((Throwable)xMLStreamException);
            }
        }
        Context context = this.begin();
        try {
            this.marshaller.marshal(object, outputStream);
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Object object, File file) throws JAXBException {
        block11: {
            object = this.toImplementation(object);
            TransformVersion transformVersion = this.getTransformVersion();
            if (transformVersion != null) {
                try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));){
                    this.marshal(object, OutputFactory.createXMLEventWriter(bufferedOutputStream, this.getEncoding()), transformVersion);
                    break block11;
                }
                catch (IOException | XMLStreamException exception) {
                    throw new JAXBException((Throwable)exception);
                }
            }
            Context context = this.begin();
            try {
                this.marshaller.marshal(object, file);
            }
            finally {
                context.finish();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Object object, Writer writer) throws JAXBException {
        object = this.toImplementation(object);
        TransformVersion transformVersion = this.getTransformVersion();
        if (transformVersion != null) {
            try {
                this.marshal(object, OutputFactory.createXMLEventWriter(writer), transformVersion);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new JAXBException((Throwable)xMLStreamException);
            }
        }
        Context context = this.begin();
        try {
            this.marshaller.marshal(object, writer);
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Object object, ContentHandler contentHandler) throws JAXBException {
        object = this.toImplementation(object);
        TransformVersion transformVersion = this.getTransformVersion();
        if (transformVersion != null) {
            try {
                this.marshal(object, OutputFactory.createXMLEventWriter(contentHandler), transformVersion);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new JAXBException((Throwable)xMLStreamException);
            }
        }
        Context context = this.begin();
        try {
            this.marshaller.marshal(object, contentHandler);
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Object object, Node node) throws JAXBException {
        object = this.toImplementation(object);
        TransformVersion transformVersion = this.getTransformVersion();
        if (transformVersion != null) {
            try {
                this.marshal(object, OutputFactory.createXMLEventWriter(node), transformVersion);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new JAXBException((Throwable)xMLStreamException);
            }
        }
        Context context = this.begin();
        try {
            this.marshaller.marshal(object, node);
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Object object, XMLStreamWriter xMLStreamWriter) throws JAXBException {
        object = this.toImplementation(object);
        TransformVersion transformVersion = this.getTransformVersion();
        if (transformVersion != null) {
            try {
                this.marshal(object, OutputFactory.createXMLEventWriter(xMLStreamWriter), transformVersion);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new JAXBException((Throwable)xMLStreamException);
            }
        }
        Context context = this.begin();
        try {
            this.marshaller.marshal(object, xMLStreamWriter);
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Object object, XMLEventWriter xMLEventWriter) throws JAXBException {
        object = this.toImplementation(object);
        TransformVersion transformVersion = this.getTransformVersion();
        if (transformVersion != null) {
            xMLEventWriter = new TransformingWriter(xMLEventWriter, transformVersion);
        }
        Context context = this.begin();
        try {
            this.marshaller.marshal(object, xMLEventWriter);
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getNode(Object object) throws JAXBException {
        object = this.toImplementation(object);
        TransformVersion transformVersion = this.getTransformVersion();
        if (transformVersion != null) {
            throw new UnsupportedOperationException();
        }
        Context context = this.begin();
        try {
            Node node = this.marshaller.getNode(object);
            return node;
        }
        finally {
            context.finish();
        }
    }

    @Override
    void setStandardProperty(String string, Object object) throws PropertyException {
        this.marshaller.setProperty(string, object);
    }

    @Override
    Object getStandardProperty(String string) throws PropertyException {
        return this.marshaller.getProperty(string);
    }

    @Override
    public <A extends XmlAdapter> void setAdapter(Class<A> clazz, A a) {
        super.setAdapter(clazz, a);
        this.marshaller.setAdapter(clazz, a);
    }

    @Override
    public <A extends XmlAdapter> A getAdapter(Class<A> clazz) {
        return (A)this.marshaller.getAdapter(clazz);
    }

    @Override
    public void setSchema(Schema schema) {
        super.setSchema(schema);
        this.marshaller.setSchema(schema);
    }

    @Override
    public Schema getSchema() {
        return this.marshaller.getSchema();
    }

    @Override
    public void setEventHandler(ValidationEventHandler validationEventHandler) throws JAXBException {
        super.setEventHandler(validationEventHandler);
        this.marshaller.setEventHandler(validationEventHandler);
    }

    @Override
    public ValidationEventHandler getEventHandler() throws JAXBException {
        return this.marshaller.getEventHandler();
    }

    public void setAttachmentMarshaller(AttachmentMarshaller attachmentMarshaller) {
        if (!this.isPropertySaved(AttachmentMarshaller.class)) {
            this.saveProperty(AttachmentMarshaller.class, this.marshaller.getAttachmentMarshaller());
        }
        this.marshaller.setAttachmentMarshaller(attachmentMarshaller);
    }

    public AttachmentMarshaller getAttachmentMarshaller() {
        return this.marshaller.getAttachmentMarshaller();
    }

    public void setListener(Marshaller.Listener listener) {
        if (!this.isPropertySaved(Marshaller.Listener.class)) {
            this.saveProperty(Marshaller.Listener.class, this.marshaller.getListener());
        }
        this.marshaller.setListener(listener);
    }

    public Marshaller.Listener getListener() {
        return this.marshaller.getListener();
    }
}

