/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.sshd.common.BuiltinFactory;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.cipher.BuiltinCiphers;
import org.apache.sshd.common.compression.BuiltinCompressions;
import org.apache.sshd.common.compression.CompressionFactory;
import org.apache.sshd.common.config.CompressionConfigValue;
import org.apache.sshd.common.helpers.AbstractFactoryManager;
import org.apache.sshd.common.kex.BuiltinDHFactories;
import org.apache.sshd.common.kex.DHFactory;
import org.apache.sshd.common.kex.KeyExchangeFactory;
import org.apache.sshd.common.mac.BuiltinMacs;
import org.apache.sshd.common.signature.BuiltinSignatures;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public final class SshConfigFileReader {
    private SshConfigFileReader() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static BuiltinCiphers.ParseResult getCiphers(PropertyResolver props) {
        return BuiltinCiphers.parseCiphersList(props == null ? null : props.getString("Ciphers"));
    }

    public static BuiltinMacs.ParseResult getMacs(PropertyResolver props) {
        return BuiltinMacs.parseMacsList(props == null ? null : props.getString("MACs"));
    }

    public static BuiltinSignatures.ParseResult getSignatures(PropertyResolver props) {
        return BuiltinSignatures.parseSignatureList(props == null ? null : props.getString("HostKeyAlgorithms"));
    }

    public static BuiltinDHFactories.ParseResult getKexFactories(PropertyResolver props) {
        return BuiltinDHFactories.parseDHFactoriesList(props == null ? null : props.getString("KexAlgorithms"));
    }

    public static CompressionFactory getCompression(PropertyResolver props) {
        return CompressionConfigValue.fromName(props == null ? null : props.getString("Compression"));
    }

    public static <M extends AbstractFactoryManager> M configure(M manager, PropertyResolver props, boolean lenient, boolean ignoreUnsupported) {
        SshConfigFileReader.configureCiphers(manager, props, lenient, ignoreUnsupported);
        SshConfigFileReader.configureSignatures(manager, props, lenient, ignoreUnsupported);
        SshConfigFileReader.configureMacs(manager, props, lenient, ignoreUnsupported);
        SshConfigFileReader.configureCompression(manager, props, lenient, ignoreUnsupported);
        return manager;
    }

    public static <M extends AbstractFactoryManager> M configureCiphers(M manager, PropertyResolver props, boolean lenient, boolean ignoreUnsupported) {
        Objects.requireNonNull(props, "No properties to configure");
        return SshConfigFileReader.configureCiphers(manager, props.getString("Ciphers"), lenient, ignoreUnsupported);
    }

    public static <M extends AbstractFactoryManager> M configureCiphers(M manager, String value, boolean lenient, boolean ignoreUnsupported) {
        Objects.requireNonNull(manager, "No manager to configure");
        if (GenericUtils.isEmpty((CharSequence)value)) {
            return manager;
        }
        BuiltinCiphers.ParseResult result = BuiltinCiphers.parseCiphersList((String)value);
        List unsupported = result.getUnsupportedFactories();
        ValidateUtils.checkTrue((lenient || GenericUtils.isEmpty((Collection)unsupported) ? 1 : 0) != 0, (String)"Unsupported cipher(s) (%s) in %s", (Object[])new Object[]{unsupported, value});
        List factories = BuiltinFactory.setUpFactories((boolean)ignoreUnsupported, (Collection)result.getParsedFactories());
        manager.setCipherFactories((List)ValidateUtils.checkNotNullAndNotEmpty((Collection)factories, (String)"No known/unsupported ciphers(s): %s", (Object[])new Object[]{value}));
        return manager;
    }

    public static <M extends AbstractFactoryManager> M configureSignatures(M manager, PropertyResolver props, boolean lenient, boolean ignoreUnsupported) {
        Objects.requireNonNull(props, "No properties to configure");
        return SshConfigFileReader.configureSignatures(manager, props.getString("HostKeyAlgorithms"), lenient, ignoreUnsupported);
    }

    public static <M extends AbstractFactoryManager> M configureSignatures(M manager, String value, boolean lenient, boolean ignoreUnsupported) {
        Objects.requireNonNull(manager, "No manager to configure");
        if (GenericUtils.isEmpty((CharSequence)value)) {
            return manager;
        }
        BuiltinSignatures.ParseResult result = BuiltinSignatures.parseSignatureList((String)value);
        List unsupported = result.getUnsupportedFactories();
        ValidateUtils.checkTrue((lenient || GenericUtils.isEmpty((Collection)unsupported) ? 1 : 0) != 0, (String)"Unsupported signatures (%s) in %s", (Object[])new Object[]{unsupported, value});
        List factories = BuiltinFactory.setUpFactories((boolean)ignoreUnsupported, (Collection)result.getParsedFactories());
        manager.setSignatureFactories((List)ValidateUtils.checkNotNullAndNotEmpty((Collection)factories, (String)"No known/supported signatures: %s", (Object[])new Object[]{value}));
        return manager;
    }

    public static <M extends AbstractFactoryManager> M configureMacs(M manager, PropertyResolver resolver, boolean lenient, boolean ignoreUnsupported) {
        Objects.requireNonNull(resolver, "No properties to configure");
        return SshConfigFileReader.configureMacs(manager, resolver.getString("MACs"), lenient, ignoreUnsupported);
    }

    public static <M extends AbstractFactoryManager> M configureMacs(M manager, String value, boolean lenient, boolean ignoreUnsupported) {
        Objects.requireNonNull(manager, "No manager to configure");
        if (GenericUtils.isEmpty((CharSequence)value)) {
            return manager;
        }
        BuiltinMacs.ParseResult result = BuiltinMacs.parseMacsList((String)value);
        List unsupported = result.getUnsupportedFactories();
        ValidateUtils.checkTrue((lenient || GenericUtils.isEmpty((Collection)unsupported) ? 1 : 0) != 0, (String)"Unsupported MAC(s) (%s) in %s", (Object[])new Object[]{unsupported, value});
        List factories = BuiltinFactory.setUpFactories((boolean)ignoreUnsupported, (Collection)result.getParsedFactories());
        manager.setMacFactories((List)ValidateUtils.checkNotNullAndNotEmpty((Collection)factories, (String)"No known/supported MAC(s): %s", (Object[])new Object[]{value}));
        return manager;
    }

    public static <M extends AbstractFactoryManager> M configureKeyExchanges(M manager, PropertyResolver props, boolean lenient, Function<? super DHFactory, ? extends KeyExchangeFactory> xformer, boolean ignoreUnsupported) {
        Objects.requireNonNull(props, "No properties to configure");
        return SshConfigFileReader.configureKeyExchanges(manager, props.getString("KexAlgorithms"), lenient, xformer, ignoreUnsupported);
    }

    public static <M extends AbstractFactoryManager> M configureKeyExchanges(M manager, String value, boolean lenient, Function<? super DHFactory, ? extends KeyExchangeFactory> xformer, boolean ignoreUnsupported) {
        Objects.requireNonNull(manager, "No manager to configure");
        Objects.requireNonNull(xformer, "No DHFactory transformer");
        if (GenericUtils.isEmpty((CharSequence)value)) {
            return manager;
        }
        BuiltinDHFactories.ParseResult result = BuiltinDHFactories.parseDHFactoriesList(value);
        List<String> unsupported = result.getUnsupportedFactories();
        ValidateUtils.checkTrue((lenient || GenericUtils.isEmpty(unsupported) ? 1 : 0) != 0, (String)"Unsupported KEX(s) (%s) in %s", (Object[])new Object[]{unsupported, value});
        List factories = NamedFactory.setUpTransformedFactories((boolean)ignoreUnsupported, result.getParsedFactories(), xformer);
        manager.setKeyExchangeFactories((List)ValidateUtils.checkNotNullAndNotEmpty((Collection)factories, (String)"No known/supported KEXS(s): %s", (Object[])new Object[]{value}));
        return manager;
    }

    public static <M extends AbstractFactoryManager> M configureCompression(M manager, PropertyResolver props, boolean lenient, boolean ignoreUnsupported) {
        Objects.requireNonNull(manager, "No manager to configure");
        Objects.requireNonNull(props, "No properties to configure");
        String value = props.getString("Compression");
        if (GenericUtils.isEmpty((CharSequence)value)) {
            return manager;
        }
        CompressionConfigValue factory = CompressionConfigValue.fromName((String)value);
        ValidateUtils.checkTrue((lenient || factory != null ? 1 : 0) != 0, (String)"Unsupported compression value: %s", (Object)value);
        if (factory != null && factory.isSupported()) {
            manager.setCompressionFactories(Collections.singletonList(factory));
        }
        return manager;
    }

    public static <M extends AbstractFactoryManager> M configureCompression(M manager, String value, boolean lenient, boolean ignoreUnsupported) {
        Objects.requireNonNull(manager, "No manager to configure");
        if (GenericUtils.isEmpty((CharSequence)value)) {
            return manager;
        }
        CompressionConfigValue factory = CompressionConfigValue.fromName((String)value);
        if (factory != null) {
            if (ignoreUnsupported || factory.isSupported()) {
                manager.setCompressionFactories(Collections.singletonList(factory));
            }
        } else {
            BuiltinCompressions.ParseResult result = BuiltinCompressions.parseCompressionsList((String)value);
            List unsupported = result.getUnsupportedFactories();
            ValidateUtils.checkTrue((lenient || GenericUtils.isEmpty((Collection)unsupported) ? 1 : 0) != 0, (String)"Unsupported compressions(s) (%s) in %s", (Object[])new Object[]{unsupported, value});
            List factories = BuiltinFactory.setUpFactories((boolean)ignoreUnsupported, (Collection)result.getParsedFactories());
            if (GenericUtils.size((Collection)factories) > 0) {
                manager.setCompressionFactories(factories);
            }
        }
        return manager;
    }
}

