/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.oauth2.client;

import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OidcLogoutAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

final class OidcLogoutAuthenticationConverter
implements AuthenticationConverter {
    private static final String DEFAULT_LOGOUT_URI = "/logout/connect/back-channel/{registrationId}";
    private final Log logger = LogFactory.getLog(this.getClass());
    private final ClientRegistrationRepository clientRegistrationRepository;
    private RequestMatcher requestMatcher = new AntPathRequestMatcher("/logout/connect/back-channel/{registrationId}", "POST");

    OidcLogoutAuthenticationConverter(ClientRegistrationRepository clientRegistrationRepository) {
        Assert.notNull((Object)clientRegistrationRepository, (String)"clientRegistrationRepository cannot be null");
        this.clientRegistrationRepository = clientRegistrationRepository;
    }

    public Authentication convert(HttpServletRequest request) {
        RequestMatcher.MatchResult result = this.requestMatcher.matcher(request);
        if (!result.isMatch()) {
            return null;
        }
        String registrationId = (String)result.getVariables().get("registrationId");
        ClientRegistration clientRegistration = this.clientRegistrationRepository.findByRegistrationId(registrationId);
        if (clientRegistration == null) {
            this.logger.debug((Object)"Did not process OIDC Back-Channel Logout since no ClientRegistration was found");
            throw new OAuth2AuthenticationException("invalid_request");
        }
        String logoutToken = request.getParameter("logout_token");
        if (logoutToken == null) {
            this.logger.debug((Object)"Failed to process OIDC Back-Channel Logout since no logout token was found");
            throw new OAuth2AuthenticationException("invalid_request");
        }
        return new OidcLogoutAuthenticationToken(logoutToken, clientRegistration);
    }

    void setRequestMatcher(RequestMatcher requestMatcher) {
        Assert.notNull((Object)requestMatcher, (String)"requestMatcher cannot be null");
        this.requestMatcher = requestMatcher;
    }
}

