/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.header.writers;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.security.web.header.HeaderWriter;
import org.springframework.util.Assert;

public final class PermissionsPolicyHeaderWriter
implements HeaderWriter {
    private static final String PERMISSIONS_POLICY_HEADER = "Permissions-Policy";
    private String policy;

    public PermissionsPolicyHeaderWriter() {
    }

    public PermissionsPolicyHeaderWriter(String policy) {
        this.setPolicy(policy);
    }

    public void setPolicy(String policy) {
        Assert.hasLength((String)policy, (String)"policy can not be null or empty");
        this.policy = policy;
    }

    @Override
    public void writeHeaders(HttpServletRequest request, HttpServletResponse response) {
        if (!response.containsHeader(PERMISSIONS_POLICY_HEADER)) {
            response.setHeader(PERMISSIONS_POLICY_HEADER, this.policy);
        }
    }

    public String toString() {
        return this.getClass().getName() + " [policy=" + this.policy + "]";
    }
}

