/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance.impl;

import com.hazelcast.config.AdvancedNetworkConfig;
import com.hazelcast.config.AuditlogConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.EncryptionAtRestConfig;
import com.hazelcast.config.EndpointConfig;
import com.hazelcast.config.PersistenceConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SecurityConfig;
import com.hazelcast.config.security.RealmConfig;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

class NodeSecurityBanner {
    protected static final String SECURITY_BANNER_CATEGORY = "com.hazelcast.system.security";
    private final Config config;
    private final HazelcastProperties properties;
    private final boolean multicastUsed;
    private final ILogger securityLogger;
    private final boolean showEmoji;

    NodeSecurityBanner(Config config, HazelcastProperties properties, boolean multicastUsed, LoggingService loggingService) {
        this.config = config;
        this.properties = properties;
        this.multicastUsed = multicastUsed;
        this.securityLogger = loggingService.getLogger(SECURITY_BANNER_CATEGORY);
        this.showEmoji = properties.getBoolean(ClusterProperty.LOG_EMOJI_ENABLED);
    }

    public void printSecurityInfo() {
        boolean showInfoSecurityBanner;
        boolean bl = showInfoSecurityBanner = this.properties.getString(ClusterProperty.SECURITY_RECOMMENDATIONS) != null;
        if (showInfoSecurityBanner && this.securityLogger.isInfoEnabled() || this.securityLogger.isFineEnabled()) {
            this.printSecurityFeaturesInfo(this.config, showInfoSecurityBanner ? Level.INFO : Level.FINE);
        } else {
            this.securityLogger.info(String.format("Enable DEBUG/FINE log level for log category %s  or use -D%s system property to see %ssecurity recommendations and the status of current config.", SECURITY_BANNER_CATEGORY, ClusterProperty.SECURITY_RECOMMENDATIONS.getName(), this.getLockEmo()));
        }
    }

    private void printSecurityFeaturesInfo(Config config, Level logLevel) {
        AuditlogConfig auditlogConfig;
        boolean jetEnabled;
        StringBuilder sb = new StringBuilder("\n").append(this.getLockEmo()).append("Security recommendations and their status:");
        this.addSecurityFeatureCheck(sb, "Use a custom cluster name", !"dev".equals(config.getClusterName()));
        this.addSecurityFeatureCheck(sb, "Disable member multicast discovery/join method", !this.multicastUsed);
        AdvancedNetworkConfig advancedNetworkConfig = config.getAdvancedNetworkConfig();
        this.addSecurityFeatureCheck(sb, "Use advanced networking, separate client and member sockets", advancedNetworkConfig.isEnabled());
        boolean bindAny = this.properties.getBoolean(ClusterProperty.SOCKET_SERVER_BIND_ANY);
        this.addSecurityFeatureCheck(sb, "Bind Server sockets to a single network interface (disable " + ClusterProperty.SOCKET_SERVER_BIND_ANY.getName() + ")", !bindAny);
        Set<String> mcTrustedInterfaces = config.getManagementCenterConfig().getTrustedInterfaces();
        boolean mcTrustedInterfacesUsed = mcTrustedInterfaces != null && !mcTrustedInterfaces.isEmpty();
        this.addSecurityFeatureCheck(sb, "Allow Management Center operations only from specified remote addresses (use management-center/trusted-interfaces configuration)", mcTrustedInterfacesUsed);
        StringBuilder tlsSb = new StringBuilder();
        boolean tlsUsed = true;
        if (advancedNetworkConfig.isEnabled()) {
            for (Map.Entry<EndpointQualifier, EndpointConfig> e : advancedNetworkConfig.getEndpointConfigs().entrySet()) {
                tlsUsed = this.addAdvNetworkTlsInfo(tlsSb, e.getKey(), e.getValue().getSSLConfig()) && tlsUsed;
            }
        } else {
            SSLConfig sslConfig = config.getNetworkConfig().getSSLConfig();
            tlsUsed = this.addSecurityFeatureCheck(tlsSb, "Use TLS communication protection (Enterprise)", sslConfig != null && sslConfig.isEnabled());
        }
        if (jetEnabled = config.getJetConfig().isEnabled()) {
            boolean trustedEnv = tlsUsed || !bindAny;
            this.addSecurityFeatureCheck(sb, "Use Jet in trusted environments only (single network interface and/or TLS enabled)", trustedEnv);
            if (config.getJetConfig().isResourceUploadEnabled()) {
                this.addSecurityFeatureInfo(sb, "Jet resource upload is enabled. Any uploaded code can be executed within Hazelcast. Use this in trusted environments only.");
            }
        }
        if (config.getUserCodeDeploymentConfig().isEnabled()) {
            this.addSecurityFeatureInfo(sb, "User code deployment is enabled. Any uploaded code can be executed within Hazelcast. Use this in trusted environments only.");
        }
        this.addSecurityFeatureCheck(sb, "Disable scripting in the Management Center", !config.getManagementCenterConfig().isScriptingEnabled());
        this.addSecurityFeatureCheck(sb, "Disable console in the Management Center", !config.getManagementCenterConfig().isConsoleEnabled());
        SecurityConfig securityConfig = config.getSecurityConfig();
        boolean securityEnabled = securityConfig != null && securityConfig.isEnabled();
        this.addSecurityFeatureCheck(sb, "Enable Security (Enterprise)", securityEnabled);
        if (securityEnabled) {
            this.checkAuthnConfigured(sb, securityConfig, "member-authentication", securityConfig.getMemberRealm());
            this.checkAuthnConfigured(sb, securityConfig, "client-authentication", securityConfig.getClientRealm());
        }
        sb.append(tlsSb.toString());
        PersistenceConfig persistenceConfig = config.getPersistenceConfig();
        if (persistenceConfig != null && persistenceConfig.isEnabled()) {
            EncryptionAtRestConfig encryptionAtRestConfig = persistenceConfig.getEncryptionAtRestConfig();
            this.addSecurityFeatureCheck(sb, "Enable encryption-at-rest in the Persistence config (Enterprise)", encryptionAtRestConfig != null && encryptionAtRestConfig.isEnabled());
        }
        this.addSecurityFeatureCheck(sb, "Enable auditlog (Enterprise)", (auditlogConfig = config.getAuditlogConfig()) != null && auditlogConfig.isEnabled());
        sb.append("\nCheck the hazelcast-security-hardened.xml/yaml example config file to find why and how to configure these security related settings.\n");
        this.securityLogger.log(logLevel, sb.toString());
    }

    private void checkAuthnConfigured(StringBuilder sb, SecurityConfig securityConfig, String authName, String realmName) {
        RealmConfig rc = securityConfig.getRealmConfig(realmName);
        this.addSecurityFeatureCheck(sb, "Configure " + authName + " explicitly (Enterprise)", rc != null && rc.isAuthenticationConfigured());
    }

    private boolean addAdvNetworkTlsInfo(StringBuilder sb, EndpointQualifier endpoint, SSLConfig sslConfig) {
        return this.addSecurityFeatureCheck(sb, "Use TLS in the " + endpoint.toMetricsPrefixString() + " endpoint (Enterprise)", sslConfig != null && sslConfig.isEnabled());
    }

    private boolean addSecurityFeatureCheck(StringBuilder sb, String feature, boolean enabled) {
        sb.append("\n  ").append(enabled ? this.getCheckEmo() : this.getWarningEmo()).append(feature);
        return enabled;
    }

    private void addSecurityFeatureInfo(StringBuilder sb, String feature) {
        sb.append("\n  ").append(this.getInfoEmo()).append(feature);
    }

    private String getLockEmo() {
        return this.showEmoji ? "\ud83d\udd12 " : "";
    }

    private String getInfoEmo() {
        return this.showEmoji ? "\u2139\ufe0f " : "(i) ";
    }

    private String getWarningEmo() {
        return this.showEmoji ? "\u26a0\ufe0f " : "[ ] ";
    }

    private String getCheckEmo() {
        return this.showEmoji ? "\u2705 " : "[X] ";
    }
}

