/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.core;

import gov.nist.core.GenericObject;
import gov.nist.core.MultiValueMapImpl;
import gov.nist.core.NameValue;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;

public class DuplicateNameValueList
implements Serializable,
Cloneable {
    private MultiValueMapImpl<NameValue> nameValueMap = new MultiValueMapImpl();
    private static final long serialVersionUID = -5611332957903796952L;

    public String encode() {
        return this.encode(new StringBuilder()).toString();
    }

    public StringBuilder encode(StringBuilder buffer) {
        Iterator iterator;
        if (!this.nameValueMap.isEmpty() && (iterator = this.nameValueMap.values().iterator()).hasNext()) {
            while (true) {
                Object obj;
                if ((obj = iterator.next()) instanceof GenericObject) {
                    GenericObject gobj = (GenericObject)obj;
                    gobj.encode(buffer);
                } else {
                    buffer.append(obj.toString());
                }
                if (!iterator.hasNext()) break;
                buffer.append(";");
            }
        }
        return buffer;
    }

    public String toString() {
        return this.encode();
    }

    public void set(NameValue nv) {
        this.nameValueMap.put(nv.getName().toLowerCase(), nv);
    }

    public void set(String name, Object value) {
        NameValue nameValue = new NameValue(name, value);
        this.nameValueMap.put(name.toLowerCase(), nameValue);
    }

    public boolean equals(Object otherObject) {
        if (otherObject == null) {
            return false;
        }
        if (!otherObject.getClass().equals(this.getClass())) {
            return false;
        }
        DuplicateNameValueList other = (DuplicateNameValueList)otherObject;
        if (this.nameValueMap.size() != other.nameValueMap.size()) {
            return false;
        }
        for (String key : this.nameValueMap.keySet()) {
            Collection nv1 = this.getNameValue(key);
            Object nv2 = other.nameValueMap.get(key);
            if (nv2 == null) {
                return false;
            }
            if (nv2.equals(nv1)) continue;
            return false;
        }
        return true;
    }

    public Object getValue(String name) {
        Collection nv = this.getNameValue(name.toLowerCase());
        if (nv != null) {
            return nv;
        }
        return null;
    }

    public Collection getNameValue(String name) {
        return this.nameValueMap.get(name.toLowerCase());
    }

    public boolean hasNameValue(String name) {
        return this.nameValueMap.containsKey(name.toLowerCase());
    }

    public boolean delete(String name) {
        String lcName = name.toLowerCase();
        if (this.nameValueMap.containsKey(lcName)) {
            this.nameValueMap.remove(lcName);
            return true;
        }
        return false;
    }

    public Object clone() {
        DuplicateNameValueList retval = new DuplicateNameValueList();
        Iterator it = this.nameValueMap.values().iterator();
        while (it.hasNext()) {
            retval.set((NameValue)((NameValue)it.next()).clone());
        }
        return retval;
    }

    public Iterator<NameValue> iterator() {
        return this.nameValueMap.values().iterator();
    }

    public Iterator<String> getNames() {
        return this.nameValueMap.keySet().iterator();
    }

    public String getParameter(String name) {
        Object val = this.getValue(name);
        if (val == null) {
            return null;
        }
        if (val instanceof GenericObject) {
            return ((GenericObject)val).encode();
        }
        return val.toString();
    }

    public void clear() {
        this.nameValueMap.clear();
    }

    public boolean isEmpty() {
        return this.nameValueMap.isEmpty();
    }

    public NameValue put(String key, NameValue value) {
        return (NameValue)((Object)this.nameValueMap.put(key, value));
    }

    public NameValue remove(Object key) {
        return (NameValue)this.nameValueMap.remove(key);
    }

    public int size() {
        return this.nameValueMap.size();
    }

    public Collection<NameValue> values() {
        return this.nameValueMap.values();
    }

    public int hashCode() {
        return this.nameValueMap.keySet().hashCode();
    }
}

