/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CallQueueTooBigException;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.MultiActionResultTooLarge;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.RegionTooBusyException;
import org.apache.hadoop.hbase.RetryImmediatelyException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.ConnectionManager;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.exceptions.ClientExceptionsUtil;
import org.apache.hadoop.hbase.exceptions.RegionOpeningException;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.quotas.ThrottlingException;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestMetaCache {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final TableName TABLE_NAME = TableName.valueOf((String)"test_table");
    private static final byte[] FAMILY = Bytes.toBytes((String)"fam1");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"qual");
    private ConnectionManager.HConnectionImplementation conn;
    private HRegionServer badRS;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.set("hbase.client.retries.number", "1");
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.getHBaseCluster().waitForActiveAndReadyMaster();
        TEST_UTIL.waitUntilAllRegionsAssigned(TableName.META_TABLE_NAME);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setup() throws Exception {
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        cluster.getConfiguration().setStrings("hbase.regionserver.impl", new String[]{RegionServerWithFakeRpcServices.class.getName()});
        JVMClusterUtil.RegionServerThread rsThread = cluster.startRegionServer();
        rsThread.waitForServerOnline();
        this.badRS = rsThread.getRegionServer();
        Assert.assertTrue((boolean)(this.badRS.getRSRpcServices() instanceof FakeRSRpcServices));
        cluster.getConfiguration().setStrings("hbase.regionserver.impl", new String[]{HRegionServer.class.getName()});
        Assert.assertEquals((long)2L, (long)cluster.getRegionServerThreads().size());
        this.conn = (ConnectionManager.HConnectionImplementation)ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());
        HTableDescriptor table = new HTableDescriptor(TABLE_NAME);
        HColumnDescriptor fam = new HColumnDescriptor(FAMILY);
        fam.setMaxVersions(2);
        table.addFamily(fam);
        try (Admin admin = this.conn.getAdmin();){
            admin.createTable(table, HBaseTestingUtility.KEYS_FOR_HBA_CREATE_TABLE);
        }
        TEST_UTIL.waitUntilAllRegionsAssigned(TABLE_NAME);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testPreserveMetaCacheOnException() throws Exception {
        HTableInterface table = this.conn.getTable(TABLE_NAME);
        byte[] row = ((Region)this.badRS.getOnlineRegions(TABLE_NAME).get(0)).getRegionInfo().getStartKey();
        Put put = new Put(row);
        put.addColumn(FAMILY, QUALIFIER, Bytes.toBytes((int)10));
        Get get = new Get(row);
        Append append = new Append(row);
        append.add(FAMILY, QUALIFIER, Bytes.toBytes((int)11));
        Increment increment = new Increment(row);
        increment.addColumn(FAMILY, QUALIFIER, 10L);
        Delete delete = new Delete(row);
        delete.addColumn(FAMILY, QUALIFIER);
        RowMutations mutations = new RowMutations(row);
        mutations.add(put);
        mutations.add(delete);
        for (int i = 0; i < 50; ++i) {
            boolean success;
            IOException exp;
            block4: {
                exp = null;
                success = false;
                try {
                    table.put(put);
                    success = true;
                    table.get(get);
                    table.append(append);
                    table.increment(increment);
                    table.delete(delete);
                    table.mutateRow(mutations);
                }
                catch (IOException ex) {
                    if (!ClientExceptionsUtil.isMetaClearingException((Throwable)ex) && !success) break block4;
                    exp = ex;
                }
            }
            if (exp != null && ClientExceptionsUtil.isMetaClearingException((Throwable)exp)) {
                Assert.assertNull((Object)this.conn.getCachedLocation(TABLE_NAME, row));
                continue;
            }
            if (!success) continue;
            Assert.assertNotNull((Object)this.conn.getCachedLocation(TABLE_NAME, row));
        }
    }

    public static List<Throwable> metaCachePreservingExceptions() {
        return new ArrayList<Throwable>(){
            {
                this.add(new RegionOpeningException(" "));
                this.add(new RegionTooBusyException());
                this.add(new ThrottlingException(" "));
                this.add(new MultiActionResultTooLarge(" "));
                this.add(new RetryImmediatelyException(" "));
                this.add(new CallQueueTooBigException());
            }
        };
    }

    protected static class FakeRSRpcServices
    extends RSRpcServices {
        private int numReqs = -1;
        private int expCount = -1;
        private List<Throwable> metaCachePreservingExceptions = TestMetaCache.metaCachePreservingExceptions();

        public FakeRSRpcServices(HRegionServer rs) throws IOException {
            super(rs);
        }

        public ClientProtos.GetResponse get(RpcController controller, ClientProtos.GetRequest request) throws ServiceException {
            this.throwSomeExceptions();
            return super.get(controller, request);
        }

        public ClientProtos.MutateResponse mutate(RpcController controller, ClientProtos.MutateRequest request) throws ServiceException {
            this.throwSomeExceptions();
            return super.mutate(controller, request);
        }

        public ClientProtos.ScanResponse scan(RpcController controller, ClientProtos.ScanRequest request) throws ServiceException {
            this.throwSomeExceptions();
            return super.scan(controller, request);
        }

        private void throwSomeExceptions() throws ServiceException {
            ++this.numReqs;
            if (this.numReqs % 5 == 0) {
                return;
            }
            if (this.numReqs % 5 == 1 || this.numReqs % 5 == 2) {
                throw new ServiceException((Throwable)new NotServingRegionException());
            }
            ++this.expCount;
            Throwable t = this.metaCachePreservingExceptions.get(this.expCount % this.metaCachePreservingExceptions.size());
            throw new ServiceException(t);
        }
    }

    protected static class RegionServerWithFakeRpcServices
    extends HRegionServer {
        public RegionServerWithFakeRpcServices(Configuration conf, CoordinatedStateManager cp) throws IOException, InterruptedException {
            super(conf, cp);
        }

        protected RSRpcServices createRpcServices() throws IOException {
            return new FakeRSRpcServices(this);
        }
    }
}

