/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.replication;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.replication.ReplicationAdmin;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestReplicationAdminWithTwoDifferentZKClusters {
    private static Configuration conf1 = HBaseConfiguration.create();
    private static Configuration conf2;
    private static HBaseTestingUtility utility1;
    private static HBaseTestingUtility utility2;
    private static ReplicationAdmin admin;
    private static final TableName tableName;
    private static final byte[] famName;
    private static final String peerId = "peer1";

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf1.setBoolean("hbase.replication", true);
        utility1 = new HBaseTestingUtility(conf1);
        utility1.startMiniCluster();
        admin = new ReplicationAdmin(conf1);
        conf2 = HBaseConfiguration.create((Configuration)conf1);
        conf2.set("zookeeper.znode.parent", "/2");
        conf2.setInt("hbase.zookeeper.property.clientPort", 2182);
        utility2 = new HBaseTestingUtility(conf2);
        utility2.startMiniCluster();
        ReplicationPeerConfig config = new ReplicationPeerConfig();
        config.setClusterKey(utility2.getClusterKey());
        admin.addPeer(peerId, config, null);
        HTableDescriptor table = new HTableDescriptor(tableName);
        HColumnDescriptor fam = new HColumnDescriptor(famName);
        fam.setScope(1);
        table.addFamily(fam);
        utility1.getHBaseAdmin().createTable(table, HBaseTestingUtility.KEYS_FOR_HBA_CREATE_TABLE);
        utility1.waitUntilAllRegionsAssigned(tableName);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        admin.removePeer(peerId);
        admin.close();
        utility1.deleteTable(tableName);
        utility2.deleteTable(tableName);
        utility2.shutdownMiniCluster();
        utility1.shutdownMiniCluster();
    }

    @Test
    public void testEnableTableReplication() throws Exception {
        admin.enableTableRep(tableName);
        Assert.assertTrue((boolean)utility2.getHBaseAdmin().tableExists(tableName));
    }

    @Test
    public void testDisableTableReplication() throws Exception {
        admin.disableTableRep(tableName);
        Assert.assertTrue((boolean)utility2.getHBaseAdmin().tableExists(tableName));
    }

    static {
        tableName = TableName.valueOf((String)"test");
        famName = Bytes.toBytes((String)"f");
    }
}

