/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.master.AssignmentVerificationReport;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.RegionPlacementMaintainer;
import org.apache.hadoop.hbase.master.balancer.FavoredNodeAssignmentHelper;
import org.apache.hadoop.hbase.master.balancer.FavoredNodeLoadBalancer;
import org.apache.hadoop.hbase.master.balancer.FavoredNodesPlan;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.zookeeper.KeeperException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestRegionPlacement {
    private static final Log LOG = LogFactory.getLog(TestRegionPlacement.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final int SLAVES = 10;
    private static Connection CONNECTION;
    private static Admin admin;
    private static RegionPlacementMaintainer rp;
    private static FavoredNodesPlan.Position[] positions;
    private int lastRegionOnPrimaryRSCount = 0;
    private int REGION_NUM = 10;
    private Map<HRegionInfo, ServerName[]> favoredNodesAssignmentPlan = new HashMap<HRegionInfo, ServerName[]>();

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setClass("hbase.master.loadbalancer.class", FavoredNodeLoadBalancer.class, LoadBalancer.class);
        conf.setBoolean("hbase.tests.use.shortcircuit.reads", false);
        TEST_UTIL.startMiniCluster(10);
        CONNECTION = TEST_UTIL.getConnection();
        admin = CONNECTION.getAdmin();
        rp = new RegionPlacementMaintainer(conf);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Ignore(value="Test for unfinished feature")
    @Test
    public void testRegionPlacement() throws Exception {
        String tableStr = "testRegionAssignment";
        TableName table = TableName.valueOf((String)tableStr);
        TestRegionPlacement.createTable(table, this.REGION_NUM);
        TEST_UTIL.waitTableAvailable(table);
        this.verifyRegionOnPrimaryRS(this.REGION_NUM);
        FavoredNodesPlan currentPlan = rp.getRegionAssignmentSnapshot().getExistingAssignmentPlan();
        this.verifyRegionServerUpdated(currentPlan);
        FavoredNodesPlan shuffledPlan = this.shuffleAssignmentPlan(currentPlan, FavoredNodesPlan.Position.SECONDARY, FavoredNodesPlan.Position.TERTIARY);
        rp.updateAssignmentPlan(shuffledPlan);
        this.verifyRegionAssignment(shuffledPlan, 0, this.REGION_NUM);
        shuffledPlan = this.shuffleAssignmentPlan(currentPlan, FavoredNodesPlan.Position.PRIMARY, FavoredNodesPlan.Position.SECONDARY);
        rp.updateAssignmentPlan(shuffledPlan);
        this.verifyRegionAssignment(shuffledPlan, this.REGION_NUM, this.REGION_NUM);
        RegionPlacementMaintainer rp = new RegionPlacementMaintainer(TEST_UTIL.getConfiguration());
        rp.setTargetTableName(new String[]{tableStr});
        List reports = rp.verifyRegionPlacement(false);
        AssignmentVerificationReport report = (AssignmentVerificationReport)reports.get(0);
        Assert.assertTrue((report.getRegionsWithoutValidFavoredNodes().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((report.getNonFavoredAssignedRegions().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((report.getTotalFavoredAssignments() >= this.REGION_NUM ? 1 : 0) != 0);
        Assert.assertTrue((report.getNumRegionsOnFavoredNodeByPosition(FavoredNodesPlan.Position.PRIMARY) != 0 ? 1 : 0) != 0);
        Assert.assertTrue((report.getNumRegionsOnFavoredNodeByPosition(FavoredNodesPlan.Position.SECONDARY) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((report.getNumRegionsOnFavoredNodeByPosition(FavoredNodesPlan.Position.TERTIARY) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((report.getUnassignedRegions().size() == 0 ? 1 : 0) != 0);
        this.killRandomServerAndVerifyAssignment();
        reports = rp.verifyRegionPlacement(false);
        report = (AssignmentVerificationReport)reports.get(0);
        Assert.assertTrue((report.getRegionsWithoutValidFavoredNodes().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((report.getNonFavoredAssignedRegions().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((report.getTotalFavoredAssignments() >= this.REGION_NUM ? 1 : 0) != 0);
        Assert.assertTrue((report.getNumRegionsOnFavoredNodeByPosition(FavoredNodesPlan.Position.PRIMARY) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("secondary " + report.getNumRegionsOnFavoredNodeByPosition(FavoredNodesPlan.Position.SECONDARY) + " tertiary " + report.getNumRegionsOnFavoredNodeByPosition(FavoredNodesPlan.Position.TERTIARY)), (report.getNumRegionsOnFavoredNodeByPosition(FavoredNodesPlan.Position.SECONDARY) > 0 || report.getNumRegionsOnFavoredNodeByPosition(FavoredNodesPlan.Position.TERTIARY) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((report.getNumRegionsOnFavoredNodeByPosition(FavoredNodesPlan.Position.PRIMARY) + report.getNumRegionsOnFavoredNodeByPosition(FavoredNodesPlan.Position.SECONDARY) + report.getNumRegionsOnFavoredNodeByPosition(FavoredNodesPlan.Position.TERTIARY) == this.REGION_NUM ? 1 : 0) != 0);
        RegionPlacementMaintainer.printAssignmentPlan((FavoredNodesPlan)currentPlan);
    }

    private void killRandomServerAndVerifyAssignment() throws IOException, InterruptedException, KeeperException {
        int n;
        ServerName serverToKill = null;
        int killIndex = 0;
        Random random = new Random(System.currentTimeMillis());
        ServerName metaServer = TEST_UTIL.getHBaseCluster().getServerHoldingMeta();
        LOG.debug((Object)("Server holding meta " + metaServer));
        boolean isNamespaceServer = false;
        block0: do {
            killIndex = random.nextInt(10);
            serverToKill = TEST_UTIL.getHBaseCluster().getRegionServer(killIndex).getServerName();
            Collection regs = TEST_UTIL.getHBaseCluster().getRegionServer(killIndex).getOnlineRegionsLocalContext();
            isNamespaceServer = false;
            for (Region region : regs) {
                if (!region.getRegionInfo().getTable().getNamespaceAsString().equals(NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR)) continue;
                isNamespaceServer = true;
                continue block0;
            }
        } while (ServerName.isSameHostnameAndPort((ServerName)metaServer, (ServerName)serverToKill) || isNamespaceServer || TEST_UTIL.getHBaseCluster().getRegionServer(killIndex).getNumberOfOnlineRegions() == 0);
        LOG.debug((Object)("Stopping RS " + serverToKill));
        HashMap regionsToVerify = new HashMap();
        for (Map.Entry entry : this.favoredNodesAssignmentPlan.entrySet()) {
            ServerName s = ((ServerName[])entry.getValue())[0];
            if (!ServerName.isSameHostnameAndPort((ServerName)s, (ServerName)serverToKill)) continue;
            regionsToVerify.put(entry.getKey(), new Pair((Object)((ServerName[])entry.getValue())[1], (Object)((ServerName[])entry.getValue())[2]));
            LOG.debug((Object)("Adding " + entry.getKey() + " with sedcondary/tertiary " + ((ServerName[])entry.getValue())[1] + " " + ((ServerName[])entry.getValue())[2]));
        }
        int orig = TestRegionPlacement.TEST_UTIL.getHBaseCluster().getMaster().assignmentManager.getNumRegionsOpened();
        TEST_UTIL.getHBaseCluster().stopRegionServer(serverToKill);
        TEST_UTIL.getHBaseCluster().waitForRegionServerToStop(serverToKill, 60000L);
        int n2 = TestRegionPlacement.TEST_UTIL.getHBaseCluster().getMaster().assignmentManager.getNumRegionsOpened();
        while (n - orig < regionsToVerify.size()) {
            LOG.debug((Object)("Waiting for " + regionsToVerify.size() + " to come online " + " Current #regions " + n + " Original #regions " + orig));
            Thread.sleep(200L);
            n = TestRegionPlacement.TEST_UTIL.getHBaseCluster().getMaster().assignmentManager.getNumRegionsOpened();
        }
        for (Map.Entry entry : regionsToVerify.entrySet()) {
            ServerName newDestination = TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getRegionServerOfRegion((HRegionInfo)entry.getKey());
            Pair secondaryTertiaryServers = (Pair)entry.getValue();
            LOG.debug((Object)("New destination for region " + ((HRegionInfo)entry.getKey()).getEncodedName() + " " + newDestination + ". Secondary/Tertiary are " + secondaryTertiaryServers.getFirst() + "/" + secondaryTertiaryServers.getSecond()));
            if (ServerName.isSameHostnameAndPort((ServerName)newDestination, (ServerName)((ServerName)secondaryTertiaryServers.getFirst())) || ServerName.isSameHostnameAndPort((ServerName)newDestination, (ServerName)((ServerName)secondaryTertiaryServers.getSecond()))) continue;
            Assert.fail((String)("Region " + entry.getKey() + " not present on any of the expected servers"));
        }
        TEST_UTIL.getHBaseCluster().startRegionServer();
    }

    @Ignore(value="Test for unfinished feature")
    @Test
    public void testRandomizedMatrix() {
        int rows = 100;
        int cols = 100;
        float[][] matrix = new float[rows][cols];
        Random random = new Random();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                matrix[i][j] = random.nextFloat();
            }
        }
        RegionPlacementMaintainer.RandomizedMatrix rm = new RegionPlacementMaintainer.RandomizedMatrix(rows, cols);
        float[][] transformed = rm.transform(matrix);
        float[][] invertedTransformed = rm.invert(transformed);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                if (matrix[i][j] == invertedTransformed[i][j]) continue;
                throw new RuntimeException();
            }
        }
        int[] transformedIndices = new int[rows];
        for (int i = 0; i < rows; ++i) {
            transformedIndices[i] = random.nextInt(cols);
        }
        int[] invertedTransformedIndices = rm.invertIndices(transformedIndices);
        float[] transformedValues = new float[rows];
        float[] invertedTransformedValues = new float[rows];
        for (int i = 0; i < rows; ++i) {
            transformedValues[i] = transformed[i][transformedIndices[i]];
            invertedTransformedValues[i] = matrix[i][invertedTransformedIndices[i]];
        }
        Arrays.sort(transformedValues);
        Arrays.sort(invertedTransformedValues);
        if (!Arrays.equals(transformedValues, invertedTransformedValues)) {
            throw new RuntimeException();
        }
    }

    private FavoredNodesPlan shuffleAssignmentPlan(FavoredNodesPlan plan, FavoredNodesPlan.Position p1, FavoredNodesPlan.Position p2) {
        FavoredNodesPlan shuffledPlan = new FavoredNodesPlan();
        for (Map.Entry entry : plan.getAssignmentMap().entrySet()) {
            HRegionInfo region = (HRegionInfo)entry.getKey();
            ArrayList shuffledServerList = new ArrayList();
            shuffledServerList.addAll((Collection)entry.getValue());
            shuffledServerList.set(p1.ordinal(), ((List)entry.getValue()).get(p2.ordinal()));
            shuffledServerList.set(p2.ordinal(), ((List)entry.getValue()).get(p1.ordinal()));
            shuffledPlan.updateAssignmentPlan(region, shuffledServerList);
        }
        return shuffledPlan;
    }

    private void verifyRegionAssignment(FavoredNodesPlan plan, int regionMovementNum, int numRegionsOnPrimaryRS) throws InterruptedException, IOException {
        this.verifyMETAUpdated(plan);
        this.verifyRegionMovementNum(regionMovementNum);
        this.verifyRegionOnPrimaryRS(numRegionsOnPrimaryRS);
        this.verifyRegionServerUpdated(plan);
    }

    private void verifyMETAUpdated(FavoredNodesPlan expectedPlan) throws IOException {
        FavoredNodesPlan planFromMETA = rp.getRegionAssignmentSnapshot().getExistingAssignmentPlan();
        Assert.assertTrue((String)"The assignment plan is NOT consistent with the expected plan ", (boolean)planFromMETA.equals((Object)expectedPlan));
    }

    private void verifyRegionMovementNum(int expected) throws InterruptedException, IOException {
        int currentRegionOpened;
        int regionMovement;
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        HMaster m = cluster.getMaster();
        int lastRegionOpenedCount = m.assignmentManager.getNumRegionsOpened();
        m.balance();
        int retry = 10;
        long sleep = 3000L;
        int attempt = 0;
        do {
            currentRegionOpened = m.assignmentManager.getNumRegionsOpened();
            regionMovement = currentRegionOpened - lastRegionOpenedCount;
            LOG.debug((Object)("There are " + regionMovement + "/" + expected + " regions moved after " + attempt + " attempts"));
            Thread.sleep((long)(++attempt) * sleep);
        } while (regionMovement != expected && attempt <= retry);
        lastRegionOpenedCount = currentRegionOpened;
        Assert.assertEquals((String)("There are only " + regionMovement + " instead of " + expected + " region movement for " + attempt + " attempts"), (long)regionMovement, (long)expected);
    }

    private void verifyRegionOnPrimaryRS(int expectedNum) throws IOException {
        this.lastRegionOnPrimaryRSCount = this.getNumRegionisOnPrimaryRS();
        Assert.assertEquals((String)("Only " + expectedNum + " of user regions running " + "on the primary region server"), (long)expectedNum, (long)this.lastRegionOnPrimaryRSCount);
    }

    private void verifyRegionServerUpdated(FavoredNodesPlan plan) throws IOException {
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        for (int i = 0; i < 10; ++i) {
            HRegionServer rs = cluster.getRegionServer(i);
            for (Region region : rs.getOnlineRegions(TableName.valueOf((String)"testRegionAssignment"))) {
                InetSocketAddress[] favoredSocketAddress = rs.getFavoredNodesForRegion(region.getRegionInfo().getEncodedName());
                List favoredServerList = (List)plan.getAssignmentMap().get(region.getRegionInfo());
                if (favoredServerList == null) {
                    HTableDescriptor desc = region.getTableDesc();
                    Assert.assertNull((Object)favoredSocketAddress);
                    Assert.assertTrue((String)("User region " + region.getTableDesc().getTableName() + " should have favored nodes"), (desc.isRootRegion() || desc.isMetaRegion() ? 1 : 0) != 0);
                    continue;
                }
                Assert.assertTrue((favoredSocketAddress.length == favoredServerList.size() ? 1 : 0) != 0);
                Assert.assertTrue((favoredServerList.size() > 0 ? 1 : 0) != 0);
                for (int j = 0; j < favoredServerList.size(); ++j) {
                    InetSocketAddress addrFromRS = favoredSocketAddress[j];
                    InetSocketAddress addrFromPlan = InetSocketAddress.createUnresolved(((ServerName)favoredServerList.get(j)).getHostname(), ((ServerName)favoredServerList.get(j)).getPort());
                    Assert.assertNotNull((Object)addrFromRS);
                    Assert.assertNotNull((Object)addrFromPlan);
                    Assert.assertTrue((String)("Region server " + rs.getServerName().getHostAndPort() + " has the " + positions[j] + " for region " + region.getRegionInfo().getRegionNameAsString() + " is " + addrFromRS + " which is inconsistent with the plan " + addrFromPlan), (boolean)addrFromRS.equals(addrFromPlan));
                }
            }
        }
    }

    private int getNumRegionisOnPrimaryRS() throws IOException {
        final AtomicInteger regionOnPrimaryNum = new AtomicInteger(0);
        final AtomicInteger totalRegionNum = new AtomicInteger(0);
        LOG.info((Object)"The start of region placement verification");
        MetaScanner.MetaScannerVisitor visitor = new MetaScanner.MetaScannerVisitor(){

            public boolean processRow(Result result) throws IOException {
                try {
                    HRegionInfo info = MetaScanner.getHRegionInfo((Result)result);
                    if (info.getTable().getNamespaceAsString().equals(NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR)) {
                        return true;
                    }
                    byte[] server = result.getValue(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER);
                    byte[] favoredNodes = result.getValue(HConstants.CATALOG_FAMILY, FavoredNodeAssignmentHelper.FAVOREDNODES_QUALIFIER);
                    ServerName[] favoredServerList = FavoredNodeAssignmentHelper.getFavoredNodesList((byte[])favoredNodes);
                    TestRegionPlacement.this.favoredNodesAssignmentPlan.put(info, favoredServerList);
                    FavoredNodesPlan.Position[] positions = FavoredNodesPlan.Position.values();
                    if (info != null) {
                        totalRegionNum.incrementAndGet();
                        if (server != null) {
                            ServerName serverName = ServerName.valueOf((String)Bytes.toString((byte[])server), (long)-1L);
                            if (favoredNodes != null) {
                                String placement = "[NOT FAVORED NODE]";
                                for (int i = 0; i < favoredServerList.length; ++i) {
                                    if (!favoredServerList[i].equals((Object)serverName)) continue;
                                    placement = positions[i].toString();
                                    if (i != FavoredNodesPlan.Position.PRIMARY.ordinal()) break;
                                    regionOnPrimaryNum.incrementAndGet();
                                    break;
                                }
                                LOG.info((Object)(info.getRegionNameAsString() + " on " + serverName + " " + placement));
                            } else {
                                LOG.info((Object)(info.getRegionNameAsString() + " running on " + serverName + " but there is no favored region server"));
                            }
                        } else {
                            LOG.info((Object)(info.getRegionNameAsString() + " not assigned to any server"));
                        }
                    }
                    return true;
                }
                catch (RuntimeException e) {
                    LOG.error((Object)("Result=" + result));
                    throw e;
                }
            }

            public void close() throws IOException {
            }
        };
        MetaScanner.metaScan((Connection)CONNECTION, (MetaScanner.MetaScannerVisitor)visitor);
        LOG.info((Object)("There are " + regionOnPrimaryNum.intValue() + " out of " + totalRegionNum.intValue() + " regions running on the primary" + " region servers"));
        return regionOnPrimaryNum.intValue();
    }

    private static void createTable(TableName tableName, int regionNum) throws IOException {
        int expectedRegions = regionNum;
        byte[][] splitKeys = new byte[expectedRegions - 1][];
        for (int i = 1; i < expectedRegions; ++i) {
            byte splitKey = (byte)i;
            splitKeys[i - 1] = new byte[]{splitKey, splitKey, splitKey};
        }
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        admin.createTable(desc, (byte[][])splitKeys);
        HTable ht = (HTable)CONNECTION.getTable(tableName);
        NavigableMap regions = ht.getRegionLocations();
        Assert.assertEquals((String)("Tried to create " + expectedRegions + " regions " + "but only found " + regions.size()), (long)expectedRegions, (long)regions.size());
        ht.close();
    }

    static {
        positions = FavoredNodesPlan.Position.values();
    }
}

