/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ProcedureInfo;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.procedure.CreateTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.master.procedure.ProcedurePrepareLatch;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ModifyRegionUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestCreateTableProcedure {
    private static final Log LOG = LogFactory.getLog(TestCreateTableProcedure.class);
    protected static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static long nonceGroup = 0L;
    private static long nonce = 0L;

    private static void setupConf(Configuration conf) {
        conf.setInt("hbase.master.procedure.threads", 1);
    }

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestCreateTableProcedure.setupConf(UTIL.getConfiguration());
        UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception e) {
            LOG.warn((Object)"failure shutting down cluster", (Throwable)e);
        }
    }

    @Before
    public void setup() throws Exception {
        this.resetProcExecutorTestingKillFlag();
        nonceGroup = MasterProcedureTestingUtility.generateNonceGroup(UTIL.getHBaseCluster().getMaster());
        nonce = MasterProcedureTestingUtility.generateNonce(UTIL.getHBaseCluster().getMaster());
    }

    @After
    public void tearDown() throws Exception {
        this.resetProcExecutorTestingKillFlag();
        for (HTableDescriptor htd : UTIL.getHBaseAdmin().listTables()) {
            LOG.info((Object)("Tear down, remove table=" + htd.getTableName()));
            UTIL.deleteTable(htd.getTableName());
        }
    }

    private void resetProcExecutorTestingKillFlag() {
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)false);
        Assert.assertTrue((String)"expected executor to be running", (boolean)procExec.isRunning());
    }

    @Test(timeout=60000L)
    public void testSimpleCreate() throws Exception {
        TableName tableName = TableName.valueOf((String)"testSimpleCreate");
        byte[][] splitKeys = null;
        this.testSimpleCreate(tableName, splitKeys);
    }

    @Test(timeout=60000L)
    public void testSimpleCreateWithSplits() throws Exception {
        TableName tableName = TableName.valueOf((String)"testSimpleCreateWithSplits");
        byte[][] splitKeys = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c")};
        this.testSimpleCreate(tableName, splitKeys);
    }

    private void testSimpleCreate(TableName tableName, byte[][] splitKeys) throws Exception {
        HRegionInfo[] regions = MasterProcedureTestingUtility.createTable(this.getMasterProcedureExecutor(), tableName, splitKeys, "f1", "f2");
        MasterProcedureTestingUtility.validateTableCreation(UTIL.getHBaseCluster().getMaster(), tableName, regions, "f1", "f2");
    }

    @Test(timeout=60000L, expected=TableExistsException.class)
    public void testCreateExisting() throws Exception {
        TableName tableName = TableName.valueOf((String)"testCreateExisting");
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        HTableDescriptor htd = MasterProcedureTestingUtility.createHTD(tableName, "f");
        HRegionInfo[] regions = ModifyRegionUtils.createHRegionInfos((HTableDescriptor)htd, (byte[][])null);
        long procId1 = procExec.submitProcedure((Procedure)new CreateTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), htd, regions), nonceGroup, nonce);
        ProcedurePrepareLatch.CompatibilityLatch latch2 = new ProcedurePrepareLatch.CompatibilityLatch();
        long procId2 = procExec.submitProcedure((Procedure)new CreateTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), htd, regions, (ProcedurePrepareLatch)latch2), nonceGroup + 1L, nonce + 1L);
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId1);
        ProcedureTestingUtility.assertProcNotFailed((ProcedureInfo)procExec.getResult(procId1));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId2);
        latch2.await();
    }

    @Test(timeout=60000L)
    public void testCreateTwiceWithSameNonce() throws Exception {
        TableName tableName = TableName.valueOf((String)"testCreateTwiceWithSameNonce");
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        HTableDescriptor htd = MasterProcedureTestingUtility.createHTD(tableName, "f");
        HRegionInfo[] regions = ModifyRegionUtils.createHRegionInfos((HTableDescriptor)htd, (byte[][])null);
        long procId1 = procExec.submitProcedure((Procedure)new CreateTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), htd, regions), nonceGroup, nonce);
        long procId2 = procExec.submitProcedure((Procedure)new CreateTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), htd, regions), nonceGroup, nonce);
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId1);
        ProcedureTestingUtility.assertProcNotFailed((ProcedureInfo)procExec.getResult(procId1));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId2);
        ProcedureTestingUtility.assertProcNotFailed((ProcedureInfo)procExec.getResult(procId2));
        Assert.assertTrue((procId1 == procId2 ? 1 : 0) != 0);
    }

    @Test(timeout=60000L)
    public void testRecoveryAndDoubleExecution() throws Exception {
        TableName tableName = TableName.valueOf((String)"testRecoveryAndDoubleExecution");
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        byte[][] splitKeys = null;
        HTableDescriptor htd = MasterProcedureTestingUtility.createHTD(tableName, "f1", "f2");
        HRegionInfo[] regions = ModifyRegionUtils.createHRegionInfos((HTableDescriptor)htd, (byte[][])splitKeys);
        long procId = procExec.submitProcedure((Procedure)new CreateTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), htd, regions), nonceGroup, nonce);
        MasterProcedureTestingUtility.testRecoveryAndDoubleExecution(procExec, procId, 6, MasterProcedureProtos.CreateTableState.values());
        MasterProcedureTestingUtility.validateTableCreation(UTIL.getHBaseCluster().getMaster(), tableName, regions, "f1", "f2");
    }

    @Test(timeout=90000L)
    public void testRollbackAndDoubleExecution() throws Exception {
        TableName tableName = TableName.valueOf((String)"testRollbackAndDoubleExecution");
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        byte[][] splitKeys = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c")};
        HTableDescriptor htd = MasterProcedureTestingUtility.createHTD(tableName, "f1", "f2");
        htd.setRegionReplication(3);
        HRegionInfo[] regions = ModifyRegionUtils.createHRegionInfos((HTableDescriptor)htd, (byte[][])splitKeys);
        long procId = procExec.submitProcedure((Procedure)new CreateTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), htd, regions), nonceGroup, nonce);
        MasterProcedureTestingUtility.testRollbackAndDoubleExecution(procExec, procId, 4, MasterProcedureProtos.CreateTableState.values());
        MasterProcedureTestingUtility.validateTableDeletion(UTIL.getHBaseCluster().getMaster(), tableName, regions, "f1", "f2");
        this.resetProcExecutorTestingKillFlag();
        this.testSimpleCreate(tableName, splitKeys);
    }

    @Test(timeout=90000L)
    public void testRollbackRetriableFailure() throws Exception {
        TableName tableName = TableName.valueOf((String)"testRollbackRetriableFailure");
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        byte[][] splitKeys = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c")};
        HTableDescriptor htd = MasterProcedureTestingUtility.createHTD(tableName, "f1", "f2");
        HRegionInfo[] regions = ModifyRegionUtils.createHRegionInfos((HTableDescriptor)htd, (byte[][])splitKeys);
        long procId = procExec.submitProcedure((Procedure)new FaultyCreateTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), htd, regions), nonceGroup, nonce);
        MasterProcedureTestingUtility.testRollbackRetriableFailure(procExec, procId, 4, MasterProcedureProtos.CreateTableState.values());
        MasterProcedureTestingUtility.validateTableDeletion(UTIL.getHBaseCluster().getMaster(), tableName, regions, "f1", "f2");
        this.resetProcExecutorTestingKillFlag();
        this.testSimpleCreate(tableName, splitKeys);
    }

    private ProcedureExecutor<MasterProcedureEnv> getMasterProcedureExecutor() {
        return UTIL.getHBaseCluster().getMaster().getMasterProcedureExecutor();
    }

    public static class FaultyCreateTableProcedure
    extends CreateTableProcedure {
        private int retries = 0;

        public FaultyCreateTableProcedure() {
        }

        public FaultyCreateTableProcedure(MasterProcedureEnv env, HTableDescriptor hTableDescriptor, HRegionInfo[] newRegions) throws IOException {
            super(env, hTableDescriptor, newRegions);
        }

        protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.CreateTableState state) throws IOException {
            if (this.retries++ < 3) {
                LOG.info((Object)("inject rollback failure state=" + state));
                throw new IOException("injected failure number " + this.retries);
            }
            super.rollbackState(env, state);
            this.retries = 0;
        }
    }
}

