/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tool;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.tool.Canary;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Appender;
import org.apache.log4j.LogManager;
import org.apache.log4j.spi.LoggingEvent;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
@Category(value={MediumTests.class})
public class TestCanaryTool {
    private HBaseTestingUtility testingUtility;
    private static final byte[] FAMILY = Bytes.toBytes((String)"f");
    private static final byte[] COLUMN = Bytes.toBytes((String)"col");
    @Mock
    Appender mockAppender;

    @Before
    public void setUp() throws Exception {
        this.testingUtility = new HBaseTestingUtility();
        this.testingUtility.startMiniCluster();
        LogManager.getRootLogger().addAppender(this.mockAppender);
    }

    @After
    public void tearDown() throws Exception {
        this.testingUtility.shutdownMiniCluster();
        LogManager.getRootLogger().removeAppender(this.mockAppender);
    }

    @Test
    public void testBasicCanaryWorks() throws Exception {
        TableName tableName = TableName.valueOf((String)"testTable");
        HTable table = this.testingUtility.createTable(tableName, (byte[][])new byte[][]{FAMILY});
        for (int i = 0; i < 1000; ++i) {
            byte[] iBytes = Bytes.toBytes((int)i);
            Put p = new Put(iBytes);
            p.addColumn(FAMILY, COLUMN, iBytes);
            table.put(p);
        }
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
        Canary.RegionServerStdOutSink sink = (Canary.RegionServerStdOutSink)Mockito.spy((Object)new Canary.RegionServerStdOutSink());
        Canary canary = new Canary((ExecutorService)executor, (Canary.Sink)sink);
        String[] args = new String[]{"-t", "10000", "testTable"};
        ToolRunner.run((Configuration)this.testingUtility.getConfiguration(), (Tool)canary, (String[])args);
        ((Canary.RegionServerStdOutSink)Mockito.verify((Object)sink, (VerificationMode)Mockito.atLeastOnce())).publishReadTiming((HRegionInfo)Matchers.isA(HRegionInfo.class), (HColumnDescriptor)Matchers.isA(HColumnDescriptor.class), Matchers.anyLong());
    }

    @Test
    public void testRegionserverNoRegions() throws Exception {
        this.runRegionserverCanary();
        ((Appender)Mockito.verify((Object)this.mockAppender)).doAppend((LoggingEvent)Matchers.argThat((Matcher)new ArgumentMatcher<LoggingEvent>(){

            public boolean matches(Object argument) {
                return ((LoggingEvent)argument).getRenderedMessage().contains("Regionserver not serving any regions");
            }
        }));
    }

    @Test
    public void testRegionserverWithRegions() throws Exception {
        TableName tableName = TableName.valueOf((String)"testTable");
        this.testingUtility.createTable(tableName, (byte[][])new byte[][]{FAMILY});
        this.runRegionserverCanary();
        ((Appender)Mockito.verify((Object)this.mockAppender, (VerificationMode)Mockito.never())).doAppend((LoggingEvent)Matchers.argThat((Matcher)new ArgumentMatcher<LoggingEvent>(){

            public boolean matches(Object argument) {
                return ((LoggingEvent)argument).getRenderedMessage().contains("Regionserver not serving any regions");
            }
        }));
    }

    private void runRegionserverCanary() throws Exception {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
        Canary canary = new Canary((ExecutorService)executor, (Canary.Sink)new Canary.RegionServerStdOutSink());
        String[] args = new String[]{"-t", "10000", "-regionserver"};
        ToolRunner.run((Configuration)this.testingUtility.getConfiguration(), (Tool)canary, (String[])args);
    }
}

