/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.reader.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineFilter;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TimelineFilterList
extends TimelineFilter {
    private Operator operator;
    private List<TimelineFilter> filterList = new ArrayList<TimelineFilter>();

    public TimelineFilterList(TimelineFilter ... filters) {
        this(Operator.AND, filters);
    }

    public TimelineFilterList() {
        this(Operator.AND);
    }

    public TimelineFilterList(Operator op) {
        this.operator = op;
    }

    public TimelineFilterList(Operator op, TimelineFilter ... filters) {
        this.operator = op;
        this.filterList = new ArrayList<TimelineFilter>(Arrays.asList(filters));
    }

    @Override
    public TimelineFilter.TimelineFilterType getFilterType() {
        return TimelineFilter.TimelineFilterType.LIST;
    }

    public List<TimelineFilter> getFilterList() {
        return this.filterList;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator op) {
        this.operator = op;
    }

    public void addFilter(TimelineFilter filter) {
        this.filterList.add(filter);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.filterList == null ? 0 : this.filterList.hashCode());
        result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimelineFilterList other = (TimelineFilterList)obj;
        if (this.operator != other.operator) {
            return false;
        }
        return !(this.filterList == null ? other.filterList != null : !this.filterList.equals(other.filterList));
    }

    @Override
    public String toString() {
        return String.format("TimelineFilterList %s (%d): %s", new Object[]{this.operator, this.filterList.size(), this.filterList.toString()});
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static enum Operator {
        AND,
        OR;

    }
}

