/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.timelineservice.storage.SchemaCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimelineSchemaCreator
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(TimelineSchemaCreator.class);

    public static void main(String[] args) {
        try {
            int status = ToolRunner.run((Configuration)new YarnConfiguration(), (Tool)new TimelineSchemaCreator(), (String[])args);
            System.exit(status);
        }
        catch (Exception e) {
            LOG.error("Error while creating Timeline Schema : ", (Throwable)e);
        }
    }

    public int run(String[] args) throws Exception {
        Configuration conf = this.getConf();
        return this.createTimelineSchema(args, conf);
    }

    @VisibleForTesting
    int createTimelineSchema(String[] args, Configuration conf) throws Exception {
        String schemaCreatorClassName = conf.get("yarn.timeline-service.schema-creator.class", "org.apache.hadoop.yarn.server.timelineservice.storage.HBaseTimelineSchemaCreator");
        LOG.info("Using {} for creating Timeline Service Schema ", (Object)schemaCreatorClassName);
        try {
            Class<?> schemaCreatorClass = Class.forName(schemaCreatorClassName);
            if (SchemaCreator.class.isAssignableFrom(schemaCreatorClass)) {
                SchemaCreator schemaCreator = (SchemaCreator)ReflectionUtils.newInstance(schemaCreatorClass, (Configuration)conf);
                schemaCreator.createTimelineSchema(args);
                return 0;
            }
            throw new YarnRuntimeException("Class: " + schemaCreatorClassName + " not instance of " + SchemaCreator.class.getCanonicalName());
        }
        catch (ClassNotFoundException e) {
            throw new YarnRuntimeException("Could not instantiate TimelineReader: " + schemaCreatorClassName, (Throwable)e);
        }
    }
}

