/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.cartesianproduct;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

class CartesianProductCombination {
    private int[] numChunk;
    private int positionId = -1;
    private final Integer[] combination;
    private final Integer[] factor;

    public CartesianProductCombination(int[] numChunk) {
        Preconditions.checkArgument((!Ints.contains((int[])numChunk, (int)0) ? 1 : 0) != 0, (Object)"CartesianProductCombination doesn't allow zero chunk");
        this.numChunk = Arrays.copyOf(numChunk, numChunk.length);
        this.combination = new Integer[numChunk.length];
        this.factor = new Integer[numChunk.length];
        this.factor[this.factor.length - 1] = 1;
        for (int i = this.combination.length - 2; i >= 0; --i) {
            this.factor[i] = this.factor[i + 1] * numChunk[i + 1];
        }
    }

    public CartesianProductCombination(int[] numChunk, int positionId) {
        this(numChunk);
        this.positionId = positionId;
    }

    public List<Integer> getCombination() {
        return Collections.unmodifiableList(Arrays.asList(this.combination));
    }

    public void firstTaskWithFixedChunk(int chunkId) {
        Preconditions.checkArgument((this.positionId >= 0 && this.positionId < this.combination.length ? 1 : 0) != 0);
        Arrays.fill((Object[])this.combination, (Object)0);
        this.combination[this.positionId] = chunkId;
    }

    public boolean nextTaskWithFixedChunk() {
        int i;
        Preconditions.checkArgument((this.positionId >= 0 && this.positionId < this.combination.length ? 1 : 0) != 0);
        for (i = this.combination.length - 1; i >= 0 && (i == this.positionId || this.combination[i] == this.numChunk[i] - 1); --i) {
        }
        if (i < 0) {
            return false;
        }
        Integer[] integerArray = this.combination;
        int n = i++;
        Integer n2 = integerArray[n];
        Integer n3 = integerArray[n] = Integer.valueOf(integerArray[n] + 1);
        while (i < this.combination.length) {
            if (i != this.positionId) {
                this.combination[i] = 0;
            }
            ++i;
        }
        return true;
    }

    public void firstTask() {
        Arrays.fill((Object[])this.combination, (Object)0);
    }

    public boolean nextTask() {
        int i;
        for (i = this.combination.length - 1; i >= 0 && this.combination[i] == this.numChunk[i] - 1; --i) {
        }
        if (i < 0) {
            return false;
        }
        Integer[] integerArray = this.combination;
        int n = i;
        Integer n2 = integerArray[n];
        Integer n3 = integerArray[n] = Integer.valueOf(integerArray[n] + 1);
        Arrays.fill((Object[])this.combination, i + 1, this.combination.length, (Object)0);
        return true;
    }

    public int getTaskId() {
        int chunkId = 0;
        for (int i = 0; i < this.combination.length; ++i) {
            chunkId += this.combination[i] * this.factor[i];
        }
        return chunkId;
    }

    public static CartesianProductCombination fromTaskId(int[] numChunk, int taskId) {
        CartesianProductCombination result = new CartesianProductCombination(numChunk);
        for (int i = 0; i < result.combination.length; ++i) {
            result.combination[i] = taskId / result.factor[i];
            taskId %= result.factor[i].intValue();
        }
        return result;
    }
}

