/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.utils;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.tez.runtime.library.utils.FastByteComparisons;

@InterfaceAudience.Private
public class BufferUtils {
    public static int compare(DataInputBuffer buf1, DataInputBuffer buf2) {
        byte[] b1 = buf1.getData();
        byte[] b2 = buf2.getData();
        int s1 = buf1.getPosition();
        int s2 = buf2.getPosition();
        int l1 = buf1.getLength();
        int l2 = buf2.getLength();
        return FastByteComparisons.compareTo(b1, s1, l1, b2, s2, l2);
    }

    public static int compare(DataOutputBuffer buf1, DataOutputBuffer buf2) {
        byte[] b1 = buf1.getData();
        byte[] b2 = buf2.getData();
        int s1 = 0;
        int s2 = 0;
        int l1 = buf1.getLength();
        int l2 = buf2.getLength();
        return FastByteComparisons.compareTo(b1, s1, l1, b2, s2, l2);
    }

    public static int compare(DataInputBuffer buf1, DataOutputBuffer buf2) {
        byte[] b1 = buf1.getData();
        byte[] b2 = buf2.getData();
        int s1 = buf1.getPosition();
        int s2 = 0;
        int l1 = buf1.getLength();
        int l2 = buf2.getLength();
        return FastByteComparisons.compareTo(b1, s1, l1 - s1, b2, s2, l2);
    }

    public static int compare(DataOutputBuffer buf1, DataInputBuffer buf2) {
        return BufferUtils.compare(buf2, buf1);
    }

    public static void copy(DataInputBuffer src, DataOutputBuffer dst) throws IOException {
        byte[] b1 = src.getData();
        int s1 = src.getPosition();
        int l1 = src.getLength();
        dst.reset();
        dst.write(b1, s1, l1 - s1);
    }

    public static void copy(DataOutputBuffer src, DataOutputBuffer dst) throws IOException {
        byte[] b1 = src.getData();
        int s1 = 0;
        int l1 = src.getLength();
        dst.reset();
        dst.write(b1, s1, l1);
    }
}

