/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.tableOps;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.core.client.impl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.client.impl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.FastFormat;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.server.master.Master;
import org.apache.accumulo.server.master.tableOps.ImportedTableInfo;
import org.apache.accumulo.server.master.tableOps.MasterRepo;
import org.apache.accumulo.server.master.tableOps.MoveExportedFiles;
import org.apache.accumulo.server.security.SecurityConstants;
import org.apache.accumulo.server.util.MetadataTable;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;

class PopulateMetadataTable
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private ImportedTableInfo tableInfo;

    PopulateMetadataTable(ImportedTableInfo ti) {
        this.tableInfo = ti;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, String> readMappingFile(FileSystem fs, ImportedTableInfo tableInfo) throws Exception {
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fs.open(new Path(tableInfo.importDir, "mappings.txt"))));
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            String line = null;
            while ((line = in.readLine()) != null) {
                String[] sa = line.split(":", 2);
                map.put(sa[0], sa[1]);
            }
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
        finally {
            in.close();
        }
    }

    @Override
    public Repo<Master> call(long tid, Master master) throws Exception {
        Path path = new Path(this.tableInfo.exportDir, "exportMetadata.zip");
        BatchWriter mbw = null;
        ZipInputStream zis = null;
        try {
            ZipEntry zipEntry;
            FileSystem fs = master.getFileSystem();
            mbw = master.getConnector().createBatchWriter("!METADATA", new BatchWriterConfig());
            zis = new ZipInputStream((InputStream)fs.open(path));
            Map<String, String> fileNameMappings = PopulateMetadataTable.readMappingFile(fs, this.tableInfo);
            String bulkDir = new Path(this.tableInfo.importDir).getName();
            while ((zipEntry = zis.getNextEntry()) != null) {
                Text endRow;
                if (!zipEntry.getName().equals("metadata.bin")) continue;
                DataInputStream in = new DataInputStream(new BufferedInputStream(zis));
                Key key = new Key();
                Value val = new Value();
                Mutation m = null;
                Text currentRow = null;
                int dirCount = 0;
                do {
                    Text cq;
                    key.readFields((DataInput)in);
                    val.readFields((DataInput)in);
                    endRow = new KeyExtent(key.getRow(), (Text)null).getEndRow();
                    Text metadataRow = new KeyExtent(new Text(this.tableInfo.tableId), endRow, null).getMetadataEntry();
                    if (key.getColumnFamily().equals((Object)Constants.METADATA_DATAFILE_COLUMN_FAMILY)) {
                        String oldName = new Path(key.getColumnQualifier().toString()).getName();
                        String newName = fileNameMappings.get(oldName);
                        cq = new Text("/" + bulkDir + "/" + newName);
                    } else {
                        cq = key.getColumnQualifier();
                    }
                    if (m == null) {
                        m = new Mutation(metadataRow);
                        Constants.METADATA_DIRECTORY_COLUMN.put(m, new Value(FastFormat.toZeroPaddedString((long)dirCount++, (int)8, (int)16, (byte[])"/c-".getBytes())));
                        currentRow = metadataRow;
                    }
                    if (!currentRow.equals((Object)metadataRow)) {
                        mbw.addMutation(m);
                        m = new Mutation(metadataRow);
                        Constants.METADATA_DIRECTORY_COLUMN.put(m, new Value(FastFormat.toZeroPaddedString((long)dirCount++, (int)8, (int)16, (byte[])"/c-".getBytes())));
                    }
                    m.put(key.getColumnFamily(), cq, val);
                } while (endRow != null || !Constants.METADATA_PREV_ROW_COLUMN.hasColumns(key));
                mbw.addMutation(m);
                break;
            }
            MoveExportedFiles moveExportedFiles = new MoveExportedFiles(this.tableInfo);
            return moveExportedFiles;
        }
        catch (IOException ioe) {
            log.warn((Object)ioe.getMessage(), (Throwable)ioe);
            throw new ThriftTableOperationException(this.tableInfo.tableId, this.tableInfo.tableName, TableOperation.IMPORT, TableOperationExceptionType.OTHER, "Error reading " + path + " " + ioe.getMessage());
        }
        finally {
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (IOException ioe) {
                    log.warn((Object)"Failed to close zip file ", (Throwable)ioe);
                }
            }
            if (mbw != null) {
                mbw.close();
            }
        }
    }

    @Override
    public void undo(long tid, Master environment) throws Exception {
        MetadataTable.deleteTable(this.tableInfo.tableId, false, SecurityConstants.getSystemCredentials(), environment.getMasterLock());
    }
}

