/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.tableOps;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.core.client.impl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.client.impl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.server.master.Master;
import org.apache.accumulo.server.master.tableOps.ExportInfo;
import org.apache.accumulo.server.master.tableOps.MasterRepo;
import org.apache.accumulo.server.master.tableOps.Utils;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;

class WriteExportFiles
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private final ExportInfo tableInfo;

    WriteExportFiles(ExportInfo tableInfo) {
        this.tableInfo = tableInfo;
    }

    private void checkOffline(Connector conn) throws Exception {
        if (Tables.getTableState((Instance)conn.getInstance(), (String)this.tableInfo.tableID) != TableState.OFFLINE) {
            Tables.clearCache((Instance)conn.getInstance());
            if (Tables.getTableState((Instance)conn.getInstance(), (String)this.tableInfo.tableID) != TableState.OFFLINE) {
                throw new ThriftTableOperationException(this.tableInfo.tableID, this.tableInfo.tableName, TableOperation.EXPORT, TableOperationExceptionType.OTHER, "Table is not offline");
            }
        }
    }

    @Override
    public long isReady(long tid, Master master) throws Exception {
        long reserved = Utils.reserveTable(this.tableInfo.tableID, tid, false, true, TableOperation.EXPORT);
        if (reserved > 0L) {
            return reserved;
        }
        Connector conn = master.getConnector();
        this.checkOffline(conn);
        Scanner metaScanner = conn.createScanner("!METADATA", Constants.NO_AUTHS);
        metaScanner.setRange(new KeyExtent(new Text(this.tableInfo.tableID), null, null).toMetadataRange());
        metaScanner.fetchColumnFamily(Constants.METADATA_CURRENT_LOCATION_COLUMN_FAMILY);
        metaScanner.fetchColumnFamily(Constants.METADATA_FUTURE_LOCATION_COLUMN_FAMILY);
        if (metaScanner.iterator().hasNext()) {
            return 500L;
        }
        metaScanner.clearColumns();
        metaScanner.fetchColumnFamily(Constants.METADATA_LOG_COLUMN_FAMILY);
        if (metaScanner.iterator().hasNext()) {
            throw new ThriftTableOperationException(this.tableInfo.tableID, this.tableInfo.tableName, TableOperation.EXPORT, TableOperationExceptionType.OTHER, "Write ahead logs found for table");
        }
        return 0L;
    }

    @Override
    public Repo<Master> call(long tid, Master master) throws Exception {
        Connector conn = master.getConnector();
        try {
            WriteExportFiles.exportTable(master.getFileSystem(), conn, this.tableInfo.tableName, this.tableInfo.tableID, this.tableInfo.exportDir);
        }
        catch (IOException ioe) {
            throw new ThriftTableOperationException(this.tableInfo.tableID, this.tableInfo.tableName, TableOperation.EXPORT, TableOperationExceptionType.OTHER, "Failed to create export files " + ioe.getMessage());
        }
        Utils.unreserveTable(this.tableInfo.tableID, tid, false);
        Utils.unreserveHdfsDirectory(new Path(this.tableInfo.exportDir).toString(), tid);
        return null;
    }

    @Override
    public void undo(long tid, Master env) throws Exception {
        Utils.unreserveTable(this.tableInfo.tableID, tid, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportTable(FileSystem fs, Connector conn, String tableName, String tableID, String exportDir) throws Exception {
        fs.mkdirs(new Path(exportDir));
        Path exportMetaFilePath = new Path(exportDir, "exportMetadata.zip");
        FSDataOutputStream fileOut = fs.create(exportMetaFilePath, false);
        ZipOutputStream zipOut = new ZipOutputStream((OutputStream)fileOut);
        BufferedOutputStream bufOut = new BufferedOutputStream(zipOut);
        DataOutputStream dataOut = new DataOutputStream(bufOut);
        try {
            zipOut.putNextEntry(new ZipEntry("accumulo_export_info.txt"));
            OutputStreamWriter osw = new OutputStreamWriter(dataOut);
            osw.append("exportVersion:1\n");
            osw.append("srcInstanceName:" + conn.getInstance().getInstanceName() + "\n");
            osw.append("srcInstanceID:" + conn.getInstance().getInstanceID() + "\n");
            osw.append("srcZookeepers:" + conn.getInstance().getZooKeepers() + "\n");
            osw.append("srcTableName:" + tableName + "\n");
            osw.append("srcTableID:" + tableID + "\n");
            osw.append("srcDataVersion:5\n");
            osw.append("srcCodeVersion:1.5.0\n");
            osw.flush();
            dataOut.flush();
            WriteExportFiles.exportConfig(conn, tableID, zipOut, dataOut);
            dataOut.flush();
            Map<String, String> uniqueFiles = WriteExportFiles.exportMetadata(conn, tableID, zipOut, dataOut);
            dataOut.close();
            dataOut = null;
            WriteExportFiles.createDistcpFile(fs, exportDir, exportMetaFilePath, uniqueFiles);
        }
        finally {
            if (dataOut != null) {
                dataOut.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createDistcpFile(FileSystem fs, String exportDir, Path exportMetaFilePath, Map<String, String> uniqueFiles) throws IOException {
        BufferedWriter distcpOut = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(new Path(exportDir, "distcp.txt"), false)));
        try {
            URI uri = fs.getUri();
            for (String relPath : uniqueFiles.values()) {
                Path absPath = new Path(uri.getScheme(), uri.getAuthority(), ServerConstants.getTablesDir() + relPath);
                distcpOut.append(absPath.toUri().toString());
                distcpOut.newLine();
            }
            Path absEMP = exportMetaFilePath;
            if (!exportMetaFilePath.isAbsolute()) {
                absEMP = new Path(fs.getWorkingDirectory().toUri().getPath(), exportMetaFilePath);
            }
            distcpOut.append(new Path(uri.getScheme(), uri.getAuthority(), absEMP.toString()).toUri().toString());
            distcpOut.newLine();
            distcpOut.close();
            distcpOut = null;
        }
        finally {
            if (distcpOut != null) {
                distcpOut.close();
            }
        }
    }

    private static Map<String, String> exportMetadata(Connector conn, String tableID, ZipOutputStream zipOut, DataOutputStream dataOut) throws IOException, TableNotFoundException {
        zipOut.putNextEntry(new ZipEntry("metadata.bin"));
        HashMap<String, String> uniqueFiles = new HashMap<String, String>();
        Scanner metaScanner = conn.createScanner("!METADATA", Constants.NO_AUTHS);
        metaScanner.fetchColumnFamily(Constants.METADATA_DATAFILE_COLUMN_FAMILY);
        Constants.METADATA_PREV_ROW_COLUMN.fetch((ScannerBase)metaScanner);
        Constants.METADATA_TIME_COLUMN.fetch((ScannerBase)metaScanner);
        metaScanner.setRange(new KeyExtent(new Text(tableID), null, null).toMetadataRange());
        for (Map.Entry entry : metaScanner) {
            ((Key)entry.getKey()).write((DataOutput)dataOut);
            ((Value)entry.getValue()).write((DataOutput)dataOut);
            if (!((Key)entry.getKey()).getColumnFamily().equals((Object)Constants.METADATA_DATAFILE_COLUMN_FAMILY)) continue;
            String relPath = ((Key)entry.getKey()).getColumnQualifierData().toString();
            relPath = relPath.startsWith("../") ? relPath.substring(2) : "/" + tableID + relPath;
            String[] tokens = relPath.split("/");
            if (tokens.length != 4) {
                throw new RuntimeException("Illegal path " + relPath);
            }
            String filename = tokens[3];
            String existingPath = (String)uniqueFiles.get(filename);
            if (existingPath == null) {
                uniqueFiles.put(filename, relPath);
                continue;
            }
            if (existingPath.equals(relPath)) continue;
            throw new IOException("Cannot export table with nonunique file names " + filename + ". Major compact table.");
        }
        return uniqueFiles;
    }

    private static void exportConfig(Connector conn, String tableID, ZipOutputStream zipOut, DataOutputStream dataOut) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, IOException {
        DefaultConfiguration defaultConfig = AccumuloConfiguration.getDefaultConfiguration();
        Map siteConfig = conn.instanceOperations().getSiteConfiguration();
        Map systemConfig = conn.instanceOperations().getSystemConfiguration();
        TableConfiguration tableConfig = ServerConfiguration.getTableConfiguration(conn.getInstance(), tableID);
        OutputStreamWriter osw = new OutputStreamWriter(dataOut);
        zipOut.putNextEntry(new ZipEntry("table_config.txt"));
        Iterator<Map.Entry<String, String>> i$ = tableConfig.iterator();
        while (i$.hasNext()) {
            Property key;
            Map.Entry<String, String> prop = i$.next();
            if (!prop.getKey().startsWith(Property.TABLE_PREFIX.getKey()) || (key = Property.getPropertyByKey((String)prop.getKey())) != null && defaultConfig.get(key).equals(prop.getValue()) || prop.getValue().equals(siteConfig.get(prop.getKey())) || prop.getValue().equals(systemConfig.get(prop.getKey()))) continue;
            osw.append(prop.getKey() + "=" + prop.getValue() + "\n");
        }
        osw.flush();
    }
}

