/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.metanalysis;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.server.logger.LogEvents;
import org.apache.accumulo.server.logger.LogFileKey;
import org.apache.accumulo.server.logger.LogFileValue;
import org.apache.accumulo.server.metanalysis.LogFileInputFormat;
import org.apache.accumulo.server.metanalysis.LogFileOutputFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class FilterMeta
extends Configured
implements Tool {
    public int run(String[] args) throws Exception {
        String jobName = ((Object)((Object)this)).getClass().getSimpleName() + "_" + System.currentTimeMillis();
        Job job = new Job(this.getConf(), jobName);
        job.setJarByClass(((Object)((Object)this)).getClass());
        Path[] paths = new Path[args.length - 1];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = new Path(args[i]);
        }
        job.setInputFormatClass(LogFileInputFormat.class);
        LogFileInputFormat.setInputPaths((Job)job, (Path[])paths);
        job.setOutputFormatClass(LogFileOutputFormat.class);
        LogFileOutputFormat.setOutputPath((Job)job, (Path)new Path(args[args.length - 1]));
        job.setMapperClass(FilterMapper.class);
        job.setNumReduceTasks(0);
        job.waitForCompletion(true);
        return job.isSuccessful() ? 0 : 1;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)CachedConfiguration.getInstance(), (Tool)new FilterMeta(), (String[])args);
        System.exit(res);
    }

    public static class FilterMapper
    extends Mapper<LogFileKey, LogFileValue, LogFileKey, LogFileValue> {
        private Set<Integer> tabletIds;

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.tabletIds = new HashSet<Integer>();
        }

        public void map(LogFileKey key, LogFileValue value, Mapper.Context context) throws IOException, InterruptedException {
            if (key.event == LogEvents.OPEN) {
                context.write((Object)key, (Object)value);
            } else if (key.event == LogEvents.DEFINE_TABLET && key.tablet.getTableId().toString().equals("!0")) {
                this.tabletIds.add(key.tid);
                context.write((Object)key, (Object)value);
            } else if ((key.event == LogEvents.MUTATION || key.event == LogEvents.MANY_MUTATIONS) && this.tabletIds.contains(key.tid)) {
                context.write((Object)key, (Object)value);
            }
        }
    }
}

