/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.monitor;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.MasterClient;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.file.FileUtil;
import org.apache.accumulo.core.gc.thrift.GCMonitorService;
import org.apache.accumulo.core.gc.thrift.GCStatus;
import org.apache.accumulo.core.master.thrift.Compacting;
import org.apache.accumulo.core.master.thrift.MasterClientService;
import org.apache.accumulo.core.master.thrift.MasterMonitorInfo;
import org.apache.accumulo.core.master.thrift.TableInfo;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.security.SecurityUtil;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.core.util.Daemon;
import org.apache.accumulo.core.util.LoggingRunnable;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.ServerServices;
import org.apache.accumulo.core.util.ThriftUtil;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.server.Accumulo;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.accumulo.server.monitor.LogService;
import org.apache.accumulo.server.monitor.ZooKeeperStatus;
import org.apache.accumulo.server.monitor.servlets.DefaultServlet;
import org.apache.accumulo.server.monitor.servlets.GcStatusServlet;
import org.apache.accumulo.server.monitor.servlets.JSONServlet;
import org.apache.accumulo.server.monitor.servlets.LogServlet;
import org.apache.accumulo.server.monitor.servlets.MasterServlet;
import org.apache.accumulo.server.monitor.servlets.OperationServlet;
import org.apache.accumulo.server.monitor.servlets.ProblemServlet;
import org.apache.accumulo.server.monitor.servlets.ShellServlet;
import org.apache.accumulo.server.monitor.servlets.TServersServlet;
import org.apache.accumulo.server.monitor.servlets.TablesServlet;
import org.apache.accumulo.server.monitor.servlets.VisServlet;
import org.apache.accumulo.server.monitor.servlets.XMLServlet;
import org.apache.accumulo.server.monitor.servlets.trace.ListType;
import org.apache.accumulo.server.monitor.servlets.trace.ShowTrace;
import org.apache.accumulo.server.monitor.servlets.trace.Summary;
import org.apache.accumulo.server.problems.ProblemReports;
import org.apache.accumulo.server.problems.ProblemType;
import org.apache.accumulo.server.security.SecurityConstants;
import org.apache.accumulo.server.util.EmbeddedWebServer;
import org.apache.accumulo.trace.instrument.Tracer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.log4j.Logger;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.TServiceClientFactory;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;

public class Monitor {
    private static final Logger log = Logger.getLogger(Monitor.class);
    public static final int REFRESH_TIME = 5;
    private static long lastRecalc = 0L;
    private static double totalIngestRate = 0.0;
    private static double totalIngestByteRate = 0.0;
    private static double totalQueryRate = 0.0;
    private static double totalScanRate = 0.0;
    private static double totalQueryByteRate = 0.0;
    private static long totalEntries = 0L;
    private static int totalTabletCount = 0;
    private static int onlineTabletCount = 0;
    private static long totalHoldTime = 0L;
    private static long totalLookups = 0L;
    private static int totalTables = 0;
    private static final int MAX_TIME_PERIOD = 3600000;
    private static final List<Pair<Long, Double>> loadOverTime = Collections.synchronizedList(new MaxList(3600000L));
    private static final List<Pair<Long, Double>> ingestRateOverTime = Collections.synchronizedList(new MaxList(3600000L));
    private static final List<Pair<Long, Double>> ingestByteRateOverTime = Collections.synchronizedList(new MaxList(3600000L));
    private static final List<Pair<Long, Integer>> recoveriesOverTime = Collections.synchronizedList(new MaxList(3600000L));
    private static final List<Pair<Long, Integer>> minorCompactionsOverTime = Collections.synchronizedList(new MaxList(3600000L));
    private static final List<Pair<Long, Integer>> majorCompactionsOverTime = Collections.synchronizedList(new MaxList(3600000L));
    private static final List<Pair<Long, Double>> lookupsOverTime = Collections.synchronizedList(new MaxList(3600000L));
    private static final List<Pair<Long, Integer>> queryRateOverTime = Collections.synchronizedList(new MaxList(3600000L));
    private static final List<Pair<Long, Integer>> scanRateOverTime = Collections.synchronizedList(new MaxList(3600000L));
    private static final List<Pair<Long, Double>> queryByteRateOverTime = Collections.synchronizedList(new MaxList(3600000L));
    private static final List<Pair<Long, Double>> indexCacheHitRateOverTime = Collections.synchronizedList(new MaxList(3600000L));
    private static final List<Pair<Long, Double>> dataCacheHitRateOverTime = Collections.synchronizedList(new MaxList(3600000L));
    private static EventCounter lookupRateTracker = new EventCounter();
    private static EventCounter indexCacheHitTracker = new EventCounter();
    private static EventCounter indexCacheRequestTracker = new EventCounter();
    private static EventCounter dataCacheHitTracker = new EventCounter();
    private static EventCounter dataCacheRequestTracker = new EventCounter();
    private static volatile boolean fetching = false;
    private static MasterMonitorInfo mmi;
    private static Map<String, Map<ProblemType, Integer>> problemSummary;
    private static Exception problemException;
    private static GCStatus gcStatus;
    private static Instance instance;
    private static ServerConfiguration config;
    private static EmbeddedWebServer server;
    private static long START_TIME;

    public static Map<String, Double> summarizeTableStats(MasterMonitorInfo mmi) {
        HashMap<String, Double> compactingByTable = new HashMap<String, Double>();
        if (mmi != null && mmi.tServerInfo != null) {
            for (TabletServerStatus status : mmi.tServerInfo) {
                if (status == null || status.tableMap == null) continue;
                Iterator i$ = status.tableMap.keySet().iterator();
                while (i$.hasNext()) {
                    String table;
                    Double holdTime = (Double)compactingByTable.get(table = (String)i$.next());
                    compactingByTable.put(table, Math.max(holdTime == null ? 0.0 : holdTime, (double)status.holdTime));
                }
            }
        }
        return compactingByTable;
    }

    public static void add(TableInfo total, TableInfo more) {
        if (total.minors == null) {
            total.minors = new Compacting();
        }
        if (total.majors == null) {
            total.majors = new Compacting();
        }
        if (total.scans == null) {
            total.scans = new Compacting();
        }
        if (more.minors != null) {
            total.minors.running += more.minors.running;
            total.minors.queued += more.minors.queued;
        }
        if (more.majors != null) {
            total.majors.running += more.majors.running;
            total.majors.queued += more.majors.queued;
        }
        if (more.scans != null) {
            total.scans.running += more.scans.running;
            total.scans.queued += more.scans.queued;
        }
        total.onlineTablets += more.onlineTablets;
        total.recs += more.recs;
        total.recsInMemory += more.recsInMemory;
        total.tablets += more.tablets;
        total.ingestRate += more.ingestRate;
        total.ingestByteRate += more.ingestByteRate;
        total.queryRate += more.queryRate;
        total.queryByteRate += more.queryByteRate;
        total.scanRate += more.scanRate;
    }

    public static TableInfo summarizeTableStats(TabletServerStatus status) {
        TableInfo summary = new TableInfo();
        summary.majors = new Compacting();
        summary.minors = new Compacting();
        summary.scans = new Compacting();
        for (TableInfo rates : status.tableMap.values()) {
            Monitor.add(summary, rates);
        }
        return summary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fetchData() {
        double totalIngestRate = 0.0;
        double totalIngestByteRate = 0.0;
        double totalQueryRate = 0.0;
        double totalQueryByteRate = 0.0;
        double totalScanRate = 0.0;
        long totalEntries = 0L;
        int totalTabletCount = 0;
        int onlineTabletCount = 0;
        long totalHoldTime = 0L;
        long totalLookups = 0L;
        boolean retry = true;
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastRecalc < 5000L) {
            return;
        }
        Class<Monitor> clazz = Monitor.class;
        synchronized (Monitor.class) {
            if (fetching) {
                // ** MonitorExit[var21_12] (shouldn't be in output)
                return;
            }
            fetching = true;
            // ** MonitorExit[var21_12] (shouldn't be in output)
            try {
                while (retry) {
                    MasterClientService.Client client = null;
                    try {
                        client = MasterClient.getConnection((Instance)HdfsZooInstance.getInstance());
                        if (client != null) {
                            mmi = client.getMasterStats(Tracer.traceInfo(), SecurityConstants.getSystemCredentials());
                            retry = false;
                        } else {
                            mmi = null;
                        }
                        gcStatus = Monitor.fetchGcStatus();
                    }
                    catch (Exception e) {
                        mmi = null;
                        log.info((Object)("Error fetching stats: " + e));
                    }
                    finally {
                        if (client != null) {
                            MasterClient.close((MasterClientService.Iface)client);
                        }
                    }
                    if (mmi != null) continue;
                    UtilWaitThread.sleep((long)1000L);
                }
                if (mmi != null) {
                    int majorCompactions = 0;
                    int minorCompactions = 0;
                    lookupRateTracker.startingUpdates();
                    indexCacheHitTracker.startingUpdates();
                    indexCacheRequestTracker.startingUpdates();
                    dataCacheHitTracker.startingUpdates();
                    dataCacheRequestTracker.startingUpdates();
                    for (TabletServerStatus server : Monitor.mmi.tServerInfo) {
                        TableInfo summary = Monitor.summarizeTableStats(server);
                        totalIngestRate += summary.ingestRate;
                        totalIngestByteRate += summary.ingestByteRate;
                        totalQueryRate += summary.queryRate;
                        totalScanRate += summary.scanRate;
                        totalQueryByteRate += summary.queryByteRate;
                        totalEntries += summary.recs;
                        totalHoldTime += server.holdTime;
                        totalLookups += server.lookups;
                        majorCompactions += summary.majors.running;
                        minorCompactions += summary.minors.running;
                        lookupRateTracker.updateTabletServer(server.name, server.lastContact, server.lookups);
                        indexCacheHitTracker.updateTabletServer(server.name, server.lastContact, server.indexCacheHits);
                        indexCacheRequestTracker.updateTabletServer(server.name, server.lastContact, server.indexCacheRequest);
                        dataCacheHitTracker.updateTabletServer(server.name, server.lastContact, server.dataCacheHits);
                        dataCacheRequestTracker.updateTabletServer(server.name, server.lastContact, server.dataCacheRequest);
                    }
                    lookupRateTracker.finishedUpdating();
                    indexCacheHitTracker.finishedUpdating();
                    indexCacheRequestTracker.finishedUpdating();
                    dataCacheHitTracker.finishedUpdating();
                    dataCacheRequestTracker.finishedUpdating();
                    int totalTables = 0;
                    for (TableInfo tInfo : Monitor.mmi.tableMap.values()) {
                        totalTabletCount += tInfo.tablets;
                        onlineTabletCount += tInfo.onlineTablets;
                        ++totalTables;
                    }
                    Monitor.totalIngestRate = totalIngestRate;
                    Monitor.totalTables = totalTables;
                    Monitor.totalIngestByteRate = totalIngestByteRate /= 1000000.0;
                    Monitor.totalQueryRate = totalQueryRate;
                    Monitor.totalScanRate = totalScanRate;
                    Monitor.totalQueryByteRate = totalQueryByteRate /= 1000000.0;
                    Monitor.totalEntries = totalEntries;
                    Monitor.totalTabletCount = totalTabletCount;
                    Monitor.onlineTabletCount = onlineTabletCount;
                    Monitor.totalHoldTime = totalHoldTime;
                    Monitor.totalLookups = totalLookups;
                    ingestRateOverTime.add((Pair<Long, Double>)new Pair((Object)currentTime, (Object)totalIngestRate));
                    ingestByteRateOverTime.add((Pair<Long, Double>)new Pair((Object)currentTime, (Object)totalIngestByteRate));
                    double totalLoad = 0.0;
                    for (TabletServerStatus status : Monitor.mmi.tServerInfo) {
                        if (status == null) continue;
                        totalLoad += status.osLoad;
                    }
                    loadOverTime.add((Pair<Long, Double>)new Pair((Object)currentTime, (Object)totalLoad));
                    minorCompactionsOverTime.add((Pair<Long, Integer>)new Pair((Object)currentTime, (Object)minorCompactions));
                    majorCompactionsOverTime.add((Pair<Long, Integer>)new Pair((Object)currentTime, (Object)majorCompactions));
                    lookupsOverTime.add((Pair<Long, Double>)new Pair((Object)currentTime, (Object)lookupRateTracker.calculateRate()));
                    queryRateOverTime.add((Pair<Long, Integer>)new Pair((Object)currentTime, (Object)((int)totalQueryRate)));
                    queryByteRateOverTime.add((Pair<Long, Double>)new Pair((Object)currentTime, (Object)totalQueryByteRate));
                    scanRateOverTime.add((Pair<Long, Integer>)new Pair((Object)currentTime, (Object)((int)totalScanRate)));
                    Monitor.calcCacheHitRate(indexCacheHitRateOverTime, currentTime, indexCacheHitTracker, indexCacheRequestTracker);
                    Monitor.calcCacheHitRate(dataCacheHitRateOverTime, currentTime, dataCacheHitTracker, dataCacheRequestTracker);
                }
                try {
                    problemSummary = ProblemReports.getInstance().summarize();
                    problemException = null;
                }
                catch (Exception e) {
                    log.info((Object)"Failed to obtain problem reports ", (Throwable)e);
                    problemSummary = Collections.emptyMap();
                    problemException = e;
                }
            }
            finally {
                Class<Monitor> clazz2 = Monitor.class;
                synchronized (Monitor.class) {
                    fetching = false;
                    lastRecalc = currentTime;
                    // ** MonitorExit[var21_15] (shouldn't be in output)
                }
            }
            return;
        }
    }

    private static void calcCacheHitRate(List<Pair<Long, Double>> hitRate, long currentTime, EventCounter cacheHits, EventCounter cacheReq) {
        long req = cacheReq.calculateCount();
        if (req > 0L) {
            hitRate.add((Pair<Long, Double>)new Pair((Object)currentTime, (Object)((double)cacheHits.calculateCount() / (double)cacheReq.calculateCount())));
        } else {
            hitRate.add((Pair<Long, Double>)new Pair((Object)currentTime, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static GCStatus fetchGcStatus() {
        GCStatus result;
        block8: {
            result = null;
            InetSocketAddress address = null;
            try {
                Instance instance = HdfsZooInstance.getInstance();
                String zooKeepers = instance.getZooKeepers();
                log.debug((Object)("connecting to zookeepers " + zooKeepers));
                ZooKeeper zk = new ZooKeeper(zooKeepers, (int)config.getConfiguration().getTimeInMillis(Property.INSTANCE_ZK_TIMEOUT), new Watcher(){

                    public void process(WatchedEvent event) {
                    }
                });
                try {
                    String path = ZooUtil.getRoot((Instance)HdfsZooInstance.getInstance()) + "/gc/lock";
                    List locks = zk.getChildren(path, null);
                    if (locks == null || locks.size() <= 0) break block8;
                    Collections.sort(locks);
                    address = new ServerServices(new String(zk.getData(path + "/" + (String)locks.get(0), null, null))).getAddress(ServerServices.Service.GC_CLIENT);
                    GCMonitorService.Client client = (GCMonitorService.Client)ThriftUtil.getClient((TServiceClientFactory)new GCMonitorService.Client.Factory(), (InetSocketAddress)address, (AccumuloConfiguration)config.getConfiguration());
                    try {
                        result = client.getStatus(Tracer.traceInfo(), SecurityConstants.getSystemCredentials());
                    }
                    finally {
                        ThriftUtil.returnClient((TServiceClient)client);
                    }
                }
                finally {
                    zk.close();
                }
            }
            catch (Exception ex) {
                log.warn((Object)("Unable to contact the garbage collector at " + address), (Throwable)ex);
            }
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        SecurityUtil.serverLogin();
        FileSystem fs = FileUtil.getFileSystem((Configuration)CachedConfiguration.getInstance(), (AccumuloConfiguration)ServerConfiguration.getSiteConfiguration());
        String hostname = Accumulo.getLocalAddress(args);
        instance = HdfsZooInstance.getInstance();
        config = new ServerConfiguration(instance);
        Accumulo.init(fs, config, "monitor");
        Monitor monitor = new Monitor();
        Accumulo.enableTracing(hostname, "monitor");
        monitor.run(hostname);
    }

    public void run(String hostname) {
        START_TIME = System.currentTimeMillis();
        int port = config.getConfiguration().getPort(Property.MONITOR_PORT);
        try {
            log.debug((Object)("Creating monitor on port " + port));
            server = new EmbeddedWebServer(hostname, port);
        }
        catch (Throwable ex) {
            log.error((Object)"Unable to start embedded web server", ex);
            throw new RuntimeException(ex);
        }
        server.addServlet(DefaultServlet.class, "/");
        server.addServlet(OperationServlet.class, "/op");
        server.addServlet(MasterServlet.class, "/master");
        server.addServlet(TablesServlet.class, "/tables");
        server.addServlet(TServersServlet.class, "/tservers");
        server.addServlet(ProblemServlet.class, "/problems");
        server.addServlet(GcStatusServlet.class, "/gc");
        server.addServlet(LogServlet.class, "/log");
        server.addServlet(XMLServlet.class, "/xml");
        server.addServlet(JSONServlet.class, "/json");
        server.addServlet(VisServlet.class, "/vis");
        server.addServlet(Summary.class, "/trace/summary");
        server.addServlet(ListType.class, "/trace/listType");
        server.addServlet(ShowTrace.class, "/trace/show");
        if (server.isUsingSsl()) {
            server.addServlet(ShellServlet.class, "/shell");
        }
        LogService.startLogListener(Monitor.getSystemConfiguration());
        server.start();
        new Daemon((Runnable)new LoggingRunnable(log, (Runnable)new ZooKeeperStatus()), "ZooKeeperStatus").start();
        new Daemon((Runnable)new LoggingRunnable(log, new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Monitor.fetchData();
                    }
                    catch (Exception e) {
                        log.warn((Object)e.getMessage(), (Throwable)e);
                    }
                    UtilWaitThread.sleep((long)333L);
                }
            }
        }), "Data fetcher").start();
    }

    public static MasterMonitorInfo getMmi() {
        return mmi;
    }

    public static int getTotalTables() {
        return totalTables;
    }

    public static int getTotalTabletCount() {
        return totalTabletCount;
    }

    public static int getOnlineTabletCount() {
        return onlineTabletCount;
    }

    public static long getTotalEntries() {
        return totalEntries;
    }

    public static double getTotalIngestRate() {
        return totalIngestRate;
    }

    public static double getTotalIngestByteRate() {
        return totalIngestByteRate;
    }

    public static double getTotalQueryRate() {
        return totalQueryRate;
    }

    public static double getTotalScanRate() {
        return totalScanRate;
    }

    public static double getTotalQueryByteRate() {
        return totalQueryByteRate;
    }

    public static long getTotalHoldTime() {
        return totalHoldTime;
    }

    public static Exception getProblemException() {
        return problemException;
    }

    public static Map<String, Map<ProblemType, Integer>> getProblemSummary() {
        return problemSummary;
    }

    public static GCStatus getGcStatus() {
        return gcStatus;
    }

    public static long getTotalLookups() {
        return totalLookups;
    }

    public static long getStartTime() {
        return START_TIME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Pair<Long, Double>> getLoadOverTime() {
        List<Pair<Long, Double>> list = loadOverTime;
        synchronized (list) {
            return new ArrayList<Pair<Long, Double>>(loadOverTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Pair<Long, Double>> getIngestRateOverTime() {
        List<Pair<Long, Double>> list = ingestRateOverTime;
        synchronized (list) {
            return new ArrayList<Pair<Long, Double>>(ingestRateOverTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Pair<Long, Double>> getIngestByteRateOverTime() {
        List<Pair<Long, Double>> list = ingestByteRateOverTime;
        synchronized (list) {
            return new ArrayList<Pair<Long, Double>>(ingestByteRateOverTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Pair<Long, Integer>> getRecoveriesOverTime() {
        List<Pair<Long, Integer>> list = recoveriesOverTime;
        synchronized (list) {
            return new ArrayList<Pair<Long, Integer>>(recoveriesOverTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Pair<Long, Integer>> getMinorCompactionsOverTime() {
        List<Pair<Long, Integer>> list = minorCompactionsOverTime;
        synchronized (list) {
            return new ArrayList<Pair<Long, Integer>>(minorCompactionsOverTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Pair<Long, Integer>> getMajorCompactionsOverTime() {
        List<Pair<Long, Integer>> list = majorCompactionsOverTime;
        synchronized (list) {
            return new ArrayList<Pair<Long, Integer>>(majorCompactionsOverTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Pair<Long, Double>> getLookupsOverTime() {
        List<Pair<Long, Double>> list = lookupsOverTime;
        synchronized (list) {
            return new ArrayList<Pair<Long, Double>>(lookupsOverTime);
        }
    }

    public static double getLookupRate() {
        return lookupRateTracker.calculateRate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Pair<Long, Integer>> getQueryRateOverTime() {
        List<Pair<Long, Integer>> list = queryRateOverTime;
        synchronized (list) {
            return new ArrayList<Pair<Long, Integer>>(queryRateOverTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Pair<Long, Integer>> getScanRateOverTime() {
        List<Pair<Long, Integer>> list = scanRateOverTime;
        synchronized (list) {
            return new ArrayList<Pair<Long, Integer>>(scanRateOverTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Pair<Long, Double>> getQueryByteRateOverTime() {
        List<Pair<Long, Double>> list = queryByteRateOverTime;
        synchronized (list) {
            return new ArrayList<Pair<Long, Double>>(queryByteRateOverTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Pair<Long, Double>> getIndexCacheHitRateOverTime() {
        List<Pair<Long, Double>> list = indexCacheHitRateOverTime;
        synchronized (list) {
            return new ArrayList<Pair<Long, Double>>(indexCacheHitRateOverTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Pair<Long, Double>> getDataCacheHitRateOverTime() {
        List<Pair<Long, Double>> list = dataCacheHitRateOverTime;
        synchronized (list) {
            return new ArrayList<Pair<Long, Double>>(dataCacheHitRateOverTime);
        }
    }

    public static AccumuloConfiguration getSystemConfiguration() {
        return config.getConfiguration();
    }

    public static Instance getInstance() {
        return instance;
    }

    public static boolean isUsingSsl() {
        return server.isUsingSsl();
    }

    static {
        problemSummary = Collections.emptyMap();
    }

    private static class EventCounter {
        Map<String, Pair<Long, Long>> prevSamples = new HashMap<String, Pair<Long, Long>>();
        Map<String, Pair<Long, Long>> samples = new HashMap<String, Pair<Long, Long>>();
        Set<String> serversUpdated = new HashSet<String>();

        private EventCounter() {
        }

        void startingUpdates() {
            this.serversUpdated.clear();
        }

        void updateTabletServer(String name, long sampleTime, long numEvents) {
            Pair newSample = new Pair((Object)sampleTime, (Object)numEvents);
            Pair<Long, Long> lastSample = this.samples.get(name);
            if (lastSample == null || !lastSample.equals((Object)newSample)) {
                this.samples.put(name, (Pair<Long, Long>)newSample);
                if (lastSample != null) {
                    this.prevSamples.put(name, lastSample);
                }
            }
            this.serversUpdated.add(name);
        }

        void finishedUpdating() {
            this.samples.keySet().retainAll(this.serversUpdated);
            this.prevSamples.keySet().retainAll(this.serversUpdated);
        }

        double calculateRate() {
            double totalRate = 0.0;
            for (Map.Entry<String, Pair<Long, Long>> entry : this.prevSamples.entrySet()) {
                Pair<Long, Long> prevSample = entry.getValue();
                Pair<Long, Long> sample = this.samples.get(entry.getKey());
                totalRate += (double)((Long)sample.getSecond() - (Long)prevSample.getSecond()) / ((double)((Long)sample.getFirst() - (Long)prevSample.getFirst()) / 1000.0);
            }
            return totalRate;
        }

        long calculateCount() {
            long count = 0L;
            for (Map.Entry<String, Pair<Long, Long>> entry : this.prevSamples.entrySet()) {
                Pair<Long, Long> prevSample = entry.getValue();
                Pair<Long, Long> sample = this.samples.get(entry.getKey());
                count += (Long)sample.getSecond() - (Long)prevSample.getSecond();
            }
            return count;
        }
    }

    private static class MaxList<T>
    extends LinkedList<Pair<Long, T>> {
        private static final long serialVersionUID = 1L;
        private long maxDelta;

        public MaxList(long maxDelta) {
            this.maxDelta = maxDelta;
        }

        @Override
        public boolean add(Pair<Long, T> obj) {
            boolean result = super.add(obj);
            if ((Long)obj.getFirst() - (Long)((Pair)this.get(0)).getFirst() > this.maxDelta) {
                this.remove(0);
            }
            return result;
        }
    }
}

