/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapred;

import java.io.IOException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapred.TableRecordReaderImpl;
import org.apache.hadoop.mapred.RecordReader;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class TableRecordReader
implements RecordReader<ImmutableBytesWritable, Result> {
    private TableRecordReaderImpl recordReaderImpl = new TableRecordReaderImpl();

    public void restart(byte[] firstRow) throws IOException {
        this.recordReaderImpl.restart(firstRow);
    }

    public void init() throws IOException {
        this.recordReaderImpl.restart(this.recordReaderImpl.getStartRow());
    }

    public void setHTable(Table htable) {
        this.recordReaderImpl.setHTable(htable);
    }

    public void setInputColumns(byte[][] inputColumns) {
        this.recordReaderImpl.setInputColumns(inputColumns);
    }

    public void setStartRow(byte[] startRow) {
        this.recordReaderImpl.setStartRow(startRow);
    }

    public void setEndRow(byte[] endRow) {
        this.recordReaderImpl.setEndRow(endRow);
    }

    public void setRowFilter(Filter rowFilter) {
        this.recordReaderImpl.setRowFilter(rowFilter);
    }

    public void close() {
        this.recordReaderImpl.close();
    }

    public ImmutableBytesWritable createKey() {
        return this.recordReaderImpl.createKey();
    }

    public Result createValue() {
        return this.recordReaderImpl.createValue();
    }

    public long getPos() {
        return this.recordReaderImpl.getPos();
    }

    public float getProgress() {
        return this.recordReaderImpl.getPos();
    }

    public boolean next(ImmutableBytesWritable key, Result value) throws IOException {
        return this.recordReaderImpl.next(key, value);
    }
}

