/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataOutput;
import java.io.IOException;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.InvalidJobConfException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileAsBinaryOutputFormat;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.util.Progressable;
import org.junit.Assert;
import org.junit.Test;

public class TestSequenceFileAsBinaryOutputFormat {
    private static final Log LOG = LogFactory.getLog((String)TestSequenceFileAsBinaryOutputFormat.class.getName());
    private static final int RECORDS = 10000;
    private static final String attempt = "attempt_200707121733_0001_m_000000_0";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBinary() throws IOException {
        JobConf job = new JobConf();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)job);
        Path dir = new Path(new Path(new Path(System.getProperty("test.build.data", ".")), "_temporary"), "_attempt_200707121733_0001_m_000000_0");
        Path file = new Path(dir, "testbinary.seq");
        Random r = new Random();
        long seed = r.nextLong();
        r.setSeed(seed);
        fs.delete(dir, true);
        if (!fs.mkdirs(dir)) {
            Assert.fail((String)"Failed to create output directory");
        }
        job.set("mapreduce.task.attempt.id", attempt);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)dir.getParent().getParent());
        FileOutputFormat.setWorkOutputPath((JobConf)job, (Path)dir);
        SequenceFileAsBinaryOutputFormat.setSequenceFileOutputKeyClass((JobConf)job, IntWritable.class);
        SequenceFileAsBinaryOutputFormat.setSequenceFileOutputValueClass((JobConf)job, DoubleWritable.class);
        SequenceFileAsBinaryOutputFormat.setCompressOutput((JobConf)job, (boolean)true);
        SequenceFileAsBinaryOutputFormat.setOutputCompressionType((JobConf)job, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK);
        BytesWritable bkey = new BytesWritable();
        BytesWritable bval = new BytesWritable();
        RecordWriter writer = new SequenceFileAsBinaryOutputFormat().getRecordWriter((FileSystem)fs, job, file.toString(), (Progressable)Reporter.NULL);
        IntWritable iwritable = new IntWritable();
        DoubleWritable dwritable = new DoubleWritable();
        DataOutputBuffer outbuf = new DataOutputBuffer();
        LOG.info((Object)"Creating data by SequenceFileAsBinaryOutputFormat");
        try {
            for (int i = 0; i < 10000; ++i) {
                iwritable = new IntWritable(r.nextInt());
                iwritable.write((DataOutput)outbuf);
                bkey.set(outbuf.getData(), 0, outbuf.getLength());
                outbuf.reset();
                dwritable = new DoubleWritable(r.nextDouble());
                dwritable.write((DataOutput)outbuf);
                bval.set(outbuf.getData(), 0, outbuf.getLength());
                outbuf.reset();
                writer.write((Object)bkey, (Object)bval);
            }
        }
        finally {
            writer.close(Reporter.NULL);
        }
        SequenceFileInputFormat iformat = new SequenceFileInputFormat();
        int count = 0;
        r.setSeed(seed);
        DataInputBuffer buf = new DataInputBuffer();
        int NUM_SPLITS = 3;
        SequenceFileInputFormat.addInputPath((JobConf)job, (Path)file);
        LOG.info((Object)"Reading data by SequenceFileInputFormat");
        for (InputSplit split : iformat.getSplits(job, 3)) {
            try (RecordReader reader = iformat.getRecordReader(split, job, Reporter.NULL);){
                while (reader.next((Object)iwritable, (Object)dwritable)) {
                    int sourceInt = r.nextInt();
                    double sourceDouble = r.nextDouble();
                    Assert.assertEquals((String)("Keys don't match: *" + iwritable.get() + ":" + sourceInt + "*"), (long)sourceInt, (long)iwritable.get());
                    Assert.assertTrue((String)("Vals don't match: *" + dwritable.get() + ":" + sourceDouble + "*"), (Double.compare(dwritable.get(), sourceDouble) == 0 ? 1 : 0) != 0);
                    ++count;
                }
            }
        }
        Assert.assertEquals((String)"Some records not found", (long)10000L, (long)count);
    }

    @Test
    public void testSequenceOutputClassDefaultsToMapRedOutputClass() throws IOException {
        JobConf job = new JobConf();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)job);
        job.setOutputKeyClass(FloatWritable.class);
        job.setOutputValueClass(BooleanWritable.class);
        Assert.assertEquals((String)"SequenceFileOutputKeyClass should default to ouputKeyClass", FloatWritable.class, (Object)SequenceFileAsBinaryOutputFormat.getSequenceFileOutputKeyClass((JobConf)job));
        Assert.assertEquals((String)"SequenceFileOutputValueClass should default to ouputValueClass", BooleanWritable.class, (Object)SequenceFileAsBinaryOutputFormat.getSequenceFileOutputValueClass((JobConf)job));
        SequenceFileAsBinaryOutputFormat.setSequenceFileOutputKeyClass((JobConf)job, IntWritable.class);
        SequenceFileAsBinaryOutputFormat.setSequenceFileOutputValueClass((JobConf)job, DoubleWritable.class);
        Assert.assertEquals((String)"SequenceFileOutputKeyClass not updated", IntWritable.class, (Object)SequenceFileAsBinaryOutputFormat.getSequenceFileOutputKeyClass((JobConf)job));
        Assert.assertEquals((String)"SequenceFileOutputValueClass not updated", DoubleWritable.class, (Object)SequenceFileAsBinaryOutputFormat.getSequenceFileOutputValueClass((JobConf)job));
    }

    @Test
    public void testcheckOutputSpecsForbidRecordCompression() throws IOException {
        JobConf job = new JobConf();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)job);
        Path dir = new Path(System.getProperty("test.build.data", ".") + "/mapred");
        Path outputdir = new Path(System.getProperty("test.build.data", ".") + "/output");
        fs.delete(dir, true);
        fs.delete(outputdir, true);
        if (!fs.mkdirs(dir)) {
            Assert.fail((String)"Failed to create output directory");
        }
        FileOutputFormat.setWorkOutputPath((JobConf)job, (Path)dir);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)outputdir);
        SequenceFileAsBinaryOutputFormat.setCompressOutput((JobConf)job, (boolean)true);
        SequenceFileAsBinaryOutputFormat.setOutputCompressionType((JobConf)job, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK);
        try {
            new SequenceFileAsBinaryOutputFormat().checkOutputSpecs((FileSystem)fs, job);
        }
        catch (Exception e) {
            Assert.fail((String)("Block compression should be allowed for SequenceFileAsBinaryOutputFormat:Caught " + e.getClass().getName()));
        }
        SequenceFileAsBinaryOutputFormat.setOutputCompressionType((JobConf)job, (SequenceFile.CompressionType)SequenceFile.CompressionType.RECORD);
        try {
            new SequenceFileAsBinaryOutputFormat().checkOutputSpecs((FileSystem)fs, job);
            Assert.fail((String)"Record compression should not be allowed for SequenceFileAsBinaryOutputFormat");
        }
        catch (InvalidJobConfException e) {
        }
        catch (Exception e) {
            Assert.fail((String)("Expected " + InvalidJobConfException.class.getName() + "but caught " + e.getClass().getName()));
        }
    }
}

