/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.YarnConfigurationStore;

public class InMemoryConfigurationStore
extends YarnConfigurationStore {
    private Configuration schedConf;
    private YarnConfigurationStore.LogMutation pendingMutation;

    @Override
    public void initialize(Configuration conf, Configuration schedConf, RMContext rmContext) {
        this.schedConf = schedConf;
    }

    @Override
    public void logMutation(YarnConfigurationStore.LogMutation logMutation) {
        this.pendingMutation = logMutation;
    }

    @Override
    public void confirmMutation(boolean isValid) {
        if (isValid) {
            for (Map.Entry<String, String> kv : this.pendingMutation.getUpdates().entrySet()) {
                if (kv.getValue() == null) {
                    this.schedConf.unset(kv.getKey());
                    continue;
                }
                this.schedConf.set(kv.getKey(), kv.getValue());
            }
        }
        this.pendingMutation = null;
    }

    @Override
    public synchronized Configuration retrieve() {
        return this.schedConf;
    }

    @Override
    public List<YarnConfigurationStore.LogMutation> getConfirmedConfHistory(long fromId) {
        return null;
    }

    @Override
    public Version getConfStoreVersion() throws Exception {
        return null;
    }

    @Override
    public void storeVersion() throws Exception {
    }

    @Override
    public Version getCurrentVersion() {
        return null;
    }

    @Override
    public void checkVersion() {
    }
}

