/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.distributed;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.ResourceOption;
import org.apache.hadoop.yarn.server.api.protocolrecords.NMContainerStatus;
import org.apache.hadoop.yarn.server.api.records.OpportunisticContainersStatus;
import org.apache.hadoop.yarn.server.resourcemanager.ClusterMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.distributed.QueueLimitCalculator;

public class NodeQueueLoadMonitor
implements ClusterMonitor {
    static final Log LOG = LogFactory.getLog(NodeQueueLoadMonitor.class);
    private final ScheduledExecutorService scheduledExecutor;
    private final List<NodeId> sortedNodes;
    private final Map<NodeId, ClusterNode> clusterNodes = new ConcurrentHashMap<NodeId, ClusterNode>();
    private final LoadComparator comparator;
    private QueueLimitCalculator thresholdCalculator;
    private ReentrantReadWriteLock sortedNodesLock = new ReentrantReadWriteLock();
    private ReentrantReadWriteLock clusterNodesLock = new ReentrantReadWriteLock();
    Runnable computeTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ReentrantReadWriteLock.WriteLock writeLock = NodeQueueLoadMonitor.this.sortedNodesLock.writeLock();
            writeLock.lock();
            try {
                try {
                    List nodeIds = NodeQueueLoadMonitor.this.sortNodes();
                    NodeQueueLoadMonitor.this.sortedNodes.clear();
                    NodeQueueLoadMonitor.this.sortedNodes.addAll(nodeIds);
                }
                catch (Exception ex) {
                    LOG.warn((Object)"Got Exception while sorting nodes..", (Throwable)ex);
                }
                if (NodeQueueLoadMonitor.this.thresholdCalculator != null) {
                    NodeQueueLoadMonitor.this.thresholdCalculator.update();
                }
            }
            finally {
                writeLock.unlock();
            }
        }
    };

    @VisibleForTesting
    NodeQueueLoadMonitor(LoadComparator comparator) {
        this.sortedNodes = new ArrayList<NodeId>();
        this.comparator = comparator;
        this.scheduledExecutor = null;
    }

    public NodeQueueLoadMonitor(long nodeComputationInterval, LoadComparator comparator) {
        this.sortedNodes = new ArrayList<NodeId>();
        this.scheduledExecutor = Executors.newScheduledThreadPool(1);
        this.comparator = comparator;
        this.scheduledExecutor.scheduleAtFixedRate(this.computeTask, nodeComputationInterval, nodeComputationInterval, TimeUnit.MILLISECONDS);
    }

    List<NodeId> getSortedNodes() {
        return this.sortedNodes;
    }

    public QueueLimitCalculator getThresholdCalculator() {
        return this.thresholdCalculator;
    }

    Map<NodeId, ClusterNode> getClusterNodes() {
        return this.clusterNodes;
    }

    Comparator<ClusterNode> getComparator() {
        return this.comparator;
    }

    public void initThresholdCalculator(float sigma, int limitMin, int limitMax) {
        this.thresholdCalculator = new QueueLimitCalculator(this, sigma, limitMin, limitMax);
    }

    @Override
    public void addNode(List<NMContainerStatus> containerStatuses, RMNode rmNode) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Node added event from: " + rmNode.getNode().getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNode(RMNode removedRMNode) {
        ClusterNode node;
        LOG.debug((Object)("Node delete event for: " + removedRMNode.getNode().getName()));
        ReentrantReadWriteLock.WriteLock writeLock = this.clusterNodesLock.writeLock();
        writeLock.lock();
        try {
            node = this.clusterNodes.remove(removedRMNode.getNodeID());
        }
        finally {
            writeLock.unlock();
        }
        if (LOG.isDebugEnabled()) {
            if (node != null) {
                LOG.debug((Object)("Delete ClusterNode: " + removedRMNode.getNodeID()));
            } else {
                LOG.debug((Object)"Node not in list!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNode(RMNode rmNode) {
        LOG.debug((Object)("Node update event from: " + rmNode.getNodeID()));
        OpportunisticContainersStatus opportunisticContainersStatus = rmNode.getOpportunisticContainersStatus();
        if (opportunisticContainersStatus == null) {
            opportunisticContainersStatus = OpportunisticContainersStatus.newInstance();
        }
        int estimatedQueueWaitTime = opportunisticContainersStatus.getEstimatedQueueWaitTime();
        int waitQueueLength = opportunisticContainersStatus.getWaitQueueLength();
        ReentrantReadWriteLock.WriteLock writeLock = this.clusterNodesLock.writeLock();
        writeLock.lock();
        try {
            ClusterNode currentNode = this.clusterNodes.get(rmNode.getNodeID());
            if (currentNode == null) {
                if (estimatedQueueWaitTime != -1 || this.comparator == LoadComparator.QUEUE_LENGTH) {
                    this.clusterNodes.put(rmNode.getNodeID(), new ClusterNode(rmNode.getNodeID()).setQueueWaitTime(estimatedQueueWaitTime).setQueueLength(waitQueueLength));
                    LOG.info((Object)("Inserting ClusterNode [" + rmNode.getNodeID() + "] " + "with queue wait time [" + estimatedQueueWaitTime + "] and " + "wait queue length [" + waitQueueLength + "]"));
                } else {
                    LOG.warn((Object)("IGNORING ClusterNode [" + rmNode.getNodeID() + "] " + "with queue wait time [" + estimatedQueueWaitTime + "] and " + "wait queue length [" + waitQueueLength + "]"));
                }
            } else if (estimatedQueueWaitTime != -1 || this.comparator == LoadComparator.QUEUE_LENGTH) {
                currentNode.setQueueWaitTime(estimatedQueueWaitTime).setQueueLength(waitQueueLength).updateTimestamp();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Updating ClusterNode [" + rmNode.getNodeID() + "] " + "with queue wait time [" + estimatedQueueWaitTime + "] and " + "wait queue length [" + waitQueueLength + "]"));
                }
            } else {
                this.clusterNodes.remove(rmNode.getNodeID());
                LOG.info((Object)("Deleting ClusterNode [" + rmNode.getNodeID() + "] " + "with queue wait time [" + currentNode.queueWaitTime + "] and " + "wait queue length [" + currentNode.queueLength + "]"));
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public void updateNodeResource(RMNode rmNode, ResourceOption resourceOption) {
        LOG.debug((Object)("Node resource update event from: " + rmNode.getNodeID()));
    }

    public List<NodeId> selectNodes() {
        return this.selectLeastLoadedNodes(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NodeId> selectLeastLoadedNodes(int k) {
        ReentrantReadWriteLock.ReadLock readLock = this.sortedNodesLock.readLock();
        readLock.lock();
        try {
            ArrayList<NodeId> retVal;
            ArrayList<NodeId> arrayList = retVal = k < this.sortedNodes.size() && k >= 0 ? new ArrayList<NodeId>(this.sortedNodes).subList(0, k) : new ArrayList<NodeId>(this.sortedNodes);
            return arrayList;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<NodeId> sortNodes() {
        ReentrantReadWriteLock.ReadLock readLock = this.clusterNodesLock.readLock();
        readLock.lock();
        try {
            ArrayList<ClusterNode> aList = new ArrayList<ClusterNode>(this.clusterNodes.values());
            ArrayList<NodeId> retList = new ArrayList<NodeId>();
            Object[] nodes = aList.toArray();
            Arrays.sort(nodes, this.comparator);
            for (int j = 0; j < nodes.length; ++j) {
                retList.add(((ClusterNode)nodes[j]).nodeId);
            }
            ArrayList<NodeId> arrayList = retList;
            return arrayList;
        }
        finally {
            readLock.unlock();
        }
    }

    static class ClusterNode {
        int queueLength = 0;
        int queueWaitTime = -1;
        double timestamp;
        final NodeId nodeId;

        public ClusterNode(NodeId nodeId) {
            this.nodeId = nodeId;
            this.updateTimestamp();
        }

        public ClusterNode setQueueLength(int qLength) {
            this.queueLength = qLength;
            return this;
        }

        public ClusterNode setQueueWaitTime(int wTime) {
            this.queueWaitTime = wTime;
            return this;
        }

        public ClusterNode updateTimestamp() {
            this.timestamp = System.currentTimeMillis();
            return this;
        }
    }

    public static enum LoadComparator implements Comparator<ClusterNode>
    {
        QUEUE_LENGTH,
        QUEUE_WAIT_TIME;


        @Override
        public int compare(ClusterNode o1, ClusterNode o2) {
            if (this.getMetric(o1) == this.getMetric(o2)) {
                return (int)(o2.timestamp - o1.timestamp);
            }
            return this.getMetric(o1) - this.getMetric(o2);
        }

        public int getMetric(ClusterNode c) {
            return this == QUEUE_LENGTH ? c.queueLength : c.queueWaitTime;
        }
    }
}

