/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.Replica;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;

public class TestPipelines {
    public static final Log LOG = LogFactory.getLog(TestPipelines.class);
    private static final short REPL_FACTOR = 3;
    private static final int RAND_LIMIT = 2000;
    private static final int FILE_SIZE = 10000;
    private MiniDFSCluster cluster;
    private DistributedFileSystem fs;
    private static Configuration conf;
    static final Random rand;

    @Before
    public void startUpCluster() throws IOException {
        this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
        this.fs = this.cluster.getFileSystem();
    }

    @After
    public void shutDownCluster() throws IOException {
        if (this.fs != null) {
            this.fs.close();
            this.fs = null;
        }
        if (this.cluster != null) {
            this.cluster.shutdownDataNodes();
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void pipeline_01() throws IOException {
        String METHOD_NAME = GenericTestUtils.getMethodName();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Running " + METHOD_NAME));
        }
        Path filePath = new Path("/" + METHOD_NAME + ".dat");
        DFSTestUtil.createFile((FileSystem)this.fs, filePath, 10000L, (short)3, rand.nextLong());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Invoking append but doing nothing otherwise...");
        }
        FSDataOutputStream ofs = this.fs.append(filePath);
        ofs.writeBytes("Some more stuff to write");
        ((DFSOutputStream)ofs.getWrappedStream()).hflush();
        List lb = this.cluster.getNameNodeRpc().getBlockLocations(filePath.toString(), 9999L, 10000L).getLocatedBlocks();
        for (DataNode dn : this.cluster.getDataNodes()) {
            Replica r = this.cluster.getFsDatasetTestUtils(dn).fetchReplica(((LocatedBlock)lb.get(0)).getBlock());
            Assert.assertTrue((String)("Replica on DN " + dn + " shouldn't be null"), (r != null ? 1 : 0) != 0);
            Assert.assertEquals((String)("Should be RBW replica on " + dn + " after sequence of calls append()/write()/hflush()"), (Object)HdfsServerConstants.ReplicaState.RBW, (Object)r.getState());
        }
        ofs.close();
    }

    public void pipeline_02_03() {
    }

    static byte[] writeData(FSDataOutputStream out, int length) throws IOException {
        int bytesToWriteNext;
        int bytesToWrite;
        byte[] ret = new byte[bytesToWrite];
        byte[] toWrite = new byte[1024];
        int written = 0;
        Random rb = new Random(rand.nextLong());
        for (bytesToWrite = length; bytesToWrite > 0; bytesToWrite -= bytesToWriteNext) {
            rb.nextBytes(toWrite);
            bytesToWriteNext = 1024 < bytesToWrite ? 1024 : bytesToWrite;
            out.write(toWrite, 0, bytesToWriteNext);
            System.arraycopy(toWrite, 0, ret, ret.length - bytesToWrite, bytesToWriteNext);
            written += bytesToWriteNext;
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Written: " + bytesToWriteNext + "; Total: " + written));
        }
        return ret;
    }

    private static void setConfiguration() {
        conf = new Configuration();
        int customPerChecksumSize = 700;
        int customBlockSize = customPerChecksumSize * 3;
        conf.setInt("dfs.client-write-packet-size", 100);
        conf.setInt("dfs.bytes-per-checksum", customPerChecksumSize);
        conf.setInt("dfs.blocksize", customBlockSize);
        conf.setInt("dfs.client-write-packet-size", customBlockSize / 2);
        conf.setInt("dfs.client.socket-timeout", 0);
    }

    private static void initLoggers() {
        DFSTestUtil.setNameNodeLogLevel(Level.ALL);
        GenericTestUtils.setLogLevel((Logger)DataNode.LOG, (Level)Level.ALL);
        GenericTestUtils.setLogLevel((Logger)DFSClient.LOG, (Level)Level.ALL);
    }

    static {
        rand = new Random(2000L);
        TestPipelines.initLoggers();
        TestPipelines.setConfiguration();
    }
}

