/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Supplier;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestNameNodeMetadataConsistency {
    private static final Path filePath1 = new Path("/testdata1.txt");
    private static final Path filePath2 = new Path("/testdata2.txt");
    private static final byte[] TEST_DATA_IN_FUTURE = "This is test data".getBytes();
    private static final int TEST_DATA_IN_FUTURE_LENGTH = TEST_DATA_IN_FUTURE.length;
    private static final int SCAN_INTERVAL = 1;
    private static final int WAIT_TIME_MS = 500;
    private static final int MAX_WAIT_TIME_MS = 60000;
    private MiniDFSCluster cluster;
    private HdfsConfiguration conf;

    @Before
    public void InitTest() throws IOException {
        this.conf = new HdfsConfiguration();
        this.conf.setLong("dfs.datanode.directoryscan.interval", 1L);
        this.cluster = new MiniDFSCluster.Builder((Configuration)this.conf).numDataNodes(1).build();
    }

    @After
    public void cleanup() {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void testGenerationStampInFuture() throws Exception {
        this.cluster.waitActive();
        DistributedFileSystem fs = this.cluster.getFileSystem();
        FSDataOutputStream ostream = fs.create(filePath1);
        ostream.write(TEST_DATA_IN_FUTURE);
        ostream.close();
        ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, filePath1);
        long genStamp = block.getGenerationStamp();
        boolean datanodeIndex = false;
        this.cluster.changeGenStampOfBlock(0, block, genStamp + 1L);
        DataNodeTestUtils.runDirectoryScanner(this.cluster.getDataNodes().get(0));
        MiniDFSCluster.DataNodeProperties dnProps = this.cluster.stopDataNode(0);
        this.cluster.restartNameNode(true);
        this.cluster.getNameNode().getNamesystem().writeLock();
        BlockInfo bInfo = this.cluster.getNameNode().getNamesystem().getBlockManager().getStoredBlock(block.getLocalBlock());
        bInfo.delete();
        this.cluster.getNameNode().getNamesystem().getBlockManager().removeBlock(bInfo);
        this.cluster.getNameNode().getNamesystem().writeUnlock();
        BlockManagerTestUtil.setStartupSafeModeForTest(this.cluster.getNameNode().getNamesystem().getBlockManager());
        this.cluster.restartDataNode(dnProps);
        this.waitForNumBytes(TEST_DATA_IN_FUTURE_LENGTH);
        Assert.assertEquals((long)TEST_DATA_IN_FUTURE_LENGTH, (long)this.cluster.getNameNode().getBytesWithFutureGenerationStamps());
        Assert.assertTrue((boolean)this.cluster.getNameNode().getNamesystem().getSafeModeTip().contains("Name node detected blocks with generation stamps in future"));
    }

    @Test
    public void testEnsureGenStampsIsStartupOnly() throws Exception {
        this.cluster.restartDataNodes();
        this.cluster.restartNameNodes();
        this.cluster.waitActive();
        DistributedFileSystem fs = this.cluster.getFileSystem();
        FSDataOutputStream ostream = fs.create(filePath2);
        ostream.write(TEST_DATA_IN_FUTURE);
        ostream.close();
        ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, filePath2);
        long genStamp = block.getGenerationStamp();
        this.cluster.changeGenStampOfBlock(0, block, genStamp + 1L);
        MiniDFSCluster.DataNodeProperties dnProps = this.cluster.stopDataNode(0);
        this.cluster.restartNameNode(true);
        BlockInfo bInfo = this.cluster.getNameNode().getNamesystem().getBlockManager().getStoredBlock(block.getLocalBlock());
        this.cluster.getNameNode().getNamesystem().writeLock();
        bInfo.delete();
        this.cluster.getNameNode().getNamesystem().getBlockManager().removeBlock(bInfo);
        this.cluster.getNameNode().getNamesystem().writeUnlock();
        this.cluster.restartDataNode(dnProps);
        this.waitForNumBytes(0);
        Assert.assertEquals((long)0L, (long)this.cluster.getNameNode().getBytesWithFutureGenerationStamps());
    }

    private void waitForNumBytes(final int numBytes) throws Exception {
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                try {
                    TestNameNodeMetadataConsistency.this.cluster.triggerBlockReports();
                    return TestNameNodeMetadataConsistency.this.cluster.getNameNode().getBytesWithFutureGenerationStamps() == (long)numBytes;
                }
                catch (Exception exception) {
                    return false;
                }
            }
        }, (int)500, (int)60000);
    }
}

