/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.fate.zookeeper;

import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;

public class ZooReservation {
    public static boolean attempt(IZooReaderWriter zk, String path, String reservationID, String debugInfo) throws KeeperException, InterruptedException {
        if (reservationID.contains(":")) {
            throw new IllegalArgumentException();
        }
        while (true) {
            try {
                zk.putPersistentData(path, (reservationID + ":" + debugInfo).getBytes(), ZooUtil.NodeExistsPolicy.FAIL);
                return true;
            }
            catch (KeeperException.NodeExistsException nee) {
                byte[] zooData;
                Stat stat = new Stat();
                try {
                    zooData = zk.getData(path, stat);
                }
                catch (KeeperException.NoNodeException nne) {
                    continue;
                }
                String idInZoo = new String(zooData).split(":")[0];
                return idInZoo.equals(new String(reservationID));
            }
            break;
        }
    }

    public static void release(IZooReaderWriter zk, String path, String reservationID) throws KeeperException, InterruptedException {
        byte[] zooData;
        Stat stat = new Stat();
        try {
            zooData = zk.getData(path, stat);
        }
        catch (KeeperException.NoNodeException e) {
            Logger.getLogger(ZooReservation.class).debug((Object)("Node does not exist " + path));
            return;
        }
        String idInZoo = new String(zooData).split(":")[0];
        if (!idInZoo.equals(new String(reservationID))) {
            throw new IllegalStateException("Tried to release reservation " + path + " with data mismatch " + new String(reservationID) + " " + new String(zooData));
        }
        zk.recursiveDelete(path, stat.getVersion(), ZooUtil.NodeMissingPolicy.SKIP);
    }
}

