/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.fate.zookeeper;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.log4j.Logger;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;

class ZooSession {
    private static final Logger log = Logger.getLogger(ZooSession.class);
    private static Map<String, ZooSessionInfo> sessions = new HashMap<String, ZooSessionInfo>();

    ZooSession() {
    }

    private static String sessionKey(String keepers, int timeout, String scheme, byte[] auth) {
        return keepers + ":" + timeout + ":" + (scheme == null ? "" : scheme) + ":" + (auth == null ? "" : new String(auth));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZooKeeper connect(String host, int timeout, String scheme, byte[] auth, Watcher watcher) {
        int TIME_BETWEEN_CONNECT_CHECKS_MS = 100;
        int TOTAL_CONNECT_TIME_WAIT_MS = 10000;
        boolean tryAgain = true;
        int sleepTime = 100;
        ZooKeeper zooKeeper = null;
        long startTime = System.currentTimeMillis();
        while (tryAgain) {
            try {
                zooKeeper = new ZooKeeper(host, timeout, watcher);
                for (int i = 0; i < 100 && tryAgain; ++i) {
                    if (zooKeeper.getState().equals((Object)ZooKeeper.States.CONNECTED)) {
                        if (auth != null) {
                            zooKeeper.addAuthInfo(scheme, auth);
                        }
                        tryAgain = false;
                        continue;
                    }
                    UtilWaitThread.sleep(100L);
                }
                if (System.currentTimeMillis() - startTime > (long)(2 * timeout)) {
                    throw new RuntimeException("Failed to connect to zookeeper (" + host + ") within 2x zookeeper timeout period " + timeout);
                }
            }
            catch (UnknownHostException uhe) {
                log.warn((Object)(uhe.getClass().getName() + " : " + uhe.getMessage()));
                throw new RuntimeException(uhe);
            }
            catch (IOException e) {
                log.warn((Object)("Connection to zooKeeper failed, will try again in " + String.format("%.2f secs", (double)sleepTime / 1000.0)), (Throwable)e);
            }
            finally {
                if (tryAgain && zooKeeper != null) {
                    try {
                        zooKeeper.close();
                        zooKeeper = null;
                    }
                    catch (InterruptedException e) {
                        log.warn((Object)"interrupted", (Throwable)e);
                    }
                }
            }
            if (!tryAgain) continue;
            UtilWaitThread.sleep(sleepTime);
            if (sleepTime >= 10000) continue;
            sleepTime = (int)((double)sleepTime + (double)sleepTime * Math.random());
        }
        return zooKeeper;
    }

    public static synchronized ZooKeeper getSession(String zooKeepers, int timeout) {
        return ZooSession.getSession(zooKeepers, timeout, null, null);
    }

    public static synchronized ZooKeeper getSession(String zooKeepers, int timeout, String scheme, byte[] auth) {
        String sessionKey = ZooSession.sessionKey(zooKeepers, timeout, scheme, auth);
        String readOnlySessionKey = ZooSession.sessionKey(zooKeepers, timeout, null, null);
        ZooSessionInfo zsi = sessions.get(sessionKey);
        if (zsi != null && zsi.zooKeeper.getState() == ZooKeeper.States.CLOSED) {
            if (auth != null && sessions.get(readOnlySessionKey) == zsi) {
                sessions.remove(readOnlySessionKey);
            }
            zsi = null;
            sessions.remove(sessionKey);
        }
        if (zsi == null) {
            ZooWatcher watcher = new ZooWatcher();
            log.debug((Object)("Connecting to " + zooKeepers + " with timeout " + timeout + " with auth"));
            zsi = new ZooSessionInfo(ZooSession.connect(zooKeepers, timeout, scheme, auth, watcher), watcher);
            sessions.put(sessionKey, zsi);
            if (auth != null && !sessions.containsKey(readOnlySessionKey)) {
                sessions.put(readOnlySessionKey, zsi);
            }
        }
        return zsi.zooKeeper;
    }

    private static class ZooWatcher
    implements Watcher {
        private HashSet<Watcher> watchers = new HashSet();

        private ZooWatcher() {
        }

        public void process(WatchedEvent event) {
            ArrayList<Watcher> watcherCopy = new ArrayList<Watcher>(this.watchers);
            for (Watcher watcher : watcherCopy) {
                watcher.process(event);
            }
            if (event.getState() == Watcher.Event.KeeperState.Expired) {
                log.debug((Object)("Session expired, state of current session : " + event.getState()));
            }
        }
    }

    private static class ZooSessionInfo {
        ZooKeeper zooKeeper;

        public ZooSessionInfo(ZooKeeper zooKeeper, ZooWatcher watcher) {
            this.zooKeeper = zooKeeper;
        }
    }
}

