/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.impl;

import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.htrace.Span;
import org.apache.htrace.TimelineAnnotation;
import org.apache.htrace.Tracer;
import org.apache.htrace.fasterxml.jackson.core.JsonParser;
import org.apache.htrace.fasterxml.jackson.core.JsonProcessingException;
import org.apache.htrace.fasterxml.jackson.databind.DeserializationContext;
import org.apache.htrace.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.htrace.fasterxml.jackson.databind.JsonNode;
import org.apache.htrace.fasterxml.jackson.databind.ObjectMapper;
import org.apache.htrace.fasterxml.jackson.databind.ObjectReader;
import org.apache.htrace.fasterxml.jackson.databind.ObjectWriter;
import org.apache.htrace.fasterxml.jackson.databind.annotation.JsonDeserialize;

@JsonDeserialize(using=MilliSpanDeserializer.class)
public class MilliSpan
implements Span {
    private static ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static ObjectReader JSON_READER = OBJECT_MAPPER.reader(MilliSpan.class);
    private static ObjectWriter JSON_WRITER = OBJECT_MAPPER.writer();
    private static final long[] EMPTY_PARENT_ARRAY = new long[0];
    private static final String EMPTY_STRING = "";
    private long begin;
    private long end;
    private final String description;
    private final long traceId;
    private long[] parents;
    private final long spanId;
    private Map<String, String> traceInfo = null;
    private String processId;
    private List<TimelineAnnotation> timeline = null;
    private static final Random random = new Random();

    private static long nonZeroRandom64() {
        long id;
        while ((id = random.nextLong()) == 0L) {
        }
        return id;
    }

    @Override
    public Span child(String childDescription) {
        return new Builder().begin(System.currentTimeMillis()).end(0L).description(childDescription).traceId(this.traceId).parents(new long[]{this.spanId}).spanId(MilliSpan.nonZeroRandom64()).processId(this.processId).build();
    }

    public MilliSpan() {
        this.begin = 0L;
        this.end = 0L;
        this.description = EMPTY_STRING;
        this.traceId = 0L;
        this.parents = EMPTY_PARENT_ARRAY;
        this.spanId = 0L;
        this.traceInfo = null;
        this.processId = EMPTY_STRING;
        this.timeline = null;
    }

    private MilliSpan(Builder builder) {
        this.begin = builder.begin;
        this.end = builder.end;
        this.description = builder.description;
        this.traceId = builder.traceId;
        this.parents = builder.parents;
        this.spanId = builder.spanId;
        this.traceInfo = builder.traceInfo;
        this.processId = builder.processId;
        this.timeline = builder.timeline;
    }

    @Override
    public synchronized void stop() {
        if (this.end == 0L) {
            if (this.begin == 0L) {
                throw new IllegalStateException("Span for " + this.description + " has not been started");
            }
            this.end = System.currentTimeMillis();
            Tracer.getInstance().deliver(this);
        }
    }

    protected long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    @Override
    public synchronized boolean isRunning() {
        return this.begin != 0L && this.end == 0L;
    }

    @Override
    public synchronized long getAccumulatedMillis() {
        if (this.begin == 0L) {
            return 0L;
        }
        if (this.end > 0L) {
            return this.end - this.begin;
        }
        return this.currentTimeMillis() - this.begin;
    }

    @Override
    public String toString() {
        return this.toJson();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public long getSpanId() {
        return this.spanId;
    }

    @Override
    public long[] getParents() {
        return this.parents;
    }

    @Override
    public void setParents(long[] parents) {
        this.parents = parents;
    }

    @Override
    public long getTraceId() {
        return this.traceId;
    }

    @Override
    public long getStartTimeMillis() {
        return this.begin;
    }

    @Override
    public long getStopTimeMillis() {
        return this.end;
    }

    @Override
    public void addKVAnnotation(byte[] key, byte[] value) {
        try {
            this.addKVAnnotation(new String(key, "UTF-8"), new String(value, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addKVAnnotation(String key, String value) {
        if (this.traceInfo == null) {
            this.traceInfo = new HashMap<String, String>();
        }
        this.traceInfo.put(key, value);
    }

    @Override
    public void addTimelineAnnotation(String msg) {
        if (this.timeline == null) {
            this.timeline = new ArrayList<TimelineAnnotation>();
        }
        this.timeline.add(new TimelineAnnotation(System.currentTimeMillis(), msg));
    }

    @Override
    public Map<String, String> getKVAnnotations() {
        if (this.traceInfo == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.traceInfo);
    }

    @Override
    public List<TimelineAnnotation> getTimelineAnnotations() {
        if (this.timeline == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.timeline);
    }

    @Override
    public String getProcessId() {
        return this.processId;
    }

    @Override
    public void setProcessId(String processId) {
        this.processId = processId;
    }

    @Override
    public String toJson() {
        StringWriter writer = new StringWriter();
        try {
            JSON_WRITER.writeValue(writer, (Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return writer.toString();
    }

    private static long parseUnsignedHexLong(String s) {
        return new BigInteger(s, 16).longValue();
    }

    static MilliSpan fromJson(String json) throws IOException {
        return (MilliSpan)JSON_READER.readValue(json);
    }

    static /* synthetic */ long[] access$000() {
        return EMPTY_PARENT_ARRAY;
    }

    public static class MilliSpanDeserializer
    extends JsonDeserializer<MilliSpan> {
        @Override
        public MilliSpan deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode timelineNode;
            JsonNode rNode;
            JsonNode sNode;
            JsonNode iNode;
            JsonNode dNode;
            JsonNode eNode;
            JsonNode root = (JsonNode)jp.getCodec().readTree(jp);
            Builder builder = new Builder();
            JsonNode bNode = root.get("b");
            if (bNode != null) {
                builder.begin(bNode.asLong());
            }
            if ((eNode = root.get("e")) != null) {
                builder.end(eNode.asLong());
            }
            if ((dNode = root.get("d")) != null) {
                builder.description(dNode.asText());
            }
            if ((iNode = root.get("i")) != null) {
                builder.traceId(MilliSpan.parseUnsignedHexLong(iNode.asText()));
            }
            if ((sNode = root.get("s")) != null) {
                builder.spanId(MilliSpan.parseUnsignedHexLong(sNode.asText()));
            }
            if ((rNode = root.get("r")) != null) {
                builder.processId(rNode.asText());
            }
            JsonNode parentsNode = root.get("p");
            LinkedList<Long> parents = new LinkedList<Long>();
            if (parentsNode != null) {
                Iterator<JsonNode> iter = parentsNode.elements();
                while (iter.hasNext()) {
                    JsonNode parentIdNode = iter.next();
                    parents.add(MilliSpan.parseUnsignedHexLong(parentIdNode.asText()));
                }
            }
            builder.parents(parents);
            JsonNode traceInfoNode = root.get("n");
            if (traceInfoNode != null) {
                HashMap<String, String> traceInfo = new HashMap<String, String>();
                Iterator<String> iter = traceInfoNode.fieldNames();
                while (iter.hasNext()) {
                    String field = iter.next();
                    traceInfo.put(field, traceInfoNode.get(field).asText());
                }
                builder.traceInfo(traceInfo);
            }
            if ((timelineNode = root.get("t")) != null) {
                LinkedList<TimelineAnnotation> timeline = new LinkedList<TimelineAnnotation>();
                Iterator<JsonNode> iter = timelineNode.elements();
                while (iter.hasNext()) {
                    JsonNode ann = iter.next();
                    timeline.add(new TimelineAnnotation(ann.get("t").asLong(), ann.get("m").asText()));
                }
                builder.timeline(timeline);
            }
            return builder.build();
        }
    }

    public static class Builder {
        private long begin;
        private long end;
        private String description = "";
        private long traceId;
        private long[] parents = MilliSpan.access$000();
        private long spanId;
        private Map<String, String> traceInfo = null;
        private String processId = "";
        private List<TimelineAnnotation> timeline = null;

        public Builder begin(long begin) {
            this.begin = begin;
            return this;
        }

        public Builder end(long end) {
            this.end = end;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder traceId(long traceId) {
            this.traceId = traceId;
            return this;
        }

        public Builder parents(long[] parents) {
            this.parents = parents;
            return this;
        }

        public Builder parents(List<Long> parentList) {
            long[] parents = new long[parentList.size()];
            for (int i = 0; i < parentList.size(); ++i) {
                parents[i] = parentList.get(i);
            }
            this.parents = parents;
            return this;
        }

        public Builder spanId(long spanId) {
            this.spanId = spanId;
            return this;
        }

        public Builder traceInfo(Map<String, String> traceInfo) {
            this.traceInfo = traceInfo.isEmpty() ? null : traceInfo;
            return this;
        }

        public Builder processId(String processId) {
            this.processId = processId;
            return this;
        }

        public Builder timeline(List<TimelineAnnotation> timeline) {
            this.timeline = timeline.isEmpty() ? null : timeline;
            return this;
        }

        public MilliSpan build() {
            return new MilliSpan(this);
        }
    }
}

