/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.VertexManagerPluginContext;
import org.apache.tez.dag.api.event.VertexStateUpdate;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.TaskAttemptIdentifier;
import org.apache.tez.runtime.api.events.VertexManagerEvent;

@InterfaceStability.Unstable
@InterfaceAudience.Public
public abstract class VertexManagerPlugin {
    private final VertexManagerPluginContext context;

    public VertexManagerPlugin(VertexManagerPluginContext context) {
        this.context = context;
    }

    public abstract void initialize() throws Exception;

    @Deprecated
    public void onVertexStarted(Map<String, List<Integer>> completions) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void onVertexStarted(List<TaskAttemptIdentifier> completions) throws Exception {
        HashMap<String, List<Integer>> completionsMap = new HashMap<String, List<Integer>>();
        for (TaskAttemptIdentifier attempt : completions) {
            String vName = attempt.getTaskIdentifier().getVertexIdentifier().getName();
            LinkedList<Integer> tasks = (LinkedList<Integer>)completionsMap.get(vName);
            if (tasks == null) {
                tasks = new LinkedList<Integer>();
                completionsMap.put(vName, tasks);
            }
            tasks.add(attempt.getTaskIdentifier().getIdentifier());
        }
        this.onVertexStarted(completionsMap);
    }

    @Deprecated
    public void onSourceTaskCompleted(String srcVertexName, Integer taskId) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void onSourceTaskCompleted(TaskAttemptIdentifier attempt) throws Exception {
        this.onSourceTaskCompleted(attempt.getTaskIdentifier().getVertexIdentifier().getName(), attempt.getTaskIdentifier().getIdentifier());
    }

    public abstract void onVertexManagerEventReceived(VertexManagerEvent var1) throws Exception;

    public abstract void onRootVertexInitialized(String var1, InputDescriptor var2, List<Event> var3) throws Exception;

    public final VertexManagerPluginContext getContext() {
        return this.context;
    }

    public void onVertexStateUpdated(VertexStateUpdate stateUpdate) throws Exception {
    }
}

