/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.plan;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.DistinctCombiner;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PlanPrinter;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezEdgeDescriptor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperPlan;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperator;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezPlanContainer;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezPlanContainerNode;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezPlanContainerVisitor;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;

public class TezPrinter
extends TezOpPlanVisitor {
    private PrintStream mStream = null;
    private boolean isVerbose = true;

    public TezPrinter(PrintStream ps, TezOperPlan plan) {
        super(plan, (PlanWalker<TezOperator, TezOperPlan>)new DependencyOrderWalker<TezOperator, TezOperPlan>(plan, true));
        this.mStream = ps;
    }

    public void setVerbose(boolean verbose) {
        this.isVerbose = verbose;
    }

    @Override
    public void visitTezOp(TezOperator tezOper) throws VisitorException {
        if (tezOper.isVertexGroup()) {
            TezOperator.VertexGroupInfo info = tezOper.getVertexGroupInfo();
            this.mStream.print("Tez vertex group " + tezOper.getOperatorKey().toString());
            if (info != null) {
                this.mStream.println("\t<-\t " + info.getInputs() + "\t->\t " + info.getOutput());
            } else {
                this.mStream.println();
            }
            this.mStream.println("# No plan on vertex group");
        } else {
            this.mStream.println("Tez vertex " + tezOper.getOperatorKey().toString());
        }
        if (tezOper.inEdges.size() > 0) {
            ArrayList<OperatorKey> inEdges = new ArrayList<OperatorKey>(tezOper.inEdges.keySet());
            Collections.sort(inEdges);
            for (OperatorKey inEdge : inEdges) {
                TezEdgeDescriptor edgeDesc = tezOper.inEdges.get(inEdge);
                if (!edgeDesc.combinePlan.isEmpty()) {
                    this.mStream.println("# Combine plan on edge <" + inEdge + ">");
                    PlanPrinter printer = new PlanPrinter(edgeDesc.combinePlan, this.mStream);
                    printer.setVerbose(this.isVerbose);
                    printer.visit();
                    this.mStream.println();
                    continue;
                }
                if (!edgeDesc.needsDistinctCombiner()) continue;
                this.mStream.println("# Combine plan on edge <" + inEdge + ">");
                this.mStream.println(DistinctCombiner.Combine.class.getName());
            }
        }
        if (tezOper.plan != null && tezOper.plan.size() > 0) {
            this.mStream.println("# Plan on vertex");
            PlanPrinter printer = new PlanPrinter(tezOper.plan, this.mStream);
            printer.setVerbose(this.isVerbose);
            printer.visit();
            this.mStream.println();
        } else if (!tezOper.isVertexGroup()) {
            this.mStream.println("" + tezOper);
        }
    }

    public static class TezDAGGraphPrinter
    extends TezPlanContainerVisitor {
        StringBuilder buf = new StringBuilder();

        public TezDAGGraphPrinter(TezPlanContainer plan) {
            super(plan, (PlanWalker<TezPlanContainerNode, TezPlanContainer>)new DependencyOrderWalker<TezPlanContainerNode, TezPlanContainer>(plan, true));
        }

        @Override
        public void visitTezPlanContainerNode(TezPlanContainerNode tezPlanContainerNode) throws VisitorException {
            TezDAGGraphPrinter.writePlan((TezPlanContainer)this.mPlan, tezPlanContainerNode, this.buf);
        }

        public static void writePlan(TezPlanContainer mPlan, TezPlanContainerNode tezPlanContainerNode, StringBuilder buf) {
            buf.append("Tez DAG " + tezPlanContainerNode.getOperatorKey().toString());
            List<TezPlanContainerNode> succs = mPlan.getSuccessors(tezPlanContainerNode);
            if (succs != null) {
                Collections.sort(succs);
                buf.append("\t->\t");
                for (TezPlanContainerNode op : succs) {
                    buf.append("Tez DAG " + op.getOperatorKey().toString()).append(",");
                }
            }
            buf.append("\n");
        }

        public String toString() {
            this.buf.append("\n");
            return this.buf.toString();
        }
    }

    public static class TezVertexGraphPrinter
    extends TezOpPlanVisitor {
        StringBuilder buf = new StringBuilder();

        public TezVertexGraphPrinter(TezOperPlan plan) {
            super(plan, (PlanWalker<TezOperator, TezOperPlan>)new DependencyOrderWalker<TezOperator, TezOperPlan>(plan, true));
        }

        @Override
        public void visitTezOp(TezOperator tezOper) throws VisitorException {
            TezVertexGraphPrinter.writePlan((TezOperPlan)this.mPlan, tezOper, this.buf);
        }

        public static void writePlan(TezOperPlan plan, TezOperator tezOper, StringBuilder buf) {
            if (tezOper.isVertexGroup()) {
                buf.append("Tez vertex group " + tezOper.getOperatorKey().toString());
            } else {
                buf.append("Tez vertex " + tezOper.getOperatorKey().toString());
            }
            List<TezOperator> succs = plan.getSuccessors(tezOper);
            if (succs != null) {
                Collections.sort(succs);
                buf.append("\t->\t");
                for (TezOperator op : succs) {
                    if (op.isVertexGroup()) {
                        buf.append("Tez vertex group " + op.getOperatorKey().toString()).append(",");
                        continue;
                    }
                    buf.append("Tez vertex " + op.getOperatorKey().toString()).append(",");
                }
            }
            buf.append("\n");
        }

        public String toString() {
            this.buf.append("\n");
            return this.buf.toString();
        }
    }
}

