/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.plan.optimizer;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.hadoop.executionengine.optimizer.SecondaryKeyOptimizer;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.util.PlanHelper;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezEdgeDescriptor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperPlan;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperator;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.POLocalRearrangeTez;
import org.apache.pig.backend.hadoop.executionengine.util.SecondaryKeyOptimizerUtil;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;

@InterfaceAudience.Private
public class SecondaryKeyOptimizerTez
extends TezOpPlanVisitor
implements SecondaryKeyOptimizer {
    private static Log log = LogFactory.getLog(SecondaryKeyOptimizerTez.class);
    private int numSortRemoved = 0;
    private int numDistinctChanged = 0;
    private int numUseSecondaryKey = 0;

    public SecondaryKeyOptimizerTez(TezOperPlan plan) {
        super(plan, (PlanWalker<TezOperator, TezOperPlan>)new DependencyOrderWalker<TezOperator, TezOperPlan>(plan));
    }

    @Override
    public void visitTezOp(TezOperator to) throws VisitorException {
        SecondaryKeyOptimizerUtil secondaryKeyOptUtil;
        SecondaryKeyOptimizerUtil.SecondaryKeyOptimizerInfo info;
        List<TezOperator> predecessors = ((TezOperPlan)this.mPlan).getPredecessors(to);
        if (predecessors == null) {
            return;
        }
        if (predecessors.size() > 1) {
            return;
        }
        TezOperator from = predecessors.get(0);
        LinkedList<POLocalRearrangeTez> rearranges = PlanHelper.getPhysicalOperators(from.plan, POLocalRearrangeTez.class);
        if (rearranges.isEmpty()) {
            return;
        }
        POLocalRearrangeTez connectingLR = null;
        PhysicalPlan rearrangePlan = from.plan;
        for (POLocalRearrangeTez lr : rearranges) {
            if (!lr.containsOutputKey(to.getOperatorKey().toString())) continue;
            connectingLR = lr;
            break;
        }
        if (connectingLR == null) {
            return;
        }
        TezEdgeDescriptor inEdge = to.inEdges.get(from.getOperatorKey());
        if (from.isGlobalSort()) {
            return;
        }
        if (inEdge.partitionerClass != null) {
            return;
        }
        if (from.plan.getOperator(connectingLR.getOperatorKey()) == null) {
            rearrangePlan = PlanHelper.getLocalRearrangePlanFromSplit(from.plan, connectingLR.getOperatorKey());
        }
        if ((info = (secondaryKeyOptUtil = new SecondaryKeyOptimizerUtil()).applySecondaryKeySort(rearrangePlan, to.plan)) != null) {
            this.numSortRemoved += info.getNumSortRemoved();
            this.numDistinctChanged += info.getNumDistinctChanged();
            this.numUseSecondaryKey += info.getNumUseSecondaryKey();
            if (info.isUseSecondaryKey()) {
                to.setUseSecondaryKey(true);
                inEdge.setUseSecondaryKey(true);
                inEdge.setSecondarySortOrder(info.getSecondarySortOrder());
                log.info((Object)("Using Secondary Key Optimization in the edge between vertex - " + from.getOperatorKey() + " and vertex - " + to.getOperatorKey()));
            }
        }
    }

    @Override
    public int getNumSortRemoved() {
        return this.numSortRemoved;
    }

    @Override
    public int getNumDistinctChanged() {
        return this.numDistinctChanged;
    }

    @Override
    public int getNumUseSecondaryKey() {
        return this.numUseSecondaryKey;
    }
}

