/*
 * Decompiled with CFR 0.152.
 */
package sdsu.io;

import java.io.IOException;
import java.io.PrintStream;
import sdsu.io.ASCIIInputStream;
import sdsu.io.Format;

public class Console {
    private static ASCIIInputStream input = new ASCIIInputStream(System.in);

    public static boolean bad() {
        return input.bad();
    }

    public static boolean checkError() {
        return System.out.checkError();
    }

    public static boolean eof() {
        try {
            return input.eof();
        }
        catch (IOException iOException) {
            Console.exitProgram(iOException, "IO error checking for end of file");
            return false;
        }
    }

    private static void exitProgram(Exception exception, String string) {
        System.err.println(string);
        System.err.println(exception.getMessage());
        System.exit(1);
    }

    public static void flush() {
        System.out.flush();
    }

    public static void flushLine() {
        try {
            input.flushLine();
        }
        catch (Exception exception) {
            Console.exitProgram(exception, "IO error in flushLine");
        }
    }

    public static void main(String[] stringArray) {
        Console.print("Print an integer ");
        int n = Console.readInt();
        Console.println("You typed: " + n);
        int n2 = Console.readInt("Print another integer");
        Console.print("You typed: %20i\n ", n2);
        String string = Console.readLine("Type a line of text");
        Console.println(5);
        Console.print("Hi Mom");
        Console.println(" Hi Dad");
        double d = 1.23456789012;
        double d2 = 123.0;
        double d3 = 1.2345E30;
        double d4 = 1.02;
        double d5 = 1.234E-5;
        int n3 = 51966;
        Console.print("x = |%f|\n", d);
        Console.print("u = |%20f|\n", d5);
        Console.print("x = |% .5f|\n", d);
        Console.print("w = |%20.5f|\n", d4);
        Console.print("x = |%020.5f|\n", d);
        Console.print("x = |%+20.5f|\n", d);
        Console.print("x = |%+020.5f|\n", d);
        Console.print("x = |% 020.5f|\n", d);
        Console.print("y = |%#+20.5f|\n", d2);
        Console.print("y = |%-+20.5f|\n", d2);
        Console.print("z = |%20.5f|\n", d3);
    }

    public static void print(char c) {
        System.out.print(c);
        Console.flush();
    }

    public static void print(double d) {
        System.out.print(d);
        Console.flush();
    }

    public static void print(float f) {
        System.out.print(f);
        Console.flush();
    }

    public static void print(int n) {
        System.out.print(n);
        Console.flush();
    }

    public static void print(long l) {
        System.out.print(l);
        Console.flush();
    }

    public static void print(Object object) {
        System.out.print(object);
        Console.flush();
    }

    public static void print(String string) {
        System.out.print(string);
        Console.flush();
    }

    public static void print(String string, char c) {
        try {
            Format.print((PrintStream)System.out, (String)string, (char)c);
            Console.flush();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Console.exitProgram(illegalArgumentException, "Format problem with " + string);
        }
    }

    public static void print(String string, double d) {
        try {
            Format.print((PrintStream)System.out, (String)string, (double)d);
            Console.flush();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Console.exitProgram(illegalArgumentException, "Format problem with " + string);
        }
    }

    public static void print(String string, long l) {
        try {
            Format.print((PrintStream)System.out, (String)string, (long)l);
            Console.flush();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Console.exitProgram(illegalArgumentException, "Format problem with " + string);
        }
    }

    public static void print(String string, String string2) {
        try {
            Format.print((PrintStream)System.out, (String)string, (String)string2);
            Console.flush();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Console.exitProgram(illegalArgumentException, "Format problem with " + string);
        }
    }

    public static void print(boolean bl) {
        System.out.print(bl);
        Console.flush();
    }

    public static void print(char[] cArray) {
        System.out.print(cArray);
        Console.flush();
    }

    protected static void printPrompt(String string) {
        System.out.print(String.valueOf(string) + " ");
        System.out.flush();
    }

    public static void println() {
        System.out.println();
        Console.flush();
    }

    public static void println(char c) {
        System.out.println(c);
        Console.flush();
    }

    public static void println(double d) {
        System.out.println(d);
        Console.flush();
    }

    public static void println(float f) {
        System.out.println(f);
        Console.flush();
    }

    public static void println(int n) {
        System.out.println(n);
        Console.flush();
    }

    public static void println(long l) {
        System.out.println(l);
        Console.flush();
    }

    public static void println(Object object) {
        System.out.println(object);
        Console.flush();
    }

    public static void println(String string) {
        System.out.println(string);
        Console.flush();
    }

    public static void println(boolean bl) {
        System.out.println(bl);
        Console.flush();
    }

    public static boolean readBoolean() {
        try {
            return input.readBoolean();
        }
        catch (Exception exception) {
            Console.exitProgram(exception, "Read error in readBoolean");
            return false;
        }
    }

    public static boolean readBoolean(String string) {
        Console.printPrompt(string);
        return Console.readBoolean();
    }

    public static char readChar() {
        try {
            return input.readChar();
        }
        catch (Exception exception) {
            Console.exitProgram(exception, "Read error in readChar");
            return 'a';
        }
    }

    public static char readChar(String string) {
        Console.printPrompt(string);
        return Console.readChar();
    }

    public static double readDouble() {
        try {
            return input.readDouble();
        }
        catch (Exception exception) {
            Console.exitProgram(exception, "Read error in readDouble");
            return 0.0;
        }
    }

    public static double readDouble(String string) {
        Console.printPrompt(string);
        return Console.readDouble();
    }

    public static float readFloat() {
        try {
            return input.readFloat();
        }
        catch (Exception exception) {
            Console.exitProgram(exception, "Read error in readFloat");
            return 0.0f;
        }
    }

    public static float readFloat(String string) {
        Console.printPrompt(string);
        return Console.readFloat();
    }

    public static int readInt() {
        try {
            return input.readInt();
        }
        catch (Exception exception) {
            Console.exitProgram(exception, "Read error in readInt");
            return 0;
        }
    }

    public static int readInt(String string) {
        Console.printPrompt(string);
        return Console.readInt();
    }

    public static String readLine() {
        try {
            return input.readLine();
        }
        catch (Exception exception) {
            Console.exitProgram(exception, "Read error in readInt");
            return "";
        }
    }

    public static String readLine(String string) {
        Console.printPrompt(string);
        return Console.readLine();
    }

    public static long readLong() {
        try {
            return input.readLong();
        }
        catch (Exception exception) {
            Console.exitProgram(exception, "Read error in readLong");
            return 0L;
        }
    }

    public static long readLong(String string) {
        Console.printPrompt(string);
        return Console.readLong();
    }

    public static short readShort() {
        try {
            return input.readShort();
        }
        catch (Exception exception) {
            Console.exitProgram(exception, "Read error in readShort");
            return 0;
        }
    }

    public static short readShort(String string) {
        Console.printPrompt(string);
        return Console.readShort();
    }

    public static String readWord() {
        try {
            return input.readWord();
        }
        catch (Exception exception) {
            Console.exitProgram(exception, "Read error in readWord");
            return "";
        }
    }

    public static String readWord(String string) {
        Console.printPrompt(string);
        return Console.readWord();
    }
}

