/*
 * Decompiled with CFR 0.152.
 */
package sdsu.io;

import java.io.BufferedReader;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import sdsu.util.CharQueue;

public class StringReplaceReader
extends FilterReader
implements Cloneable {
    protected CharQueue outputBuffer;
    protected char[] inputBuffer;
    protected int[] shiftTable;
    protected int inputBufferCharCount;
    protected char[] patternToFind = null;
    protected char[] replacementPattern = null;
    protected boolean reachedEOF = false;
    protected static int EOFIndicator = -1;
    protected static int DEFAULT_BUFFER_SIZE = 1024;

    public StringReplaceReader(InputStream inputStream, String string, String string2) {
        this(new BufferedReader(new InputStreamReader(inputStream)), string, string2);
    }

    public StringReplaceReader(Reader reader, String string, String string2) {
        super(reader);
        this.patternToFind = string.toCharArray();
        this.replacementPattern = string2.toCharArray();
        this.allocateBuffers();
    }

    public StringReplaceReader(String string, String string2, String string3) {
        this(new StringReader(string), string2, string3);
    }

    private void allocateBuffers() {
        this.outputBuffer = new CharQueue(DEFAULT_BUFFER_SIZE);
        this.inputBuffer = new char[Math.max(this.patternToFind.length + 1, DEFAULT_BUFFER_SIZE)];
        this.inputBufferCharCount = 0;
        this.shiftTable = new int[126];
        int n = 0;
        while (n < this.shiftTable.length) {
            this.shiftTable[n] = this.patternToFind.length + 1;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.patternToFind.length) {
            if (this.patternToFind[n2] < this.shiftTable.length) {
                this.shiftTable[this.patternToFind[n2]] = this.patternToFind.length - n2;
            }
            ++n2;
        }
    }

    public String contents() throws IOException {
        StringBuffer stringBuffer = new StringBuffer(1024);
        int n = 512;
        char[] cArray = new char[n];
        int n2 = this.read(cArray, 0, n);
        while (n2 != EOFIndicator) {
            stringBuffer.append(cArray, 0, n2);
            n2 = this.read(cArray, 0, n);
        }
        return stringBuffer.toString();
    }

    public boolean eof() {
        return this.reachedEOF;
    }

    protected final void fillInputWindow() throws IOException {
        int n = this.inputBufferCharCount;
        int n2 = this.inputBuffer.length - this.inputBufferCharCount;
        int n3 = this.in.read(this.inputBuffer, n, n2);
        if (n3 == n2) {
            this.inputBufferCharCount += n3;
            n2 = 0;
        } else if (n3 > 0) {
            this.inputBufferCharCount += n3;
            n2 -= n3;
        } else if (n3 == EOFIndicator) {
            this.reachedEOF = true;
        } else {
            throw new IOException("Read attempted. Did not reach EOF and  no chars were read");
        }
    }

    protected void filterInput() throws IOException {
        int n = 0;
        int n2 = 0;
        int n3 = this.patternToFind.length;
        while (n < this.inputBufferCharCount - n3 + 1) {
            boolean bl = true;
            int n4 = 0;
            while (n4 < n3) {
                if (this.patternToFind[n4] != this.inputBuffer[n4 + n]) {
                    bl = false;
                    break;
                }
                ++n4;
            }
            if (bl) {
                this.outputBuffer.enqueue(this.inputBuffer, n2, n - n2);
                this.replacementPatternToBuffer();
                n = n2 = n + n3;
                continue;
            }
            int n5 = n + n3;
            if (n5 >= this.inputBufferCharCount) {
                ++n;
                continue;
            }
            n += this.getShift(this.inputBuffer[n5]);
        }
        if (n > this.inputBufferCharCount) {
            n = this.inputBufferCharCount;
        }
        if (this.reachedEOF) {
            this.outputBuffer.enqueue(this.inputBuffer, n2, this.inputBufferCharCount - n2);
            this.inputBufferCharCount = 0;
        } else {
            this.outputBuffer.enqueue(this.inputBuffer, n2, n - n2);
            System.arraycopy(this.inputBuffer, n, this.inputBuffer, 0, this.inputBufferCharCount - n);
            this.inputBufferCharCount -= n;
        }
    }

    protected int getShift(char c) {
        if (c >= this.shiftTable.length) {
            return 1;
        }
        return this.shiftTable[c];
    }

    public int read() throws IOException {
        char[] cArray = new char[1];
        int n = this.read(cArray, 0, 1);
        if (n == EOFIndicator) {
            return EOFIndicator;
        }
        if (n == 1) {
            return cArray[0];
        }
        throw new IOException("Single Read attempted. Did not reach EOF and  no chars were read");
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2 && !this.eof()) {
            if (this.outputBuffer.isEmpty()) {
                this.fillInputWindow();
                this.filterInput();
            }
            n3 += this.outputBuffer.dequeue(cArray, n + n3, n2 - n3);
        }
        if (n3 > 0) {
            return n3;
        }
        if (this.outputBuffer.size() > 0) {
            n3 = this.outputBuffer.dequeue(cArray, n, n2);
            return n3;
        }
        if (this.eof() && this.inputBufferCharCount > 0 && this.inputBufferCharCount < this.patternToFind.length) {
            this.transferRemainingInputToOutputBuffer();
            System.out.println(">> End << " + this.outputBuffer);
            n3 = this.outputBuffer.dequeue(cArray, n, n2);
            return n3;
        }
        if (this.eof()) {
            return EOFIndicator;
        }
        throw new IOException("Read attempted. Did not reach EOF and  no chars were read");
    }

    public void replace(String string, String string2) throws OutOfMemoryError {
        if (this.patternToFind != null) {
            try {
                StringReplaceReader stringReplaceReader = (StringReplaceReader)this.clone();
                this.in = stringReplaceReader;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {}
        }
        this.patternToFind = string.toCharArray();
        this.replacementPattern = string2.toCharArray();
        this.allocateBuffers();
        this.reachedEOF = false;
    }

    protected void replacementPatternToBuffer() {
        this.outputBuffer.enqueue(this.replacementPattern);
    }

    private void transferRemainingInputToOutputBuffer() {
        this.outputBuffer.enqueue(this.inputBuffer, 0, this.inputBufferCharCount);
        this.inputBufferCharCount = 0;
    }
}

