/*
 * Decompiled with CFR 0.152.
 */
package sdsu.logging;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import sdsu.logging.Logger;
import sdsu.logging.LoggerCreationException;
import sdsu.logging.LoggerImplementation;
import sdsu.logging.LoggerMessage;
import sdsu.logging.SelectiveLogger;
import sdsu.logging.TimeStamp;
import sdsu.test.Assert;

public class FileLogger
extends SelectiveLogger {
    PrintWriter out;
    String logFileName;

    FileLogger(String string, boolean bl) throws LoggerCreationException {
        Assert.precondition(string != null && string.length() > 0);
        System.runFinalizersOnExit((boolean)true);
        if (!string.endsWith(".log")) {
            string = String.valueOf(string) + ".log";
        }
        this.logFileName = string;
        try {
            this.out = new PrintWriter(new BufferedWriter(new FileWriter(string, bl)));
        }
        catch (IOException iOException) {
            String string2 = "Trouble opening log file:" + string;
            throw new LoggerCreationException(string2);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.out.flush();
        this.out.close();
    }

    protected synchronized void processLogRequest(LoggerMessage loggerMessage) {
        this.out.println(String.valueOf(TimeStamp.now()) + loggerMessage.logString());
        this.out.flush();
    }

    public static LoggerImplementation register(String string) throws LoggerCreationException {
        if (!Logger.hasLogger()) {
            FileLogger fileLogger = new FileLogger(string, true);
            Logger.register(fileLogger);
        }
        return Logger.getLogger();
    }

    public static FileLogger register(String string, boolean bl) throws LoggerCreationException {
        FileLogger fileLogger = new FileLogger(string, bl);
        Logger.register(fileLogger);
        return fileLogger;
    }

    public synchronized void reset() {
        this.out.flush();
        this.out.close();
        try {
            this.out = new PrintWriter(new BufferedWriter(new FileWriter(this.logFileName, false)));
        }
        catch (IOException iOException) {
            this.out = new PrintWriter(System.err);
            this.out.println("Error in reseting file " + iOException.getMessage());
        }
    }
}

