/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.util.List;
import org.apache.spark.network.protocol.AbstractResponseMessage;
import org.apache.spark.network.protocol.Message;
import org.apache.spark.network.protocol.MessageWithHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public final class MessageEncoder
extends MessageToMessageEncoder<Message> {
    private static final Logger logger = LoggerFactory.getLogger(MessageEncoder.class);
    public static final MessageEncoder INSTANCE = new MessageEncoder();

    private MessageEncoder() {
    }

    public void encode(ChannelHandlerContext ctx, Message in, List<Object> out) throws Exception {
        Object body = null;
        long bodyLength = 0L;
        boolean isBodyInFrame = false;
        if (in.body() != null) {
            try {
                bodyLength = in.body().size();
                body = in.body().convertToNetty();
                isBodyInFrame = in.isBodyInFrame();
            }
            catch (Exception e) {
                in.body().release();
                if (!(in instanceof AbstractResponseMessage)) {
                    throw e;
                }
                AbstractResponseMessage resp = (AbstractResponseMessage)in;
                String error = e.getMessage() != null ? e.getMessage() : "null";
                logger.error(String.format("Error processing %s for client %s", in, ctx.channel().remoteAddress()), (Throwable)e);
                this.encode(ctx, resp.createFailureResponse(error), out);
                return;
            }
        }
        Message.Type msgType = in.type();
        int headerLength = 8 + msgType.encodedLength() + in.encodedLength();
        long frameLength = (long)headerLength + (isBodyInFrame ? bodyLength : 0L);
        ByteBuf header = ctx.alloc().heapBuffer(headerLength);
        header.writeLong(frameLength);
        msgType.encode(header);
        in.encode(header);
        assert (header.writableBytes() == 0);
        if (body != null) {
            out.add((Object)new MessageWithHeader(in.body(), header, body, bodyLength));
        } else {
            out.add(header);
        }
    }
}

