/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.yarn.ContainerLocalityPreferences;
import org.apache.spark.deploy.yarn.LocalityPreferredContainerPlacementStrategy$;
import org.apache.spark.deploy.yarn.SparkRackResolver;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Set;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005]c!B\u0001\u0003\u0001\ta!a\u000b'pG\u0006d\u0017\u000e^=Qe\u00164WM\u001d:fI\u000e{g\u000e^1j]\u0016\u0014\b\u000b\\1dK6,g\u000e^*ue\u0006$XmZ=\u000b\u0005\r!\u0011\u0001B=be:T!!\u0002\u0004\u0002\r\u0011,\u0007\u000f\\8z\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7C\u0001\u0001\u000e!\tq\u0011#D\u0001\u0010\u0015\u0005\u0001\u0012!B:dC2\f\u0017B\u0001\n\u0010\u0005\u0019\te.\u001f*fM\"AA\u0003\u0001BC\u0002\u0013\u0005a#A\u0005ta\u0006\u00148nQ8oM\u000e\u0001Q#A\f\u0011\u0005aIR\"\u0001\u0004\n\u0005i1!!C*qCJ\\7i\u001c8g\u0011!a\u0002A!A!\u0002\u00139\u0012AC:qCJ\\7i\u001c8gA!Aa\u0004\u0001BC\u0002\u0013\u0005q$\u0001\u0005zCJt7i\u001c8g+\u0005\u0001\u0003CA\u0011'\u001b\u0005\u0011#BA\u0012%\u0003\u0011\u0019wN\u001c4\u000b\u0005\u0015B\u0011A\u00025bI>|\u0007/\u0003\u0002(E\ti1i\u001c8gS\u001e,(/\u0019;j_:D\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006I\u0001I\u0001\ns\u0006\u0014hnQ8oM\u0002B\u0001b\u000b\u0001\u0003\u0006\u0004%\t\u0001L\u0001\te\u0016\u001cx.\u001e:dKV\tQ\u0006\u0005\u0002/i5\tqF\u0003\u00021c\u00059!/Z2pe\u0012\u001c(B\u0001\u001a4\u0003\r\t\u0007/\u001b\u0006\u0003\u0007\u0011J!!N\u0018\u0003\u0011I+7o\\;sG\u0016D\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I!L\u0001\ne\u0016\u001cx.\u001e:dK\u0002B\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IAO\u0001\te\u0016\u001cx\u000e\u001c<feB\u00111\bP\u0007\u0002\u0005%\u0011QH\u0001\u0002\u0012'B\f'o\u001b*bG.\u0014Vm]8mm\u0016\u0014\b\"B \u0001\t\u0003\u0001\u0015A\u0002\u001fj]&$h\bF\u0003B\u0005\u000e#U\t\u0005\u0002<\u0001!)AC\u0010a\u0001/!)aD\u0010a\u0001A!)1F\u0010a\u0001[!)\u0011H\u0010a\u0001u!)q\t\u0001C\u0001\u0011\u0006iBn\\2bY&$\u0018p\u00144SKF,Xm\u001d;fI\u000e{g\u000e^1j]\u0016\u00148\u000f\u0006\u0004J\u001fR3&M\u001d\t\u0004\u001d)c\u0015BA&\u0010\u0005\u0015\t%O]1z!\tYT*\u0003\u0002O\u0005\ta2i\u001c8uC&tWM\u001d'pG\u0006d\u0017\u000e^=Qe\u00164WM]3oG\u0016\u001c\b\"\u0002)G\u0001\u0004\t\u0016\u0001\u00048v[\u000e{g\u000e^1j]\u0016\u0014\bC\u0001\bS\u0013\t\u0019vBA\u0002J]RDQ!\u0016$A\u0002E\u000bQC\\;n\u0019>\u001c\u0017\r\\5us\u0006;\u0018M]3UCN\\7\u000fC\u0003X\r\u0002\u0007\u0001,\u0001\u000bi_N$Hk\u001c'pG\u0006dG+Y:l\u0007>,h\u000e\u001e\t\u00053r{\u0016K\u0004\u0002\u000f5&\u00111lD\u0001\u0007!J,G-\u001a4\n\u0005us&aA'ba*\u00111l\u0004\t\u00033\u0002L!!\u00190\u0003\rM#(/\u001b8h\u0011\u0015\u0019g\t1\u0001e\u0003q\tG\u000e\\8dCR,G\rS8tiR{7i\u001c8uC&tWM]:NCB\u0004B!\u001a6`Y6\taM\u0003\u0002hQ\u00069Q.\u001e;bE2,'BA5\u0010\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003W\u001a\u0014q\u0001S1tQ6\u000b\u0007\u000fE\u0002f[>L!A\u001c4\u0003\u0007M+G\u000f\u0005\u0002/a&\u0011\u0011o\f\u0002\f\u0007>tG/Y5oKJLE\rC\u0003t\r\u0002\u0007A/A\u0011m_\u000e\fG.\u001b;z\u001b\u0006$8\r[3e!\u0016tG-\u001b8h\u00032dwnY1uS>t7\u000f\u0005\u0003v{\u0006\u0005aB\u0001<|\u001d\t9(0D\u0001y\u0015\tIX#\u0001\u0004=e>|GOP\u0005\u0002!%\u0011ApD\u0001\ba\u0006\u001c7.Y4f\u0013\tqxPA\u0002TKFT!\u0001`\b\u0011\t\u0005\r\u0011q\u0005\b\u0005\u0003\u000b\t\tC\u0004\u0003\u0002\b\u0005ua\u0002BA\u0005\u00033qA!a\u0003\u0002\u00189!\u0011QBA\u000b\u001d\u0011\ty!a\u0005\u000f\u0007]\f\t\"C\u0001\f\u0013\tI!\"\u0003\u0002&\u0011%\u00111\u0001J\u0005\u0004\u00037\u0019\u0014AB2mS\u0016tG/C\u00023\u0003?Q1!a\u00074\u0013\u0011\t\u0019#!\n\u0002\u0015\u0005k%+T\"mS\u0016tGOC\u00023\u0003?IA!!\u000b\u0002,\t\u00012i\u001c8uC&tWM\u001d*fcV,7\u000f\u001e\u0006\u0005\u0003G\t)\u0003C\u0004\u00020\u0001!I!!\r\u0002'9,X.\u0012=fGV$xN]:QK:$\u0017N\\4\u0015\u0007E\u000b\u0019\u0004C\u0004\u00026\u00055\u0002\u0019A)\u0002\u001f9,X\u000eV1tWN\u0004VM\u001c3j]\u001eDq!!\u000f\u0001\t\u0013\tY$\u0001\u000ffqB,7\r^3e\u0011>\u001cH\u000fV8D_:$\u0018-\u001b8fe\u000e{WO\u001c;\u0015\u0013a\u000bi$!\u0011\u0002D\u0005\u0015\u0003bBA \u0003o\u0001\r!U\u0001\u0013Y>\u001c\u0017\r\\5us\u0006;\u0018M]3UCN\\7\u000f\u0003\u0004X\u0003o\u0001\r\u0001\u0017\u0005\u0007G\u0006]\u0002\u0019\u00013\t\rM\f9\u00041\u0001u\u0011\u001d\tI\u0005\u0001C\u0005\u0003\u0017\n1\u0004]3oI&tw\rS8tiR{7i\u001c8uC&tWM]\"pk:$H\u0003BA'\u0003+\u0002R!\u0017/`\u0003\u001f\u00022ADA)\u0013\r\t\u0019f\u0004\u0002\u0007\t>,(\r\\3\t\rM\f9\u00051\u0001u\u0001")
public class LocalityPreferredContainerPlacementStrategy {
    private final SparkConf sparkConf;
    private final Configuration yarnConf;
    private final Resource resource;
    public final SparkRackResolver org$apache$spark$deploy$yarn$LocalityPreferredContainerPlacementStrategy$$resolver;

    public SparkConf sparkConf() {
        return this.sparkConf;
    }

    public Configuration yarnConf() {
        return this.yarnConf;
    }

    public Resource resource() {
        return this.resource;
    }

    public ContainerLocalityPreferences[] localityOfRequestedContainers(int numContainer, int numLocalityAwareTasks, Map<String, Object> hostToLocalTaskCount, HashMap<String, Set<ContainerId>> allocatedHostToContainersMap, Seq<AMRMClient.ContainerRequest> localityMatchedPendingAllocations) {
        Map<String, Object> updatedHostToContainerCount = this.expectedHostToContainerCount(numLocalityAwareTasks, hostToLocalTaskCount, allocatedHostToContainersMap, localityMatchedPendingAllocations);
        int updatedLocalityAwareContainerNum = BoxesRunTime.unboxToInt((Object)updatedHostToContainerCount.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        int requiredLocalityFreeContainerNum = package$.MODULE$.max(0, numContainer - updatedLocalityAwareContainerNum);
        int requiredLocalityAwareContainerNum = numContainer - requiredLocalityFreeContainerNum;
        ArrayBuffer containerLocalityPreferences = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        if (requiredLocalityFreeContainerNum > 0) {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), requiredLocalityFreeContainerNum).foreach((Function1)new Serializable(this, containerLocalityPreferences){
                public static final long serialVersionUID = 0L;
                private final ArrayBuffer containerLocalityPreferences$1;

                public final ArrayBuffer<ContainerLocalityPreferences> apply(int i) {
                    return this.containerLocalityPreferences$1.$plus$eq((Object)new ContainerLocalityPreferences(null, null));
                }
                {
                    this.containerLocalityPreferences$1 = containerLocalityPreferences$1;
                }
            });
        }
        if (requiredLocalityAwareContainerNum > 0) {
            int largestRatio = BoxesRunTime.unboxToInt((Object)updatedHostToContainerCount.values().max((Ordering)Ordering.Int$.MODULE$));
            ObjectRef preferredLocalityRatio = ObjectRef.create((Object)((Map)updatedHostToContainerCount.map((Function1)new Serializable(this, requiredLocalityAwareContainerNum, largestRatio){
                public static final long serialVersionUID = 0L;
                private final int requiredLocalityAwareContainerNum$1;
                private final int largestRatio$1;

                public final Tuple2<String, Object> apply(Tuple2<String, Object> x0$1) {
                    Tuple2<String, Object> tuple2 = x0$1;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        int ratio = tuple2._2$mcI$sp();
                        double adjustedRatio = (double)ratio * (double)this.requiredLocalityAwareContainerNum$1 / (double)this.largestRatio$1;
                        Tuple2 tuple22 = new Tuple2((Object)k, (Object)BoxesRunTime.boxToInteger((int)((int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(adjustedRatio)))));
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.requiredLocalityAwareContainerNum$1 = requiredLocalityAwareContainerNum$1;
                    this.largestRatio$1 = largestRatio$1;
                }
            }, Map$.MODULE$.canBuildFrom())));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), requiredLocalityAwareContainerNum).foreach$mVc$sp((Function1)new Serializable(this, containerLocalityPreferences, preferredLocalityRatio){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LocalityPreferredContainerPlacementStrategy $outer;
                private final ArrayBuffer containerLocalityPreferences$1;
                private final ObjectRef preferredLocalityRatio$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    String[] hosts = (String[])((MapLike)((Map)this.preferredLocalityRatio$1.elem).filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Tuple2<String, Object> x$1) {
                            return x$1._2$mcI$sp() > 0;
                        }
                    })).keys().toArray(ClassTag$.MODULE$.apply(String.class));
                    scala.collection.immutable.Set racks = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])hosts).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$localityOfRequestedContainers$1 $outer;

                        public final String apply(String h) {
                            return this.$outer.org$apache$spark$deploy$yarn$LocalityPreferredContainerPlacementStrategy$$anonfun$$$outer().org$apache$spark$deploy$yarn$LocalityPreferredContainerPlacementStrategy$$resolver.resolve(this.$outer.org$apache$spark$deploy$yarn$LocalityPreferredContainerPlacementStrategy$$anonfun$$$outer().yarnConf(), h);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet();
                    this.containerLocalityPreferences$1.$plus$eq((Object)new ContainerLocalityPreferences(hosts, (String[])racks.toArray(ClassTag$.MODULE$.apply(String.class))));
                    this.preferredLocalityRatio$1.elem = (Map)((Map)this.preferredLocalityRatio$1.elem).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<String, Object> apply(Tuple2<String, Object> x0$2) {
                            Tuple2<String, Object> tuple2 = x0$2;
                            if (tuple2 != null) {
                                String k = (String)tuple2._1();
                                int v = tuple2._2$mcI$sp();
                                Tuple2 tuple22 = new Tuple2((Object)k, (Object)BoxesRunTime.boxToInteger((int)(v - 1)));
                                return tuple22;
                            }
                            throw new MatchError(tuple2);
                        }
                    }, Map$.MODULE$.canBuildFrom());
                }

                public /* synthetic */ LocalityPreferredContainerPlacementStrategy org$apache$spark$deploy$yarn$LocalityPreferredContainerPlacementStrategy$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.containerLocalityPreferences$1 = containerLocalityPreferences$1;
                    this.preferredLocalityRatio$1 = preferredLocalityRatio$1;
                }
            });
        }
        return (ContainerLocalityPreferences[])containerLocalityPreferences.toArray(ClassTag$.MODULE$.apply(ContainerLocalityPreferences.class));
    }

    public int org$apache$spark$deploy$yarn$LocalityPreferredContainerPlacementStrategy$$numExecutorsPending(int numTasksPending) {
        int coresPerExecutor = this.resource().getVirtualCores();
        return (numTasksPending * BoxesRunTime.unboxToInt((Object)this.sparkConf().get(org.apache.spark.internal.config.package$.MODULE$.CPUS_PER_TASK())) + coresPerExecutor - 1) / coresPerExecutor;
    }

    private Map<String, Object> expectedHostToContainerCount(int localityAwareTasks, Map<String, Object> hostToLocalTaskCount, HashMap<String, Set<ContainerId>> allocatedHostToContainersMap, Seq<AMRMClient.ContainerRequest> localityMatchedPendingAllocations) {
        int totalLocalTaskNum = BoxesRunTime.unboxToInt((Object)hostToLocalTaskCount.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Map<String, Object> pendingHostToContainersMap = this.pendingHostToContainerCount(localityMatchedPendingAllocations);
        return (Map)hostToLocalTaskCount.map((Function1)new Serializable(this, localityAwareTasks, allocatedHostToContainersMap, totalLocalTaskNum, pendingHostToContainersMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LocalityPreferredContainerPlacementStrategy $outer;
            private final int localityAwareTasks$1;
            private final HashMap allocatedHostToContainersMap$1;
            private final int totalLocalTaskNum$1;
            private final Map pendingHostToContainersMap$1;

            public final Tuple2<String, Object> apply(Tuple2<String, Object> x0$3) {
                Tuple2<String, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    String host = (String)tuple2._1();
                    int count = tuple2._2$mcI$sp();
                    double expectedCount = (double)count * (double)this.$outer.org$apache$spark$deploy$yarn$LocalityPreferredContainerPlacementStrategy$$numExecutorsPending(this.localityAwareTasks$1) / (double)this.totalLocalTaskNum$1;
                    double existedCount = (double)BoxesRunTime.unboxToInt((Object)this.allocatedHostToContainersMap$1.get((Object)host).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(Set<ContainerId> x$2) {
                            return x$2.size();
                        }
                    }).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply() {
                            return this.apply$mcI$sp();
                        }

                        public int apply$mcI$sp() {
                            return 0;
                        }
                    })) + BoxesRunTime.unboxToDouble((Object)this.pendingHostToContainersMap$1.getOrElse((Object)host, (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final double apply() {
                            return this.apply$mcD$sp();
                        }

                        public double apply$mcD$sp() {
                            return 0.0;
                        }
                    }));
                    Tuple2 tuple22 = new Tuple2((Object)host, (Object)BoxesRunTime.boxToInteger((int)package$.MODULE$.max(0, (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(expectedCount - existedCount)))));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.localityAwareTasks$1 = localityAwareTasks$1;
                this.allocatedHostToContainersMap$1 = allocatedHostToContainersMap$1;
                this.totalLocalTaskNum$1 = totalLocalTaskNum$1;
                this.pendingHostToContainersMap$1 = pendingHostToContainersMap$1;
            }
        }, Map$.MODULE$.canBuildFrom());
    }

    private Map<String, Object> pendingHostToContainerCount(Seq<AMRMClient.ContainerRequest> localityMatchedPendingAllocations) {
        HashMap pendingHostToContainerCount2 = new HashMap();
        localityMatchedPendingAllocations.foreach((Function1)new Serializable(this, pendingHostToContainerCount2){
            public static final long serialVersionUID = 0L;
            public final HashMap pendingHostToContainerCount$1;

            public final void apply(AMRMClient.ContainerRequest cr) {
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(cr.getNodes()).asScala()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$pendingHostToContainerCount$1 $outer;

                    public final void apply(String n) {
                        int count = BoxesRunTime.unboxToInt((Object)this.$outer.pendingHostToContainerCount$1.getOrElse((Object)n, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply() {
                                return this.apply$mcI$sp();
                            }

                            public int apply$mcI$sp() {
                                return 0;
                            }
                        })) + 1;
                        this.$outer.pendingHostToContainerCount$1.update((Object)n, (Object)BoxesRunTime.boxToInteger((int)count));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.pendingHostToContainerCount$1 = pendingHostToContainerCount$1;
            }
        });
        int possibleTotalContainerNum = BoxesRunTime.unboxToInt((Object)pendingHostToContainerCount2.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        double localityMatchedPendingNum = localityMatchedPendingAllocations.size();
        return ((TraversableOnce)pendingHostToContainerCount2.map((Function1)new Serializable(this, possibleTotalContainerNum, localityMatchedPendingNum){
            public static final long serialVersionUID = 0L;
            private final int possibleTotalContainerNum$1;
            private final double localityMatchedPendingNum$1;

            public final Tuple2<String, Object> apply(Tuple2<String, Object> x0$4) {
                Tuple2<String, Object> tuple2 = x0$4;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    int v = tuple2._2$mcI$sp();
                    Tuple2 tuple22 = new Tuple2((Object)k, (Object)BoxesRunTime.boxToDouble((double)((double)v * this.localityMatchedPendingNum$1 / (double)this.possibleTotalContainerNum$1)));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                this.possibleTotalContainerNum$1 = possibleTotalContainerNum$1;
                this.localityMatchedPendingNum$1 = localityMatchedPendingNum$1;
            }
        }, HashMap$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public LocalityPreferredContainerPlacementStrategy(SparkConf sparkConf, Configuration yarnConf, Resource resource, SparkRackResolver resolver) {
        this.sparkConf = sparkConf;
        this.yarnConf = yarnConf;
        this.resource = resource;
        this.org$apache$spark$deploy$yarn$LocalityPreferredContainerPlacementStrategy$$resolver = resolver;
    }
}

