/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.executor.TaskMetrics;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerJobEnd;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.scheduler.SparkListenerStageCompleted;

public class JobMetricsListener
extends SparkListener {
    private final Log LOG = LogFactory.getLog(JobMetricsListener.class);
    private Map<Integer, int[]> jobIdToStageId;
    private Map<Integer, Integer> stageIdToJobId;
    private Map<Integer, Map<String, List<TaskMetrics>>> allJobMetrics;
    private Set<Integer> finishedJobIds;

    JobMetricsListener(Map<Integer, int[]> jobIdToStageId, Map<Integer, Integer> stageIdToJobId, Map<Integer, Map<String, List<TaskMetrics>>> allJobMetrics, Set<Integer> finishedJobIds) {
        this.jobIdToStageId = jobIdToStageId;
        this.stageIdToJobId = stageIdToJobId;
        this.allJobMetrics = allJobMetrics;
        this.finishedJobIds = finishedJobIds;
    }

    public synchronized void onStageCompleted(SparkListenerStageCompleted stageCompleted) {
        int stageId = stageCompleted.stageInfo().stageId();
        int stageAttemptId = stageCompleted.stageInfo().attemptNumber();
        String stageIdentifier = stageId + "_" + stageAttemptId;
        Integer jobId = this.stageIdToJobId.get(stageId);
        if (jobId == null) {
            this.LOG.warn((Object)("Cannot find job id for stage[" + stageId + "]."));
        } else {
            List stageMetrics;
            HashMap jobMetrics = this.allJobMetrics.get(jobId);
            if (jobMetrics == null) {
                jobMetrics = Maps.newHashMap();
                this.allJobMetrics.put(jobId, jobMetrics);
            }
            if ((stageMetrics = (List)jobMetrics.get(stageIdentifier)) == null) {
                stageMetrics = Lists.newLinkedList();
                jobMetrics.put(stageIdentifier, stageMetrics);
            }
            stageMetrics.add(stageCompleted.stageInfo().taskMetrics());
        }
    }

    public synchronized void onJobStart(SparkListenerJobStart jobStart) {
        int jobId = jobStart.jobId();
        int size = jobStart.stageIds().size();
        int[] intStageIds = new int[size];
        for (int i = 0; i < size; ++i) {
            Integer stageId = (Integer)jobStart.stageIds().apply(i);
            intStageIds[i] = stageId;
            this.stageIdToJobId.put(stageId, jobId);
        }
        this.jobIdToStageId.put(jobId, intStageIds);
    }

    public synchronized void onJobEnd(SparkListenerJobEnd jobEnd) {
        this.finishedJobIds.add(jobEnd.jobId());
        ((Object)((Object)this)).notify();
    }
}

