/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.plan.operator;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.HDataType;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLocalRearrange;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.TezOutput;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.io.NullablePartitionWritable;
import org.apache.pig.impl.io.NullableTuple;
import org.apache.pig.impl.io.PigNullableWritable;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.library.api.KeyValueWriter;

public class POLocalRearrangeTez
extends POLocalRearrange
implements TezOutput {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(POLocalRearrangeTez.class);
    protected String outputKey;
    protected boolean connectedToPackage = true;
    protected boolean isSkewedJoin = false;
    protected transient KeyValueWriter writer;

    public POLocalRearrangeTez(OperatorKey k) {
        super(k);
    }

    public POLocalRearrangeTez(OperatorKey k, int rp) {
        super(k, rp);
    }

    public POLocalRearrangeTez(POLocalRearrange copy) {
        super(copy);
        if (copy instanceof POLocalRearrangeTez) {
            POLocalRearrangeTez copyTez = (POLocalRearrangeTez)copy;
            this.isSkewedJoin = copyTez.isSkewedJoin;
            this.connectedToPackage = copyTez.connectedToPackage;
            this.outputKey = copyTez.outputKey;
        }
    }

    public boolean containsOutputKey(String key) {
        return this.outputKey.equals(key);
    }

    public void setOutputKey(String outputKey) {
        this.outputKey = outputKey;
    }

    public boolean isConnectedToPackage() {
        return this.connectedToPackage;
    }

    public void setConnectedToPackage(boolean connectedToPackage) {
        this.connectedToPackage = connectedToPackage;
    }

    public boolean isSkewedJoin() {
        return this.isSkewedJoin;
    }

    public void setSkewedJoin(boolean isSkewedJoin) {
        this.isSkewedJoin = isSkewedJoin;
    }

    @Override
    public String[] getTezOutputs() {
        return new String[]{this.outputKey};
    }

    @Override
    public void replaceOutput(String oldOutputKey, String newOutputKey) {
        if (oldOutputKey.equals(this.outputKey)) {
            this.outputKey = newOutputKey;
        }
    }

    @Override
    public void attachOutputs(Map<String, LogicalOutput> outputs, Configuration conf) throws ExecException {
        LogicalOutput output = outputs.get(this.outputKey);
        if (output == null) {
            throw new ExecException("Output to vertex " + this.outputKey + " is missing");
        }
        try {
            this.writer = (KeyValueWriter)output.getWriter();
            LOG.info((Object)("Attached output to vertex " + this.outputKey + " : output=" + output + ", writer=" + this.writer));
        }
        catch (Exception e) {
            throw new ExecException(e);
        }
    }

    protected Result getRearrangedTuple() throws ExecException {
        return super.getNextTuple();
    }

    @Override
    public Result getNextTuple() throws ExecException {
        this.res = super.getNextTuple();
        if (this.writer == null) {
            return this.res;
        }
        try {
            switch (this.res.returnStatus) {
                case 0: {
                    if (this.illustrator == null) {
                        Tuple result = (Tuple)this.res.result;
                        Byte index = (Byte)result.get(0);
                        PigNullableWritable key = HDataType.getWritableComparableTypes(result.get(1), this.keyType);
                        NullableTuple val = new NullableTuple((Tuple)result.get(2));
                        key.setIndex(index);
                        val.setIndex(index);
                        if (this.isSkewedJoin) {
                            NullablePartitionWritable wrappedKey = new NullablePartitionWritable(key);
                            wrappedKey.setPartition(-1);
                            key = wrappedKey;
                        }
                        this.writer.write((Object)key, (Object)val);
                    } else {
                        this.illustratorMarkup(this.res.result, this.res.result, 0);
                    }
                    this.res = RESULT_EMPTY;
                    break;
                }
            }
        }
        catch (IOException ioe) {
            int errCode = 2135;
            String msg = "Received error from POLocalRearrage function." + ioe.getMessage();
            throw new ExecException(msg, errCode, ioe);
        }
        return this.inp;
    }

    @Override
    public POLocalRearrangeTez clone() throws CloneNotSupportedException {
        return (POLocalRearrangeTez)super.clone();
    }

    @Override
    public String name() {
        return super.name() + "\t->\t " + this.outputKey;
    }
}

