/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.pig.LoadPushDown;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigFileInputFormat;
import org.apache.pig.builtin.AvroStorage;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.impl.util.avro.AvroRecordWriter;
import org.apache.pig.impl.util.avro.AvroStorageDataConversionUtilities;
import org.apache.trevni.ColumnFileMetaData;
import org.apache.trevni.Input;
import org.apache.trevni.MetaData;
import org.apache.trevni.avro.AvroColumnReader;
import org.apache.trevni.avro.AvroColumnWriter;
import org.apache.trevni.avro.HadoopInput;

public class TrevniStorage
extends AvroStorage
implements LoadPushDown {
    public TrevniStorage() {
    }

    public TrevniStorage(String sn, String opts) {
        super(sn, opts);
    }

    @Override
    public InputFormat<NullWritable, GenericData.Record> getInputFormat() throws IOException {
        class TrevniStorageInputFormat
        extends PigFileInputFormat<NullWritable, GenericData.Record> {
            TrevniStorageInputFormat() {
            }

            protected boolean isSplitable(JobContext jc, Path p) {
                return false;
            }

            @Override
            protected List<FileStatus> listStatus(JobContext job) throws IOException {
                ArrayList results = Lists.newArrayList();
                job.getConfiguration().setBoolean("mapred.input.dir.recursive", true);
                for (FileStatus file : super.listStatus(job)) {
                    if (!Utils.VISIBLE_FILES.accept(file.getPath())) continue;
                    results.add(file);
                }
                return results;
            }

            public RecordReader<NullWritable, GenericData.Record> createRecordReader(InputSplit is, TaskAttemptContext tc) throws IOException, InterruptedException {
                RecordReader<NullWritable, GenericData.Record> rr = new RecordReader<NullWritable, GenericData.Record>(){
                    private FileSplit fsplit;
                    private AvroColumnReader.Params params;
                    private AvroColumnReader<GenericData.Record> reader;
                    private float rows;
                    private long row = 0L;
                    private GenericData.Record currentRecord = null;

                    public void close() throws IOException {
                        this.reader.close();
                    }

                    public NullWritable getCurrentKey() throws IOException, InterruptedException {
                        return NullWritable.get();
                    }

                    public GenericData.Record getCurrentValue() throws IOException, InterruptedException {
                        return this.currentRecord;
                    }

                    public float getProgress() throws IOException, InterruptedException {
                        return (float)this.row / this.rows;
                    }

                    public void initialize(InputSplit isplit, TaskAttemptContext tac) throws IOException, InterruptedException {
                        this.fsplit = (FileSplit)isplit;
                        this.params = new AvroColumnReader.Params((Input)new HadoopInput(this.fsplit.getPath(), tac.getConfiguration()));
                        Schema inputSchema = TrevniStorage.this.getInputAvroSchema();
                        this.params.setSchema(inputSchema);
                        this.reader = new AvroColumnReader(this.params);
                        this.rows = this.reader.getRowCount();
                    }

                    public boolean nextKeyValue() throws IOException, InterruptedException {
                        if (this.reader.hasNext()) {
                            this.currentRecord = (GenericData.Record)this.reader.next();
                            ++this.row;
                            return true;
                        }
                        return false;
                    }
                };
                tc.setStatus(is.toString());
                return rr;
            }
        }
        return new TrevniStorageInputFormat();
    }

    @Override
    public OutputFormat<NullWritable, Object> getOutputFormat() throws IOException {
        class TrevniStorageOutputFormat
        extends FileOutputFormat<NullWritable, Object> {
            private Schema schema;

            TrevniStorageOutputFormat(Schema s) {
                String schemaString;
                this.schema = s;
                if (s == null && (schemaString = TrevniStorage.this.getProperties(AvroStorage.class, TrevniStorage.this.udfContextSignature).getProperty("org.apache.pig.builtin.AvroStorage.output.schema")) != null) {
                    this.schema = new Schema.Parser().parse(schemaString);
                }
            }

            public RecordWriter<NullWritable, Object> getRecordWriter(final TaskAttemptContext tc) throws IOException, InterruptedException {
                if (this.schema == null) {
                    String schemaString = TrevniStorage.this.getProperties(AvroStorage.class, TrevniStorage.this.udfContextSignature).getProperty("org.apache.pig.builtin.AvroStorage.output.schema");
                    if (schemaString != null) {
                        this.schema = new Schema.Parser().parse(schemaString);
                    }
                    if (this.schema == null) {
                        throw new IOException("Null output schema");
                    }
                }
                final ColumnFileMetaData meta = new ColumnFileMetaData();
                for (Map.Entry e : tc.getConfiguration()) {
                    if (!((String)e.getKey()).startsWith("trevni.meta.")) continue;
                    meta.put((Object)((String)e.getKey()).substring("avro.meta.text.".length()), (Object)((String)e.getValue()).getBytes(MetaData.UTF8));
                }
                final Path dir = TrevniStorageOutputFormat.getOutputPath((JobContext)tc);
                final FileSystem fs = FileSystem.get((Configuration)tc.getConfiguration());
                final long blockSize = fs.getDefaultBlockSize();
                if (!fs.mkdirs(dir)) {
                    throw new IOException("Failed to create directory: " + dir);
                }
                meta.setCodec("deflate");
                return new AvroRecordWriter(dir, tc.getConfiguration()){
                    private int part;
                    private Schema avroRecordWriterSchema;
                    private AvroColumnWriter<GenericData.Record> writer;
                    {
                        super(o, c);
                        this.part = 0;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private void flush() throws IOException {
                        Integer taskAttemptId = tc.getTaskAttemptID().getTaskID().getId();
                        String partName = String.format("%05d_%03d", taskAttemptId, this.part++);
                        FSDataOutputStream out = fs.create(new Path(dir, "part-" + partName + ".trv"));
                        try {
                            this.writer.writeTo((OutputStream)out);
                        }
                        finally {
                            out.flush();
                            out.close();
                        }
                    }

                    @Override
                    public void close(TaskAttemptContext arg0) throws IOException, InterruptedException {
                        this.flush();
                    }

                    @Override
                    public void write(NullWritable n, Object o) throws IOException, InterruptedException {
                        GenericData.Record r = AvroStorageDataConversionUtilities.packIntoAvro((Tuple)o, schema);
                        this.writer.write((Object)r);
                        if (this.writer.sizeEstimate() >= blockSize) {
                            this.flush();
                            this.writer = new AvroColumnWriter(this.avroRecordWriterSchema, meta);
                        }
                    }

                    @Override
                    public void prepareToWrite(Schema s) throws IOException {
                        this.avroRecordWriterSchema = s;
                        this.writer = new AvroColumnWriter(this.avroRecordWriterSchema, meta);
                    }
                };
            }
        }
        return new TrevniStorageOutputFormat(this.schema);
    }

    @Override
    public Schema getAvroSchema(Path[] p, Job job) throws IOException {
        ArrayList<FileStatus> statusList = new ArrayList<FileStatus>();
        FileSystem fs = FileSystem.get((URI)p[0].toUri(), (Configuration)job.getConfiguration());
        for (Path temp : p) {
            for (FileStatus tempf : fs.globStatus(temp, Utils.VISIBLE_FILES)) {
                statusList.add(tempf);
            }
        }
        FileStatus[] statusArray = statusList.toArray(new FileStatus[statusList.size()]);
        if (statusArray == null) {
            throw new IOException("Path " + p.toString() + " does not exist.");
        }
        if (statusArray.length == 0) {
            throw new IOException("No path matches pattern " + p.toString());
        }
        Path filePath = Utils.depthFirstSearchForFile(statusArray, fs);
        if (filePath == null) {
            throw new IOException("No path matches pattern " + p.toString());
        }
        AvroColumnReader.Params params = new AvroColumnReader.Params((Input)new HadoopInput(filePath, job.getConfiguration()));
        AvroColumnReader reader = new AvroColumnReader(params);
        Schema s = reader.getFileSchema();
        reader.close();
        return s;
    }
}

