/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.builtin;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.pig.LoadCaster;
import org.apache.pig.LoadFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.util.Pair;

public abstract class SampleLoader
extends LoadFunc {
    protected int numSamples;
    protected LoadFunc loader;
    private RecordReader<?, ?> recordReader = null;

    public SampleLoader(String funcSpec) {
        funcSpec = funcSpec.replaceAll("\\\\'", "'");
        this.loader = (LoadFunc)PigContext.instantiateFuncFromSpec(funcSpec);
    }

    public void setNumSamples(int n) {
        this.numSamples = n;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public InputFormat<?, ?> getInputFormat() throws IOException {
        return this.loader.getInputFormat();
    }

    public boolean skipNext() throws IOException {
        try {
            return this.recordReader.nextKeyValue();
        }
        catch (InterruptedException e) {
            throw new IOException("Error getting input", e);
        }
    }

    public void computeSamples(ArrayList<Pair<FileSpec, Boolean>> inputs, PigContext pc) throws ExecException {
    }

    @Override
    public LoadCaster getLoadCaster() throws IOException {
        return this.loader.getLoadCaster();
    }

    @Override
    public String relativeToAbsolutePath(String location, Path curDir) throws IOException {
        return this.loader.relativeToAbsolutePath(location, curDir);
    }

    @Override
    public void prepareToRead(RecordReader reader, PigSplit split) throws IOException {
        this.loader.prepareToRead(reader, split);
        this.recordReader = reader;
    }

    @Override
    public void setLocation(String location, Job job) throws IOException {
        this.loader.setLocation(location, job);
    }

    @Override
    public void setUDFContextSignature(String signature) {
        this.loader.setUDFContextSignature(signature);
    }
}

