/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.util.Arrays;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.LdapGroupsMapping;
import org.apache.hadoop.security.TestLdapGroupsMappingBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestLdapGroupsMappingWithOneQuery
extends TestLdapGroupsMappingBase {
    @Before
    public void setupMocks() throws NamingException {
        Attribute groupDN = (Attribute)Mockito.mock(Attribute.class);
        NamingEnumeration<SearchResult> groupNames = this.getGroupNames();
        ((Attribute)Mockito.doReturn(groupNames).when((Object)groupDN)).getAll();
        String groupName1 = "CN=abc,DC=foo,DC=bar,DC=com";
        String groupName2 = "CN=xyz,DC=foo,DC=bar,DC=com";
        String groupName3 = "CN=sss,CN=foo,DC=bar,DC=com";
        ((NamingEnumeration)Mockito.doReturn((Object)groupName1).doReturn((Object)groupName2).doReturn((Object)groupName3).when(groupNames)).next();
        Mockito.when((Object)groupNames.hasMore()).thenReturn((Object)true).thenReturn((Object)true).thenReturn((Object)true).thenReturn((Object)false);
        Mockito.when((Object)this.getAttributes().get((String)Matchers.eq((Object)"memberOf"))).thenReturn((Object)groupDN);
    }

    @Test
    public void testGetGroups() throws NamingException {
        String[] testGroups = new String[]{"abc", "xyz", "sss"};
        this.doTestGetGroups(Arrays.asList(testGroups));
    }

    private void doTestGetGroups(List<String> expectedGroups) throws NamingException {
        String ldapUrl = "ldap://test";
        Configuration conf = this.getBaseConf(ldapUrl);
        conf.set("hadoop.security.group.mapping.ldap.search.attr.memberof", "memberOf");
        LdapGroupsMapping groupsMapping = this.getGroupsMapping();
        groupsMapping.setConf(conf);
        List groups = groupsMapping.getGroups("some_user");
        Assert.assertEquals(expectedGroups, (Object)groups);
        ((DirContext)Mockito.verify((Object)this.getContext(), (VerificationMode)Mockito.times((int)1))).search(Matchers.anyString(), Matchers.anyString(), (Object[])Matchers.any(Object[].class), (SearchControls)Matchers.any(SearchControls.class));
    }
}

