/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import io.netty.channel.unix.Errors;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.MathContext;
import java.math.RoundingMode;
import java.net.BindException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.util.Locale;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang3.SystemUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.log4j.Level;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.TaskContext$;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.security.GroupMappingServiceProvider;
import org.apache.spark.serializer.DeserializationStream;
import org.apache.spark.serializer.SerializationStream;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.status.api.v1.StackTrace;
import org.apache.spark.status.api.v1.ThreadStackTrace;
import org.apache.spark.util.CallSite;
import org.apache.spark.util.CallSite$;
import org.apache.spark.util.ShutdownHookManager$;
import org.apache.spark.util.SignalUtils$;
import org.apache.spark.util.SparkUncaughtExceptionHandler;
import org.apache.spark.util.SparkUncaughtExceptionHandler$;
import org.apache.spark.util.Utils;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.spark_project.guava.cache.CacheBuilder;
import org.spark_project.guava.cache.CacheLoader;
import org.spark_project.guava.cache.LoadingCache;
import org.spark_project.guava.hash.HashCodes;
import org.spark_project.guava.io.ByteStreams;
import org.spark_project.guava.io.Files;
import org.spark_project.guava.net.InetAddresses;
import org.spark_project.jetty.util.MultiException;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.TraitSetter;
import scala.util.Failure;
import scala.util.Random$;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.ControlThrowable;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class Utils$
implements Logging {
    public static final Utils$ MODULE$;
    private final Random random;
    private final SparkUncaughtExceptionHandler sparkUncaughtExceptionHandler;
    private volatile String cachedLocalDir;
    private final int DEFAULT_DRIVER_MEM_MB;
    private final int MAX_DIR_CREATION_ATTEMPTS;
    private volatile String[] localRootDirs;
    private final int DEFAULT_MAX_TO_STRING_FIELDS;
    private final AtomicBoolean truncationWarningPrinted;
    private InetAddress org$apache$spark$util$Utils$$localIpAddress;
    private Option<String> customHostname;
    private final ConcurrentHashMap<String, Tuple2<String, Object>> hostPortParseResults;
    private final Regex SPARK_CORE_CLASS_REGEX;
    private final Regex SPARK_SQL_CLASS_REGEX;
    private final String UNCOMPRESSED_LOG_FILE_LENGTH_CACHE_SIZE_CONF;
    private final int DEFAULT_UNCOMPRESSED_LOG_FILE_LENGTH_CACHE_SIZE;
    private LoadingCache<String, Long> compressedLogFileLengthCache;
    private final boolean isWindows;
    private final boolean isMac;
    private final Regex windowsDrive;
    private final Set<String> EMPTY_USER_GROUPS;
    private final String BACKUP_STANDALONE_MASTER_PREFIX;
    private final String REDACTION_REPLACEMENT_TEXT;
    private final Regex fullWidthRegex;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    static {
        new Utils$();
    }

    private InetAddress org$apache$spark$util$Utils$$localIpAddress$lzycompute() {
        Utils$ utils$ = this;
        synchronized (utils$) {
            if (!this.bitmap$0) {
                this.org$apache$spark$util$Utils$$localIpAddress = this.findLocalInetAddress();
                this.bitmap$0 = true;
            }
            return this.org$apache$spark$util$Utils$$localIpAddress;
        }
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging$class.initializeLogIfNecessary(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging$class.initializeLogIfNecessary$default$2(this);
    }

    public Random random() {
        return this.random;
    }

    private SparkUncaughtExceptionHandler sparkUncaughtExceptionHandler() {
        return this.sparkUncaughtExceptionHandler;
    }

    private String cachedLocalDir() {
        return this.cachedLocalDir;
    }

    private void cachedLocalDir_$eq(String x$1) {
        this.cachedLocalDir = x$1;
    }

    public int DEFAULT_DRIVER_MEM_MB() {
        return this.DEFAULT_DRIVER_MEM_MB;
    }

    private int MAX_DIR_CREATION_ATTEMPTS() {
        return this.MAX_DIR_CREATION_ATTEMPTS;
    }

    private String[] localRootDirs() {
        return this.localRootDirs;
    }

    private void localRootDirs_$eq(String[] x$1) {
        this.localRootDirs = x$1;
    }

    public int DEFAULT_MAX_TO_STRING_FIELDS() {
        return this.DEFAULT_MAX_TO_STRING_FIELDS;
    }

    public int maxNumToStringFields() {
        return SparkEnv$.MODULE$.get() == null ? this.DEFAULT_MAX_TO_STRING_FIELDS() : SparkEnv$.MODULE$.get().conf().getInt("spark.debug.maxToStringFields", this.DEFAULT_MAX_TO_STRING_FIELDS());
    }

    private AtomicBoolean truncationWarningPrinted() {
        return this.truncationWarningPrinted;
    }

    public <T> String truncatedString(Seq<T> seq, String start2, String sep, String end, int maxNumFields) {
        String string;
        if (seq.length() > maxNumFields) {
            if (this.truncationWarningPrinted().compareAndSet(false, true)) {
                this.logWarning((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Truncated the string representation of a plan since it was too large. This behavior can be adjusted by setting 'spark.debug.maxToStringFields' in SparkEnv.conf.";
                    }
                });
            }
            int numFields = package$.MODULE$.max(0, maxNumFields - 1);
            string = ((TraversableOnce)seq.take(numFields)).mkString(start2, sep, new StringBuilder().append((Object)sep).append((Object)"... ").append((Object)BoxesRunTime.boxToInteger((int)(seq.length() - numFields))).append((Object)" more fields").append((Object)end).toString());
        } else {
            string = seq.mkString(start2, sep, end);
        }
        return string;
    }

    public <T> String truncatedString(Seq<T> seq, String sep) {
        return this.truncatedString(seq, "", sep, "", this.truncatedString$default$5());
    }

    public <T> int truncatedString$default$5() {
        return this.maxNumToStringFields();
    }

    public <T> byte[] serialize(T o) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(o);
        oos.close();
        return bos.toByteArray();
    }

    public <T> T deserialize(byte[] bytes) {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = new ObjectInputStream(bis);
        return (T)ois.readObject();
    }

    public <T> T deserialize(byte[] bytes, ClassLoader loader) {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = new ObjectInputStream(loader, bis){
            private final ClassLoader loader$1;

            public Class<?> resolveClass(ObjectStreamClass desc) {
                return Class.forName(desc.getName(), false, this.loader$1);
            }
            {
                this.loader$1 = loader$1;
                super(bis$1);
            }
        };
        return (T)ois.readObject();
    }

    public long deserializeLongValue(byte[] bytes) {
        long result2 = (long)bytes[7] & 0xFFL;
        result2 += ((long)bytes[6] & 0xFFL) << 8;
        result2 += ((long)bytes[5] & 0xFFL) << 16;
        result2 += ((long)bytes[4] & 0xFFL) << 24;
        result2 += ((long)bytes[3] & 0xFFL) << 32;
        result2 += ((long)bytes[2] & 0xFFL) << 40;
        return (result2 += ((long)bytes[1] & 0xFFL) << 48) + (((long)bytes[0] & 0xFFL) << 56);
    }

    /*
     * WARNING - void declaration
     */
    public void serializeViaNestedStream(OutputStream os, SerializerInstance ser, Function1<SerializationStream, BoxedUnit> f) {
        SerializationStream osWrapper = ser.serializeStream(new OutputStream(os){
            private final OutputStream os$1;

            public void write(int b) {
                this.os$1.write(b);
            }

            public void write(byte[] b, int off, int len) {
                this.os$1.write(b, off, len);
            }
            {
                this.os$1 = os$1;
            }
        });
        try {
            f.apply((Object)osWrapper);
            osWrapper.close();
            return;
        }
        catch (Throwable throwable) {
            void var4_4;
            var4_4.close();
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void deserializeViaNestedStream(InputStream is, SerializerInstance ser, Function1<DeserializationStream, BoxedUnit> f) {
        DeserializationStream isWrapper = ser.deserializeStream(new InputStream(is){
            private final InputStream is$1;

            public int read() {
                return this.is$1.read();
            }

            public int read(byte[] b, int off, int len) {
                return this.is$1.read(b, off, len);
            }
            {
                this.is$1 = is$1;
            }
        });
        try {
            f.apply((Object)isWrapper);
            isWrapper.close();
            return;
        }
        catch (Throwable throwable) {
            void var4_4;
            var4_4.close();
            throw throwable;
        }
    }

    public ClassLoader getSparkClassLoader() {
        return this.getClass().getClassLoader();
    }

    public ClassLoader getContextOrSparkClassLoader() {
        return (ClassLoader)Option$.MODULE$.apply((Object)Thread.currentThread().getContextClassLoader()).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ClassLoader apply() {
                return Utils$.MODULE$.getSparkClassLoader();
            }
        });
    }

    public boolean classIsLoadable(String clazz) {
        return Try$.MODULE$.apply((Function0)new Serializable(clazz){
            public static final long serialVersionUID = 0L;
            private final String clazz$1;

            public final Class<Object> apply() {
                return Class.forName(this.clazz$1, false, Utils$.MODULE$.getContextOrSparkClassLoader());
            }
            {
                this.clazz$1 = clazz$1;
            }
        }).isSuccess();
    }

    public Class<?> classForName(String className) {
        return Class.forName(className, true, this.getContextOrSparkClassLoader());
    }

    /*
     * WARNING - void declaration
     */
    public <T> T withContextClassLoader(ClassLoader ctxClassLoader, Function0<T> fn2) {
        Object object;
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ctxClassLoader);
            object = fn2.apply();
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        catch (Throwable throwable) {
            void var3_3;
            Thread.currentThread().setContextClassLoader((ClassLoader)var3_3);
            throw throwable;
        }
        return (T)object;
    }

    public void writeByteBuffer(ByteBuffer bb, DataOutput out) {
        if (bb.hasArray()) {
            out.write(bb.array(), bb.arrayOffset() + bb.position(), bb.remaining());
        } else {
            int originalPosition = bb.position();
            byte[] bbval = new byte[bb.remaining()];
            bb.get(bbval);
            out.write(bbval);
            bb.position(originalPosition);
        }
    }

    public void writeByteBuffer(ByteBuffer bb, OutputStream out) {
        if (bb.hasArray()) {
            out.write(bb.array(), bb.arrayOffset() + bb.position(), bb.remaining());
        } else {
            int originalPosition = bb.position();
            byte[] bbval = new byte[bb.remaining()];
            bb.get(bbval);
            out.write(bbval);
            bb.position(originalPosition);
        }
    }

    public boolean chmod700(File file) {
        return file.setReadable(false, false) && file.setReadable(true, true) && file.setWritable(false, false) && file.setWritable(true, true) && file.setExecutable(false, false) && file.setExecutable(true, true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File createDirectory(String root, String namePrefix) {
        attempts = 0;
        maxAttempts = this.MAX_DIR_CREATION_ATTEMPTS();
        dir = null;
        while (true) {
            if (dir != null) {
                return dir.getCanonicalFile();
            }
            if (++attempts <= maxAttempts) ** GOTO lbl-1000
            throw new IOException(new StringBuilder().append((Object)"Failed to create a temp directory (under ").append((Object)root).append((Object)") after ").append((Object)BoxesRunTime.boxToInteger((int)maxAttempts)).append((Object)" attempts!").toString());
lbl-1000:
            // 1 sources

            {
                dir = new File(root, new StringBuilder().append((Object)namePrefix).append((Object)"-").append((Object)UUID.randomUUID().toString()).toString());
                if (!dir.exists() && dir.mkdirs()) continue;
                dir = null;
                continue;
            }
            break;
        }
    }

    public String createDirectory$default$2() {
        return "spark";
    }

    /*
     * WARNING - void declaration
     */
    public File createTempDir(String root, String namePrefix) {
        void var3_3;
        File dir = this.createDirectory(root, namePrefix);
        ShutdownHookManager$.MODULE$.registerShutdownDeleteDir(dir);
        return var3_3;
    }

    public String createTempDir$default$1() {
        return System.getProperty("java.io.tmpdir");
    }

    public String createTempDir$default$2() {
        return "spark";
    }

    public long copyStream(InputStream in, OutputStream out, boolean closeStreams, boolean transferToEnabled) {
        return BoxesRunTime.unboxToLong(this.tryWithSafeFinally((Function0)new Serializable(in, out, transferToEnabled){
            public static final long serialVersionUID = 0L;
            private final InputStream in$1;
            private final OutputStream out$1;
            private final boolean transferToEnabled$1;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            /*
             * WARNING - void declaration
             */
            public long apply$mcJ$sp() {
                long l;
                if (this.in$1 instanceof FileInputStream && this.out$1 instanceof FileOutputStream && this.transferToEnabled$1) {
                    void var3_3;
                    FileChannel inChannel = ((FileInputStream)this.in$1).getChannel();
                    FileChannel outChannel = ((FileOutputStream)this.out$1).getChannel();
                    long size = inChannel.size();
                    Utils$.MODULE$.copyFileStreamNIO(inChannel, outChannel, 0L, size);
                    l = var3_3;
                } else {
                    long count2 = 0L;
                    byte[] buf = new byte[8192];
                    int n = 0;
                    while (n != -1) {
                        n = this.in$1.read(buf);
                        if (n == -1) continue;
                        this.out$1.write(buf, 0, n);
                        count2 += (long)n;
                    }
                    l = count2;
                }
                return l;
            }
            {
                this.in$1 = in$1;
                this.out$1 = out$1;
                this.transferToEnabled$1 = transferToEnabled$1;
            }
        }, (Function0<BoxedUnit>)new Serializable(in, out, closeStreams){
            public static final long serialVersionUID = 0L;
            private final InputStream in$1;
            private final OutputStream out$1;
            private final boolean closeStreams$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                if (this.closeStreams$1) {
                    this.in$1.close();
                }
                return;
                finally {
                    this.out$1.close();
                }
            }
            {
                this.in$1 = in$1;
                this.out$1 = out$1;
                this.closeStreams$1 = closeStreams$1;
            }
        }));
    }

    public boolean copyStream$default$3() {
        return false;
    }

    public boolean copyStream$default$4() {
        return false;
    }

    public void copyFileStreamNIO(FileChannel input, FileChannel output, long startPosition, long bytesToCopy) {
        long initialPos = output.position();
        LongRef count2 = LongRef.create((long)0L);
        while (count2.elem < bytesToCopy) {
            count2.elem += input.transferTo(count2.elem + startPosition, bytesToCopy - count2.elem, output);
        }
        Predef$.MODULE$.assert(count2.elem == bytesToCopy, (Function0)new Serializable(bytesToCopy, count2){
            public static final long serialVersionUID = 0L;
            private final long bytesToCopy$1;
            private final LongRef count$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request to copy ", " bytes, but actually copied ", " bytes."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.bytesToCopy$1), BoxesRunTime.boxToLong((long)this.count$1.elem)}));
            }
            {
                this.bytesToCopy$1 = bytesToCopy$1;
                this.count$1 = count$1;
            }
        });
        long finalPos = output.position();
        long expectedPos = initialPos + bytesToCopy;
        Predef$.MODULE$.assert(finalPos == expectedPos, (Function0)new Serializable(finalPos, expectedPos){
            public static final long serialVersionUID = 0L;
            private final long finalPos$1;
            private final long expectedPos$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |Current position ", " do not equal to expected position ", "\n         |after transferTo, please check your kernel version to see if it is 2.6.32,\n         |this is a kernel bug which will lead to unexpected behavior when using transferTo.\n         |You can set spark.file.transferTo = false to disable this NIO feature.\n           "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.finalPos$1), BoxesRunTime.boxToLong((long)this.expectedPos$1)})))).stripMargin();
            }
            {
                this.finalPos$1 = finalPos$1;
                this.expectedPos$1 = expectedPos$1;
            }
        });
    }

    public URI constructURIForAuthentication(URI uri, SecurityManager securityMgr) {
        String userCred = securityMgr.getSecretKey();
        if (userCred == null) {
            throw new Exception("Secret key is null with authentication on");
        }
        String userInfo = new StringBuilder().append((Object)securityMgr.getHttpUser()).append((Object)":").append((Object)userCred).toString();
        return new URI(uri.getScheme(), userInfo, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
    }

    public String encodeFileNameToURIRawPath(String fileName) {
        Predef$.MODULE$.require(!fileName.contains("/") && !fileName.contains("\\"));
        return new URI("file", null, "localhost", -1, new StringBuilder().append((Object)"/").append((Object)fileName).toString(), null, null).getRawPath().substring(1);
    }

    public String decodeFileNameInURI(URI uri) {
        String rawPath = uri.getRawPath();
        String rawFileName = (String)Predef$.MODULE$.refArrayOps((Object[])rawPath.split("/")).last();
        return new URI(new StringBuilder().append((Object)"file:///").append((Object)rawFileName).toString()).getPath().substring(1);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public File fetchFile(String url, File targetDir, SparkConf conf, SecurityManager securityMgr, Configuration hadoopConf, long timestamp, boolean useCache) {
        Object object;
        File file;
        String fileName = this.decodeFileNameInURI(new URI(url));
        File targetFile = new File(targetDir, fileName);
        boolean fetchCacheEnabled = conf.getBoolean("spark.files.useFetchCache", true);
        if (useCache && fetchCacheEnabled) {
            BoxedUnit boxedUnit;
            String cachedFileName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", "_cache"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)url.hashCode()), BoxesRunTime.boxToLong((long)timestamp)}));
            String lockFileName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", "_lock"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)url.hashCode()), BoxesRunTime.boxToLong((long)timestamp)}));
            if (this.cachedLocalDir().isEmpty()) {
                Utils$ utils$ = this;
                synchronized (utils$) {
                    BoxedUnit boxedUnit2;
                    if (this.cachedLocalDir().isEmpty()) {
                        this.cachedLocalDir_$eq(this.getLocalDir(conf));
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit3 = boxedUnit2;
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 11, 13] lbl17 : MonitorExitStatement: MONITOREXIT : var14_13
                    boxedUnit = boxedUnit3;
                }
            }
            boxedUnit = BoxedUnit.UNIT;
            File localDir = new File(this.cachedLocalDir());
            File lockFile = new File(localDir, lockFileName);
            FileChannel lockFileChannel = new RandomAccessFile(lockFile, "rw").getChannel();
            FileLock lock = lockFileChannel.lock();
            File cachedFile = new File(localDir, cachedFileName);
            Object object2 = cachedFile.exists() ? BoxedUnit.UNIT : this.doFetchFile(url, localDir, cachedFileName, conf, securityMgr, hadoopConf);
            lock.release();
            lockFileChannel.close();
            this.copyFile(url, cachedFile, targetFile, conf.getBoolean("spark.files.overwrite", false), this.copyFile$default$5());
            file = BoxedUnit.UNIT;
        } else {
            file = this.doFetchFile(url, targetDir, fileName, conf, securityMgr, hadoopConf);
        }
        if (fileName.endsWith(".tar.gz") || fileName.endsWith(".tgz")) {
            this.logInfo((Function0<String>)new Serializable(fileName){
                public static final long serialVersionUID = 0L;
                private final String fileName$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Untarring ").append((Object)this.fileName$1).toString();
                }
                {
                    this.fileName$1 = fileName$1;
                }
            });
            object = this.executeAndGetOutput((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tar", "-xzf", fileName}))), targetDir, this.executeAndGetOutput$default$3(), this.executeAndGetOutput$default$4());
        } else if (fileName.endsWith(".tar")) {
            this.logInfo((Function0<String>)new Serializable(fileName){
                public static final long serialVersionUID = 0L;
                private final String fileName$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Untarring ").append((Object)this.fileName$1).toString();
                }
                {
                    this.fileName$1 = fileName$1;
                }
            });
            object = this.executeAndGetOutput((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tar", "-xf", fileName}))), targetDir, this.executeAndGetOutput$default$3(), this.executeAndGetOutput$default$4());
        } else {
            object = BoxedUnit.UNIT;
        }
        FileUtil.chmod((String)targetFile.getAbsolutePath(), (String)"a+x");
        Object object3 = this.isWindows() ? BoxesRunTime.boxToInteger((int)FileUtil.chmod((String)targetFile.getAbsolutePath(), (String)"u+r")) : BoxedUnit.UNIT;
        return targetFile;
        {
            catch (Throwable throwable) {
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            void var18_17;
            void var19_18;
            var19_18.release();
            var18_17.close();
            throw throwable;
        }
    }

    public <T> Tuple2<T, Object> timeTakenMs(Function0<T> body2) {
        long startTime = System.nanoTime();
        Object result2 = body2.apply();
        long endTime = System.nanoTime();
        return new Tuple2(result2, (Object)BoxesRunTime.boxToLong((long)package$.MODULE$.max(TimeUnit.NANOSECONDS.toMillis(endTime - startTime), 0L)));
    }

    private void downloadFile(String url, InputStream in, File destFile, boolean fileOverwrite) {
        File tempFile = File.createTempFile("fetchFileTemp", null, new File(destFile.getParentFile().getAbsolutePath()));
        this.logInfo((Function0<String>)new Serializable(url, tempFile){
            public static final long serialVersionUID = 0L;
            private final String url$2;
            private final File tempFile$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fetching ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.url$2, this.tempFile$1}));
            }
            {
                this.url$2 = url$2;
                this.tempFile$1 = tempFile$1;
            }
        });
        try {
            FileOutputStream out = new FileOutputStream(tempFile);
            this.copyStream(in, out, true, this.copyStream$default$4());
            this.copyFile(url, tempFile, destFile, fileOverwrite, true);
            return;
        }
        finally {
            if (tempFile.exists()) {
                tempFile.delete();
            }
        }
    }

    private void copyFile(String url, File sourceFile, File destFile, boolean fileOverwrite, boolean removeSourceFile) {
        if (destFile.exists()) {
            if (this.org$apache$spark$util$Utils$$filesEqualRecursive(sourceFile, destFile)) {
                this.logInfo((Function0<String>)new Serializable(sourceFile, destFile){
                    public static final long serialVersionUID = 0L;
                    private final File sourceFile$1;
                    private final File destFile$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("%s has been previously copied to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.sourceFile$1.getAbsolutePath(), this.destFile$1.getAbsolutePath()}));
                    }
                    {
                        this.sourceFile$1 = sourceFile$1;
                        this.destFile$1 = destFile$1;
                    }
                });
                return;
            }
            if (fileOverwrite) {
                this.logInfo((Function0<String>)new Serializable(url, destFile){
                    public static final long serialVersionUID = 0L;
                    private final String url$1;
                    private final File destFile$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"File ", " exists and does not match contents of ", ", replacing it with ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.destFile$1, this.url$1, this.url$1}));
                    }
                    {
                        this.url$1 = url$1;
                        this.destFile$1 = destFile$1;
                    }
                });
                if (!destFile.delete()) {
                    throw new SparkException(new StringOps(Predef$.MODULE$.augmentString("Failed to delete %s while attempting to overwrite it with %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{destFile.getAbsolutePath(), sourceFile.getAbsolutePath()})));
                }
            } else {
                throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"File ", " exists and does not match contents of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{destFile, url})));
            }
        }
        if (removeSourceFile) {
            java.nio.file.Files.move(sourceFile.toPath(), destFile.toPath(), new CopyOption[0]);
        } else {
            this.logInfo((Function0<String>)new Serializable(sourceFile, destFile){
                public static final long serialVersionUID = 0L;
                private final File sourceFile$1;
                private final File destFile$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Copying ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.sourceFile$1.getAbsolutePath(), this.destFile$1.getAbsolutePath()}));
                }
                {
                    this.sourceFile$1 = sourceFile$1;
                    this.destFile$1 = destFile$1;
                }
            });
            this.org$apache$spark$util$Utils$$copyRecursive(sourceFile, destFile);
        }
    }

    private boolean copyFile$default$5() {
        return false;
    }

    public boolean org$apache$spark$util$Utils$$filesEqualRecursive(File file1, File file2) {
        boolean bl;
        if (file1.isDirectory() && file2.isDirectory()) {
            File[] subfiles1 = file1.listFiles();
            File[] subfiles2 = file2.listFiles();
            if (Predef$.MODULE$.refArrayOps((Object[])subfiles1).size() != Predef$.MODULE$.refArrayOps((Object[])subfiles2).size()) {
                return false;
            }
            bl = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])subfiles1).sortBy((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(File x$1) {
                    return x$1.getName();
                }
            }, (Ordering)Ordering.String$.MODULE$)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])subfiles2).sortBy((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(File x$2) {
                    return x$2.getName();
                }
            }, (Ordering)Ordering.String$.MODULE$)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).forall((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<File, File> x0$1) {
                    Tuple2<File, File> tuple2 = x0$1;
                    if (tuple2 != null) {
                        File f1 = (File)tuple2._1();
                        File f2 = (File)tuple2._2();
                        boolean bl = Utils$.MODULE$.org$apache$spark$util$Utils$$filesEqualRecursive(f1, f2);
                        return bl;
                    }
                    throw new MatchError(tuple2);
                }
            });
        } else {
            bl = file1.isFile() && file2.isFile() ? Files.equal((File)file1, (File)file2) : false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void org$apache$spark$util$Utils$$copyRecursive(File source, File dest) {
        if (source.isDirectory()) {
            if (!dest.mkdir()) throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to create directory ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dest.getPath()})));
            File[] subfiles = source.listFiles();
            Predef$.MODULE$.refArrayOps((Object[])subfiles).foreach((Function1)new Serializable(dest){
                public static final long serialVersionUID = 0L;
                private final File dest$1;

                public final void apply(File f) {
                    Utils$.MODULE$.org$apache$spark$util$Utils$$copyRecursive(f, new File(this.dest$1, f.getName()));
                }
                {
                    this.dest$1 = dest$1;
                }
            });
            return;
        } else {
            java.nio.file.Files.copy(source.toPath(), dest.toPath(), new CopyOption[0]);
        }
    }

    public File doFetchFile(String url, File targetDir, String filename, SparkConf conf, SecurityManager securityMgr, Configuration hadoopConf) {
        File targetFile = new File(targetDir, filename);
        URI uri = new URI(url);
        boolean fileOverwrite = conf.getBoolean("spark.files.overwrite", false);
        String string = (String)Option$.MODULE$.apply((Object)uri.getScheme()).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "file";
            }
        });
        if ("spark".equals(string)) {
            if (SparkEnv$.MODULE$.get() == null) {
                throw new IllegalStateException("Cannot retrieve files with 'spark' scheme without an active SparkEnv.");
            }
            ReadableByteChannel source = SparkEnv$.MODULE$.get().rpcEnv().openChannel(url);
            InputStream is = Channels.newInputStream(source);
            this.downloadFile(url, is, targetFile, fileOverwrite);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            boolean bl = "http".equals(string) ? true : ("https".equals(string) ? true : "ftp".equals(string));
            if (bl) {
                URLConnection uc = null;
                if (securityMgr.isAuthenticationEnabled()) {
                    this.logDebug((Function0<String>)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "fetchFile with security enabled";
                        }
                    });
                    URI newuri = this.constructURIForAuthentication(uri, securityMgr);
                    uc = newuri.toURL().openConnection();
                    uc.setAllowUserInteraction(false);
                } else {
                    this.logDebug((Function0<String>)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "fetchFile not using security";
                        }
                    });
                    uc = new URL(url).openConnection();
                }
                int timeoutMs = (int)conf.getTimeAsSeconds("spark.files.fetchTimeout", "60s") * 1000;
                uc.setConnectTimeout(timeoutMs);
                uc.setReadTimeout(timeoutMs);
                uc.connect();
                InputStream in = uc.getInputStream();
                this.downloadFile(url, in, targetFile, fileOverwrite);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if ("file".equals(string)) {
                File sourceFile = uri.isAbsolute() ? new File(uri) : new File(url);
                this.copyFile(url, sourceFile, targetFile, fileOverwrite, this.copyFile$default$5());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                FileSystem fs = this.getHadoopFileSystem(uri, hadoopConf);
                Path path = new Path(uri);
                this.fetchHcfsFile(path, targetDir, fs, conf, hadoopConf, fileOverwrite, (Option<String>)new Some((Object)filename));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        return targetFile;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void fetchHcfsFile(Path path, File targetDir, FileSystem fs, SparkConf conf, Configuration hadoopConf, boolean fileOverwrite, Option<String> filename) {
        if (!targetDir.exists() && !targetDir.mkdir()) {
            throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to create directory ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetDir.getPath()})));
        }
        File dest = new File(targetDir, (String)filename.getOrElse((Function0)new Serializable(path){
            public static final long serialVersionUID = 0L;
            private final Path path$1;

            public final String apply() {
                return this.path$1.getName();
            }
            {
                this.path$1 = path$1;
            }
        }));
        if (!fs.isFile(path)) {
            Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(path)).foreach((Function1)new Serializable(fs, conf, hadoopConf, fileOverwrite, dest){
                public static final long serialVersionUID = 0L;
                private final FileSystem fs$1;
                private final SparkConf conf$3;
                private final Configuration hadoopConf$1;
                private final boolean fileOverwrite$1;
                private final File dest$2;

                public final void apply(FileStatus fileStatus) {
                    Utils$.MODULE$.fetchHcfsFile(fileStatus.getPath(), this.dest$2, this.fs$1, this.conf$3, this.hadoopConf$1, this.fileOverwrite$1, Utils$.MODULE$.fetchHcfsFile$default$7());
                }
                {
                    this.fs$1 = fs$1;
                    this.conf$3 = conf$3;
                    this.hadoopConf$1 = hadoopConf$1;
                    this.fileOverwrite$1 = fileOverwrite$1;
                    this.dest$2 = dest$2;
                }
            });
            return;
        }
        FSDataInputStream in = fs.open(path);
        try {
            this.downloadFile(path.toString(), (InputStream)in, dest, fileOverwrite);
        }
        catch (Throwable throwable) {
            void var9_9;
            var9_9.close();
            throw throwable;
        }
        in.close();
    }

    public Option<String> fetchHcfsFile$default$7() {
        return None$.MODULE$;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void validateURL(URI uri) throws MalformedURLException {
        String string = (String)Option$.MODULE$.apply((Object)uri.getScheme()).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "file";
            }
        });
        boolean bl = "http".equals(string) ? true : ("https".equals(string) ? true : "ftp".equals(string));
        if (!bl) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        try {
            uri.toURL();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        catch (MalformedURLException malformedURLException) {
            MalformedURLException ex = new MalformedURLException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"URI (", ") is not a valid URL."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri.toString()})));
            ex.initCause(malformedURLException);
            throw ex;
        }
    }

    public String getLocalDir(SparkConf conf) {
        String[] localRootDirs = this.getOrCreateLocalRootDirs(conf);
        if (Predef$.MODULE$.refArrayOps((Object[])localRootDirs).isEmpty()) {
            String[] configuredLocalDirs = this.getConfiguredLocalDirs(conf);
            throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to get a temp directory under [", "]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])configuredLocalDirs).mkString(",")})));
        }
        return localRootDirs[Random$.MODULE$.nextInt(localRootDirs.length)];
    }

    public boolean isRunningInYarnContainer(SparkConf conf) {
        return conf.getenv("CONTAINER_ID") != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getOrCreateLocalRootDirs(SparkConf conf) {
        BoxedUnit boxedUnit;
        if (this.localRootDirs() != null) {
            boxedUnit = BoxedUnit.UNIT;
            return this.localRootDirs();
        }
        Utils$ utils$ = this;
        synchronized (utils$) {
            BoxedUnit boxedUnit2;
            if (this.localRootDirs() == null) {
                this.localRootDirs_$eq(this.getOrCreateLocalRootDirsImpl(conf));
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit2;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl13 : MonitorExitStatement: MONITOREXIT : utils$
            boxedUnit = boxedUnit3;
            return this.localRootDirs();
        }
    }

    public String[] getConfiguredLocalDirs(SparkConf conf) {
        String[] stringArray;
        boolean shuffleServiceEnabled = BoxesRunTime.unboxToBoolean((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.SHUFFLE_SERVICE_ENABLED()));
        if (this.isRunningInYarnContainer(conf)) {
            stringArray = (String[])this.randomizeInPlace(this.getYarnLocalDirs(conf).split(","), this.randomizeInPlace$default$2());
        } else if (conf.getenv("SPARK_EXECUTOR_DIRS") == null) {
            if (conf.getenv("SPARK_LOCAL_DIRS") == null) {
                if (conf.getenv("MESOS_SANDBOX") == null || shuffleServiceEnabled) {
                    if (conf.getenv("MESOS_SANDBOX") != null && shuffleServiceEnabled) {
                        this.logInfo((Function0<String>)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "MESOS_SANDBOX available but not using provided Mesos sandbox because spark.shuffle.service.enabled is enabled.";
                            }
                        });
                    }
                    stringArray = conf.get("spark.local.dir", System.getProperty("java.io.tmpdir")).split(",");
                } else {
                    stringArray = (String[])((Object[])new String[]{conf.getenv("MESOS_SANDBOX")});
                }
            } else {
                stringArray = conf.getenv("SPARK_LOCAL_DIRS").split(",");
            }
        } else {
            stringArray = conf.getenv("SPARK_EXECUTOR_DIRS").split(File.pathSeparator);
        }
        return stringArray;
    }

    private String[] getOrCreateLocalRootDirsImpl(SparkConf conf) {
        String[] configuredLocalDirs = this.getConfiguredLocalDirs(conf);
        String[] uris = (String[])Predef$.MODULE$.refArrayOps((Object[])configuredLocalDirs).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String root) {
                return BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)new Serializable(this, root){
                    public static final long serialVersionUID = 0L;
                    private final String root$1;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return new URI(this.root$1).getScheme() != null;
                    }
                    {
                        this.root$1 = root$1;
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return false;
                    }
                }));
            }
        });
        if (Predef$.MODULE$.refArrayOps((Object[])uris).nonEmpty()) {
            this.logWarning((Function0<String>)new Serializable(uris){
                public static final long serialVersionUID = 0L;
                private final String[] uris$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"The configured local directories are not expected to be URIs; however, got suspicious ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"values [", "]. Please check your configured local directories."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])this.uris$1).mkString(", ")}))).toString();
                }
                {
                    this.uris$1 = uris$1;
                }
            });
        }
        return (String[])Predef$.MODULE$.refArrayOps((Object[])configuredLocalDirs).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterable<String> apply(String root) {
                Iterable iterable;
                try {
                    File rootDir = new File(root);
                    if (rootDir.exists() || rootDir.mkdirs()) {
                        File dir = Utils$.MODULE$.createTempDir(root, Utils$.MODULE$.createTempDir$default$2());
                        Utils$.MODULE$.chmod700(dir);
                        iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)dir.getAbsolutePath()));
                    } else {
                        Utils$.MODULE$.logError((Function0<String>)new Serializable(this, root){
                            public static final long serialVersionUID = 0L;
                            private final String root$2;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to create dir in ", ". Ignoring this directory."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.root$2}));
                            }
                            {
                                this.root$2 = root$2;
                            }
                        });
                        iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    }
                }
                catch (IOException iOException) {
                    Utils$.MODULE$.logError((Function0<String>)new Serializable(this, root){
                        public static final long serialVersionUID = 0L;
                        private final String root$2;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to create local root dir in ", ". Ignoring this directory."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.root$2}));
                        }
                        {
                            this.root$2 = root$2;
                        }
                    });
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                return iterable;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
    }

    /*
     * WARNING - void declaration
     */
    private String getYarnLocalDirs(SparkConf conf) {
        void var2_2;
        String localDirs = (String)Option$.MODULE$.apply((Object)conf.getenv("LOCAL_DIRS")).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        if (localDirs.isEmpty()) {
            throw new Exception("Yarn Local dirs can't be empty");
        }
        return var2_2;
    }

    public void clearLocalRootDirs() {
        this.localRootDirs_$eq(null);
    }

    public <T> Seq<T> randomize(TraversableOnce<T> seq, ClassTag<T> evidence$1) {
        return Predef$.MODULE$.genericWrapArray(this.randomizeInPlace(seq.toArray(evidence$1), this.randomizeInPlace$default$2()));
    }

    public <T> Object randomizeInPlace(Object arr, Random rand) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(ScalaRunTime$.MODULE$.array_length(arr) - 1), 1).by(-1).foreach$mVc$sp((Function1)new Serializable(arr, rand){
            public static final long serialVersionUID = 0L;
            private final Object arr$1;
            private final Random rand$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                int j = this.rand$1.nextInt(i + 1);
                Object tmp = ScalaRunTime$.MODULE$.array_apply(this.arr$1, j);
                ScalaRunTime$.MODULE$.array_update(this.arr$1, j, ScalaRunTime$.MODULE$.array_apply(this.arr$1, i));
                ScalaRunTime$.MODULE$.array_update(this.arr$1, i, tmp);
            }
            {
                this.arr$1 = arr$1;
                this.rand$1 = rand$1;
            }
        });
        return arr;
    }

    public <T> Random randomizeInPlace$default$2() {
        return new Random();
    }

    public InetAddress org$apache$spark$util$Utils$$localIpAddress() {
        return this.bitmap$0 ? this.org$apache$spark$util$Utils$$localIpAddress : this.org$apache$spark$util$Utils$$localIpAddress$lzycompute();
    }

    private InetAddress findLocalInetAddress() {
        NonLocalReturnControl nonLocalReturnControl2;
        block5: {
            InetAddress inetAddress;
            Object object = new Object();
            try {
                String defaultIpOverride = System.getenv("SPARK_LOCAL_IP");
                if (defaultIpOverride == null) {
                    InetAddress address = InetAddress.getLocalHost();
                    if (address.isLoopbackAddress()) {
                        Seq activeNetworkIFs = ((TraversableOnce)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(NetworkInterface.getNetworkInterfaces()).asScala()).toSeq();
                        Seq reOrderedNetworkIFs = this.isWindows() ? activeNetworkIFs : (Seq)activeNetworkIFs.reverse();
                        reOrderedNetworkIFs.foreach((Function1)new Serializable(address, object){
                            public static final long serialVersionUID = 0L;
                            public final InetAddress address$1;
                            private final Object nonLocalReturnKey1$1;

                            public final void apply(NetworkInterface ni) {
                                Seq addresses = ((Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(ni.getInetAddresses()).asScala()).filterNot((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final boolean apply(InetAddress addr) {
                                        return addr.isLinkLocalAddress() || addr.isLoopbackAddress();
                                    }
                                }).toSeq();
                                if (addresses.nonEmpty()) {
                                    InetAddress addr = (InetAddress)addresses.find((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final boolean apply(InetAddress x$3) {
                                            return x$3 instanceof Inet4Address;
                                        }
                                    }).getOrElse((Function0)new Serializable(this, addresses){
                                        public static final long serialVersionUID = 0L;
                                        private final Seq addresses$1;

                                        public final InetAddress apply() {
                                            return (InetAddress)this.addresses$1.head();
                                        }
                                        {
                                            this.addresses$1 = addresses$1;
                                        }
                                    });
                                    InetAddress strippedAddress = InetAddress.getByAddress(addr.getAddress());
                                    Utils$.MODULE$.logWarning((Function0<String>)new Serializable(this, strippedAddress, ni){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ anonfun.findLocalInetAddress.1 $outer;
                                        private final InetAddress strippedAddress$1;
                                        private final NetworkInterface ni$1;

                                        public final String apply() {
                                            return new StringBuilder().append((Object)"Your hostname, ").append((Object)InetAddress.getLocalHost().getHostName()).append((Object)" resolves to").append((Object)" a loopback address: ").append((Object)this.$outer.address$1.getHostAddress()).append((Object)"; using ").append((Object)this.strippedAddress$1.getHostAddress()).append((Object)" instead (on interface ").append((Object)this.ni$1.getName()).append((Object)")").toString();
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.strippedAddress$1 = strippedAddress$1;
                                            this.ni$1 = ni$1;
                                        }
                                    });
                                    Utils$.MODULE$.logWarning((Function0<String>)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "Set SPARK_LOCAL_IP if you need to bind to another address";
                                        }
                                    });
                                    throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)strippedAddress);
                                }
                            }
                            {
                                this.address$1 = address$1;
                                this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                            }
                        });
                        this.logWarning((Function0<String>)new Serializable(address){
                            public static final long serialVersionUID = 0L;
                            private final InetAddress address$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Your hostname, ").append((Object)InetAddress.getLocalHost().getHostName()).append((Object)" resolves to").append((Object)" a loopback address: ").append((Object)this.address$1.getHostAddress()).append((Object)", but we couldn't find any").append((Object)" external IP address!").toString();
                            }
                            {
                                this.address$1 = address$1;
                            }
                        });
                        this.logWarning((Function0<String>)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Set SPARK_LOCAL_IP if you need to bind to another address";
                            }
                        });
                    }
                    inetAddress = address;
                } else {
                    inetAddress = InetAddress.getByName(defaultIpOverride);
                }
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block5;
                inetAddress = (InetAddress)nonLocalReturnControl2.value();
            }
            return inetAddress;
        }
        throw nonLocalReturnControl2;
    }

    private Option<String> customHostname() {
        return this.customHostname;
    }

    private void customHostname_$eq(Option<String> x$1) {
        this.customHostname = x$1;
    }

    public void setCustomHostname(String hostname) {
        this.checkHost(hostname);
        this.customHostname_$eq((Option<String>)new Some((Object)hostname));
    }

    public String localCanonicalHostName() {
        return (String)this.customHostname().getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return Utils$.MODULE$.org$apache$spark$util$Utils$$localIpAddress().getCanonicalHostName();
            }
        });
    }

    public String localHostName() {
        return (String)this.customHostname().getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return Utils$.MODULE$.org$apache$spark$util$Utils$$localIpAddress().getHostAddress();
            }
        });
    }

    public String localHostNameForURI() {
        return (String)this.customHostname().getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return InetAddresses.toUriString((InetAddress)Utils$.MODULE$.org$apache$spark$util$Utils$$localIpAddress());
            }
        });
    }

    public void checkHost(String host) {
        Predef$.MODULE$.assert(host != null && host.indexOf(58) == -1, (Function0)new Serializable(host){
            public static final long serialVersionUID = 0L;
            private final String host$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected hostname (not IP) but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.host$1}));
            }
            {
                this.host$1 = host$1;
            }
        });
    }

    public void checkHostPort(String hostPort) {
        Predef$.MODULE$.assert(hostPort != null && hostPort.indexOf(58) != -1, (Function0)new Serializable(hostPort){
            public static final long serialVersionUID = 0L;
            private final String hostPort$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected host and port but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hostPort$1}));
            }
            {
                this.hostPort$1 = hostPort$1;
            }
        });
    }

    private ConcurrentHashMap<String, Tuple2<String, Object>> hostPortParseResults() {
        return this.hostPortParseResults;
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<String, Object> parseHostPort(String hostPort) {
        void var2_2;
        Tuple2<String, Object> cached = this.hostPortParseResults().get(hostPort);
        if (cached == null) {
            int indx = hostPort.lastIndexOf(58);
            if (-1 == indx) {
                Tuple2 retval = new Tuple2((Object)hostPort, (Object)BoxesRunTime.boxToInteger((int)0));
                this.hostPortParseResults().put(hostPort, (Tuple2<String, Object>)retval);
                return retval;
            }
            Tuple2 retval = new Tuple2((Object)hostPort.substring(0, indx).trim(), (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(hostPort.substring(indx + 1).trim())).toInt()));
            this.hostPortParseResults().putIfAbsent(hostPort, (Tuple2<String, Object>)retval);
            return this.hostPortParseResults().get(hostPort);
        }
        return var2_2;
    }

    public String getUsedTimeMs(long startTimeMs) {
        return new StringBuilder().append((Object)" ").append((Object)BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - startTimeMs))).append((Object)" ms").toString();
    }

    public void deleteRecursively(File file) {
        if (file != null) {
            JavaUtils.deleteRecursively((File)file);
            ShutdownHookManager$.MODULE$.removeShutdownDeleteDir(file);
        }
    }

    public boolean doesDirectoryContainAnyNewFiles(File dir, long cutoff) {
        if (dir.isDirectory()) {
            File[] filesAndDirs = dir.listFiles();
            long cutoffTimeInMillis = System.currentTimeMillis() - cutoff * 1000L;
            return Predef$.MODULE$.refArrayOps((Object[])filesAndDirs).exists((Function1)new Serializable(cutoffTimeInMillis){
                public static final long serialVersionUID = 0L;
                private final long cutoffTimeInMillis$1;

                public final boolean apply(File x$4) {
                    return x$4.lastModified() > this.cutoffTimeInMillis$1;
                }
                {
                    this.cutoffTimeInMillis$1 = cutoffTimeInMillis$1;
                }
            }) || Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])filesAndDirs).filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(File x$5) {
                    return x$5.isDirectory();
                }
            })).exists((Function1)new Serializable(cutoff){
                public static final long serialVersionUID = 0L;
                private final long cutoff$1;

                public final boolean apply(File subdir) {
                    return Utils$.MODULE$.doesDirectoryContainAnyNewFiles(subdir, this.cutoff$1);
                }
                {
                    this.cutoff$1 = cutoff$1;
                }
            });
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not a directory!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dir})));
    }

    public long timeStringAsMs(String str) {
        return JavaUtils.timeStringAsMs((String)str);
    }

    public long timeStringAsSeconds(String str) {
        return JavaUtils.timeStringAsSec((String)str);
    }

    public long byteStringAsBytes(String str) {
        return JavaUtils.byteStringAsBytes((String)str);
    }

    public long byteStringAsKb(String str) {
        return JavaUtils.byteStringAsKb((String)str);
    }

    public long byteStringAsMb(String str) {
        return JavaUtils.byteStringAsMb((String)str);
    }

    public long byteStringAsGb(String str) {
        return JavaUtils.byteStringAsGb((String)str);
    }

    public int memoryStringToMb(String str) {
        return (int)(JavaUtils.byteStringAsBytes((String)str) / 1024L / 1024L);
    }

    public String bytesToString(long size) {
        return this.bytesToString(scala.package$.MODULE$.BigInt().apply(size));
    }

    public String bytesToString(BigInt size) {
        Tuple2 tuple2;
        block4: {
            String string;
            block3: {
                Tuple2 tuple22;
                long KB;
                long MB;
                long GB;
                long TB;
                long PB;
                long EB;
                block2: {
                    EB = 0x1000000000000000L;
                    PB = 0x4000000000000L;
                    TB = 0x10000000000L;
                    GB = 0x40000000L;
                    MB = 0x100000L;
                    KB = 1024L;
                    if (!size.$greater$eq(scala.package$.MODULE$.BigInt().apply(2048L).$times(BigInt$.MODULE$.long2bigInt(EB)))) break block2;
                    string = new StringBuilder().append((Object)scala.package$.MODULE$.BigDecimal().apply(size, new MathContext(3, RoundingMode.HALF_UP)).toString()).append((Object)" B").toString();
                    break block3;
                }
                Tuple2 tuple23 = size.$greater$eq(BigInt$.MODULE$.long2bigInt(2L * EB)) ? new Tuple2((Object)scala.package$.MODULE$.BigDecimal().apply(size).$div(BigDecimal$.MODULE$.long2bigDecimal(EB)), (Object)"EB") : (size.$greater$eq(BigInt$.MODULE$.long2bigInt(2L * PB)) ? new Tuple2((Object)scala.package$.MODULE$.BigDecimal().apply(size).$div(BigDecimal$.MODULE$.long2bigDecimal(PB)), (Object)"PB") : (size.$greater$eq(BigInt$.MODULE$.long2bigInt(2L * TB)) ? new Tuple2((Object)scala.package$.MODULE$.BigDecimal().apply(size).$div(BigDecimal$.MODULE$.long2bigDecimal(TB)), (Object)"TB") : (size.$greater$eq(BigInt$.MODULE$.long2bigInt(2L * GB)) ? new Tuple2((Object)scala.package$.MODULE$.BigDecimal().apply(size).$div(BigDecimal$.MODULE$.long2bigDecimal(GB)), (Object)"GB") : (size.$greater$eq(BigInt$.MODULE$.long2bigInt(2L * MB)) ? new Tuple2((Object)scala.package$.MODULE$.BigDecimal().apply(size).$div(BigDecimal$.MODULE$.long2bigDecimal(MB)), (Object)"MB") : (tuple2 = size.$greater$eq(BigInt$.MODULE$.long2bigInt(2L * KB)) ? new Tuple2((Object)scala.package$.MODULE$.BigDecimal().apply(size).$div(BigDecimal$.MODULE$.long2bigDecimal(KB)), (Object)"KB") : new Tuple2((Object)scala.package$.MODULE$.BigDecimal().apply(size), (Object)"B"))))));
                if (tuple2 == null) break block4;
                BigDecimal value2 = (BigDecimal)tuple2._1();
                String unit = (String)tuple2._2();
                Tuple2 tuple24 = tuple22 = new Tuple2((Object)value2, (Object)unit);
                BigDecimal value3 = (BigDecimal)tuple24._1();
                String unit2 = (String)tuple24._2();
                string = new StringOps(Predef$.MODULE$.augmentString("%.1f %s")).formatLocal(Locale.US, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value3, unit2}));
            }
            return string;
        }
        throw new MatchError((Object)tuple2);
    }

    public String msDurationToString(long ms) {
        int second = 1000;
        int minute = 60 * second;
        int hour = 60 * minute;
        Locale locale = Locale.US;
        long l = ms;
        String string = l < (long)second ? new StringOps(Predef$.MODULE$.augmentString("%d ms")).formatLocal(locale, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)l)})) : (l < (long)minute ? new StringOps(Predef$.MODULE$.augmentString("%.1f s")).formatLocal(locale, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)((float)l / (float)second))})) : (l < (long)hour ? new StringOps(Predef$.MODULE$.augmentString("%.1f m")).formatLocal(locale, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)((float)l / (float)minute))})) : new StringOps(Predef$.MODULE$.augmentString("%.2f h")).formatLocal(locale, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)((float)l / (float)hour))}))));
        return string;
    }

    public String megabytesToString(long megabytes) {
        return this.bytesToString(megabytes * 1024L * 1024L);
    }

    public Process executeCommand(Seq<String> command, File workingDir, Map<String, String> extraEnvironment, boolean redirectStderr) {
        Object object;
        ProcessBuilder builder = new ProcessBuilder((String[])command.toArray(ClassTag$.MODULE$.apply(String.class))).directory(workingDir);
        java.util.Map<String, String> environment = builder.environment();
        extraEnvironment.withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> check$ifrefutable$1) {
                Tuple2<String, String> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(environment){
            public static final long serialVersionUID = 0L;
            private final java.util.Map environment$1;

            public final String apply(Tuple2<String, String> x$7) {
                Tuple2<String, String> tuple2 = x$7;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value2 = (String)tuple2._2();
                    String string = this.environment$1.put(key, value2);
                    return string;
                }
                throw new MatchError(tuple2);
            }
            {
                this.environment$1 = environment$1;
            }
        });
        Process process2 = builder.start();
        if (redirectStderr) {
            String threadName = new StringBuilder().append((Object)"redirect stderr for command ").append(command.apply(0)).toString();
            object = this.processStreamByLine(threadName, process2.getErrorStream(), (Function1<String, BoxedUnit>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(String s) {
                    Utils$.MODULE$.org$apache$spark$util$Utils$$log$1(s);
                }
            });
        } else {
            object = BoxedUnit.UNIT;
        }
        return process2;
    }

    public File executeCommand$default$2() {
        return new File(".");
    }

    public Map<String, String> executeCommand$default$3() {
        return Map$.MODULE$.empty();
    }

    public boolean executeCommand$default$4() {
        return true;
    }

    public String executeAndGetOutput(Seq<String> command, File workingDir, Map<String, String> extraEnvironment, boolean redirectStderr) {
        Process process2 = this.executeCommand(command, workingDir, extraEnvironment, redirectStderr);
        StringBuilder output = new StringBuilder();
        String threadName = new StringBuilder().append((Object)"read stdout for ").append(command.apply(0)).toString();
        Thread stdoutThread = this.processStreamByLine(threadName, process2.getInputStream(), (Function1<String, BoxedUnit>)new Serializable(output){
            public static final long serialVersionUID = 0L;
            private final StringBuilder output$1;

            public final void apply(String s) {
                Utils$.MODULE$.org$apache$spark$util$Utils$$appendToOutput$1(s, this.output$1);
            }
            {
                this.output$1 = output$1;
            }
        });
        int exitCode = process2.waitFor();
        stdoutThread.join();
        if (exitCode != 0) {
            this.logError((Function0<String>)new Serializable(command, output, exitCode){
                public static final long serialVersionUID = 0L;
                private final Seq command$1;
                private final StringBuilder output$1;
                private final int exitCode$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Process ", " exited with code ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.command$1, BoxesRunTime.boxToInteger((int)this.exitCode$1), this.output$1}));
                }
                {
                    this.command$1 = command$1;
                    this.output$1 = output$1;
                    this.exitCode$1 = exitCode$1;
                }
            });
            throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Process ", " exited with code ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{command, BoxesRunTime.boxToInteger((int)exitCode)})));
        }
        return output.toString();
    }

    public File executeAndGetOutput$default$2() {
        return new File(".");
    }

    public Map<String, String> executeAndGetOutput$default$3() {
        return Map$.MODULE$.empty();
    }

    public boolean executeAndGetOutput$default$4() {
        return true;
    }

    public Thread processStreamByLine(String threadName, InputStream inputStream, Function1<String, BoxedUnit> processLine) {
        Thread t = new Thread(threadName, inputStream, processLine){
            private final InputStream inputStream$1;
            public final Function1 processLine$1;

            public void run() {
                Source$.MODULE$.fromInputStream(this.inputStream$1, Codec$.MODULE$.fallbackSystemCodec()).getLines().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.5 $outer;

                    public final void apply(String line) {
                        this.$outer.processLine$1.apply((Object)line);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.inputStream$1 = inputStream$1;
                this.processLine$1 = processLine$1;
                super(threadName$1);
            }
        };
        t.setDaemon(true);
        t.start();
        return t;
    }

    public void tryOrExit(Function0<BoxedUnit> block) {
        Throwable throwable2;
        block3: {
            try {
                block.apply$mcV$sp();
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                if (throwable3 instanceof ControlThrowable) {
                    ControlThrowable controlThrowable = (ControlThrowable)throwable3;
                    throw (Throwable)controlThrowable;
                }
                if (throwable3 == null) break block3;
                Throwable throwable4 = throwable3;
                this.sparkUncaughtExceptionHandler().uncaughtException(throwable4);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw throwable2;
    }

    public void tryOrStopSparkContext(SparkContext sc, Function0<BoxedUnit> block) {
        Throwable throwable3;
        block4: {
            String currentThreadName;
            Throwable throwable2;
            block5: {
                try {
                    block.apply$mcV$sp();
                }
                catch (Throwable throwable3) {
                    Throwable throwable4 = throwable3;
                    if (throwable4 instanceof ControlThrowable) {
                        ControlThrowable controlThrowable = (ControlThrowable)throwable4;
                        throw (Throwable)controlThrowable;
                    }
                    if (throwable4 == null) break block4;
                    throwable2 = throwable4;
                    currentThreadName = Thread.currentThread().getName();
                    if (sc != null) {
                        this.logError((Function0<String>)new Serializable(currentThreadName){
                            public static final long serialVersionUID = 0L;
                            private final String currentThreadName$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"uncaught error in thread ", ", stopping SparkContext"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.currentThreadName$1}));
                            }
                            {
                                this.currentThreadName$1 = currentThreadName$1;
                            }
                        }, throwable2);
                        sc.stopInNewThread();
                    }
                    if (!NonFatal$.MODULE$.apply(throwable2)) break block5;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            this.logError((Function0<String>)new Serializable(currentThreadName){
                public static final long serialVersionUID = 0L;
                private final String currentThreadName$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"throw uncaught fatal error in thread ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.currentThreadName$1}));
                }
                {
                    this.currentThreadName$1 = currentThreadName$1;
                }
            }, throwable2);
            throw throwable2;
        }
        throw throwable3;
    }

    public <T> T tryOrIOException(Function0<T> block) {
        try {
            return (T)block.apply();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof IOException) {
                IOException iOException = (IOException)throwable2;
                this.logError((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Exception encountered";
                    }
                }, iOException);
                throw iOException;
            }
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.logError((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Exception encountered";
                }
            }, e);
            throw new IOException(e);
        }
    }

    public void tryLogNonFatalError(Function0<BoxedUnit> block) {
        try {
            block.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable t = (Throwable)option.get();
            this.logError((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Uncaught exception in thread ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Thread.currentThread().getName()}));
                }
            }, t);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public <T> T tryWithSafeFinally(Function0<T> block, Function0<BoxedUnit> finallyBlock) {
        Throwable throwable;
        Object object;
        Object originalThrowable = null;
        try {
            object = block.apply();
        }
        catch (Throwable throwable2) {
            try {
                throwable = throwable2;
                throw throwable;
            }
            catch (Throwable throwable3) {
                try {
                    finallyBlock.apply$mcV$sp();
                }
                catch (Throwable throwable4) {
                    Throwable throwable5 = throwable4;
                    if (throwable5 != null) {
                        Throwable throwable6 = throwable5;
                        if (throwable != null) {
                            Throwable throwable7 = throwable;
                            Throwable throwable8 = throwable6;
                            if (throwable7 == null ? throwable8 != null : !throwable7.equals(throwable8)) {
                                throwable.addSuppressed(throwable6);
                                this.logWarning((Function0<String>)new Serializable(throwable6){
                                    public static final long serialVersionUID = 0L;
                                    private final Throwable x5$1;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Suppressing exception in finally: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x5$1.getMessage()}));
                                    }
                                    {
                                        this.x5$1 = x5$1;
                                    }
                                }, throwable6);
                                throw throwable;
                            }
                        }
                    }
                    throw throwable4;
                }
                throw throwable3;
            }
        }
        try {
            finallyBlock.apply$mcV$sp();
        }
        catch (Throwable throwable9) {
            Throwable throwable10 = throwable9;
            if (throwable10 != null) {
                Throwable throwable11 = throwable10;
                if (throwable != null) {
                    Throwable throwable12 = throwable;
                    Throwable throwable13 = throwable11;
                    if (throwable12 == null ? throwable13 != null : !throwable12.equals(throwable13)) {
                        throwable.addSuppressed(throwable11);
                        this.logWarning((Function0<String>)new /* invalid duplicate definition of identical inner class */, throwable11);
                        throw throwable;
                    }
                }
            }
            throw throwable9;
        }
        return (T)object;
    }

    public <T> T tryWithSafeFinallyAndFailureCallbacks(Function0<T> block, Function0<BoxedUnit> catchBlock, Function0<BoxedUnit> finallyBlock) {
        Throwable throwable;
        Object object;
        Object originalThrowable = null;
        try {
            object = block.apply();
        }
        catch (Throwable throwable2) {
            try {
                block16: {
                    throwable = throwable2;
                    try {
                        this.logError((Function0<String>)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Aborting task";
                            }
                        }, throwable);
                        TaskContext$.MODULE$.get().markTaskFailed(throwable);
                        catchBlock.apply$mcV$sp();
                    }
                    catch (Throwable throwable3) {
                        Throwable throwable4 = throwable;
                        Throwable throwable5 = throwable3;
                        if (!(throwable4 == null ? throwable5 != null : !throwable4.equals(throwable5))) break block16;
                        throwable.addSuppressed(throwable3);
                        this.logWarning((Function0<String>)new Serializable(throwable3){
                            public static final long serialVersionUID = 0L;
                            private final Throwable t$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Suppressing exception in catch: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.t$1.getMessage()}));
                            }
                            {
                                this.t$1 = t$1;
                            }
                        }, throwable3);
                    }
                }
                throw throwable;
            }
            catch (Throwable throwable6) {
                try {
                    finallyBlock.apply$mcV$sp();
                }
                catch (Throwable throwable7) {
                    Throwable throwable8 = throwable7;
                    if (throwable8 != null) {
                        Throwable throwable9 = throwable8;
                        if (throwable != null) {
                            Throwable throwable10 = throwable;
                            Throwable throwable11 = throwable9;
                            if (throwable10 == null ? throwable11 != null : !throwable10.equals(throwable11)) {
                                throwable.addSuppressed(throwable9);
                                this.logWarning((Function0<String>)new Serializable(throwable9){
                                    public static final long serialVersionUID = 0L;
                                    private final Throwable x5$2;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Suppressing exception in finally: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x5$2.getMessage()}));
                                    }
                                    {
                                        this.x5$2 = x5$2;
                                    }
                                }, throwable9);
                                throw throwable;
                            }
                        }
                    }
                    throw throwable7;
                }
                throw throwable6;
            }
        }
        try {
            finallyBlock.apply$mcV$sp();
        }
        catch (Throwable throwable12) {
            Throwable throwable13 = throwable12;
            if (throwable13 != null) {
                Throwable throwable14 = throwable13;
                if (throwable != null) {
                    Throwable throwable15 = throwable;
                    Throwable throwable16 = throwable14;
                    if (throwable15 == null ? throwable16 != null : !throwable15.equals(throwable16)) {
                        throwable.addSuppressed(throwable14);
                        this.logWarning((Function0<String>)new /* invalid duplicate definition of identical inner class */, throwable14);
                        throw throwable;
                    }
                }
            }
            throw throwable12;
        }
        return (T)object;
    }

    public <T> void tryWithSafeFinallyAndFailureCallbacks$default$2(Function0<T> block) {
    }

    public <T> void tryWithSafeFinallyAndFailureCallbacks$default$3(Function0<T> block) {
    }

    private Regex SPARK_CORE_CLASS_REGEX() {
        return this.SPARK_CORE_CLASS_REGEX;
    }

    private Regex SPARK_SQL_CLASS_REGEX() {
        return this.SPARK_SQL_CLASS_REGEX;
    }

    public boolean org$apache$spark$util$Utils$$sparkInternalExclusionFunction(String className) {
        String SCALA_CORE_CLASS_PREFIX = "scala";
        boolean isSparkClass = this.SPARK_CORE_CLASS_REGEX().findFirstIn((CharSequence)className).isDefined() || this.SPARK_SQL_CLASS_REGEX().findFirstIn((CharSequence)className).isDefined();
        boolean isScalaClass = className.startsWith(SCALA_CORE_CLASS_PREFIX);
        return isSparkClass || isScalaClass;
    }

    public CallSite getCallSite(Function1<String, Object> skipClass) {
        ObjectRef lastSparkMethod = ObjectRef.create((Object)"<unknown>");
        ObjectRef firstUserFile = ObjectRef.create((Object)"<unknown>");
        IntRef firstUserLine = IntRef.create((int)0);
        BooleanRef insideSpark = BooleanRef.create((boolean)true);
        ArrayBuffer callStack = (ArrayBuffer)new ArrayBuffer().$colon$plus((Object)"<unknown>", ArrayBuffer$.MODULE$.canBuildFrom());
        Predef$.MODULE$.refArrayOps((Object[])Thread.currentThread().getStackTrace()).foreach((Function1)new Serializable(skipClass, lastSparkMethod, firstUserFile, firstUserLine, insideSpark, callStack){
            public static final long serialVersionUID = 0L;
            private final Function1 skipClass$1;
            private final ObjectRef lastSparkMethod$1;
            private final ObjectRef firstUserFile$1;
            private final IntRef firstUserLine$1;
            private final BooleanRef insideSpark$1;
            private final ArrayBuffer callStack$1;

            public final Object apply(StackTraceElement ste) {
                BoxedUnit boxedUnit;
                if (ste == null || ste.getMethodName() == null || ste.getMethodName().contains("getStackTrace")) {
                    boxedUnit = BoxedUnit.UNIT;
                } else if (this.insideSpark$1.elem) {
                    if (BoxesRunTime.unboxToBoolean((Object)this.skipClass$1.apply((Object)ste.getClassName()))) {
                        String string = ste.getMethodName();
                        String string2 = "<init>";
                        this.lastSparkMethod$1.elem = !(string != null ? !string.equals(string2) : string2 != null) ? ste.getClassName().substring(ste.getClassName().lastIndexOf(46) + 1) : ste.getMethodName();
                        this.callStack$1.update(0, (Object)ste.toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        if (ste.getFileName() != null) {
                            this.firstUserFile$1.elem = ste.getFileName();
                            if (ste.getLineNumber() >= 0) {
                                this.firstUserLine$1.elem = ste.getLineNumber();
                            }
                        }
                        this.callStack$1.$plus$eq((Object)ste.toString());
                        this.insideSpark$1.elem = false;
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit = this.callStack$1.$plus$eq((Object)ste.toString());
                }
                return boxedUnit;
            }
            {
                this.skipClass$1 = skipClass$1;
                this.lastSparkMethod$1 = lastSparkMethod$1;
                this.firstUserFile$1 = firstUserFile$1;
                this.firstUserLine$1 = firstUserLine$1;
                this.insideSpark$1 = insideSpark$1;
                this.callStack$1 = callStack$1;
            }
        });
        int callStackDepth = new StringOps(Predef$.MODULE$.augmentString(System.getProperty("spark.callstack.depth", "20"))).toInt();
        String string = (String)firstUserFile.elem;
        String string2 = "HiveSessionImpl.java";
        String shortForm = !(string != null ? !string.equals(string2) : string2 != null) ? "Spark JDBC Server Query" : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " at ", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(String)lastSparkMethod.elem, (String)firstUserFile.elem, BoxesRunTime.boxToInteger((int)firstUserLine.elem)}));
        String longForm = ((TraversableOnce)callStack.take(callStackDepth)).mkString("\n");
        return new CallSite(shortForm, longForm);
    }

    public Function1<String, Object> getCallSite$default$1() {
        return new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String className) {
                return Utils$.MODULE$.org$apache$spark$util$Utils$$sparkInternalExclusionFunction(className);
            }
        };
    }

    private String UNCOMPRESSED_LOG_FILE_LENGTH_CACHE_SIZE_CONF() {
        return this.UNCOMPRESSED_LOG_FILE_LENGTH_CACHE_SIZE_CONF;
    }

    private int DEFAULT_UNCOMPRESSED_LOG_FILE_LENGTH_CACHE_SIZE() {
        return this.DEFAULT_UNCOMPRESSED_LOG_FILE_LENGTH_CACHE_SIZE;
    }

    private LoadingCache<String, Long> compressedLogFileLengthCache() {
        return this.compressedLogFileLengthCache;
    }

    private void compressedLogFileLengthCache_$eq(LoadingCache<String, Long> x$1) {
        this.compressedLogFileLengthCache = x$1;
    }

    private synchronized LoadingCache<String, Long> getCompressedLogFileLengthCache(SparkConf sparkConf) {
        if (this.compressedLogFileLengthCache() == null) {
            int compressedLogFileLengthCacheSize = sparkConf.getInt(this.UNCOMPRESSED_LOG_FILE_LENGTH_CACHE_SIZE_CONF(), this.DEFAULT_UNCOMPRESSED_LOG_FILE_LENGTH_CACHE_SIZE());
            this.compressedLogFileLengthCache_$eq((LoadingCache<String, Long>)CacheBuilder.newBuilder().maximumSize((long)compressedLogFileLengthCacheSize).build((CacheLoader)new CacheLoader<String, Long>(){

                public Long load(String path) {
                    return Predef$.MODULE$.long2Long(Utils$.MODULE$.org$apache$spark$util$Utils$$getCompressedFileLength(new File(path)));
                }
            }));
        }
        return this.compressedLogFileLengthCache();
    }

    public long getFileLength(File file, SparkConf workConf) {
        return file.getName().endsWith(".gz") ? Predef$.MODULE$.Long2long((Long)this.getCompressedLogFileLengthCache(workConf).get((Object)file.getAbsolutePath())) : file.length();
    }

    public long org$apache$spark$util$Utils$$getCompressedFileLength(File file) {
        long l;
        block6: {
            GZIPInputStream gzInputStream = null;
            try {
                long fileSize = 0L;
                gzInputStream = new GZIPInputStream(new FileInputStream(file));
                int bufSize = 1024;
                byte[] buf = new byte[bufSize];
                int numBytes = ByteStreams.read((InputStream)gzInputStream, (byte[])buf, (int)0, (int)bufSize);
                while (numBytes > 0) {
                    fileSize += (long)numBytes;
                    numBytes = ByteStreams.read((InputStream)gzInputStream, (byte[])buf, (int)0, (int)bufSize);
                }
                l = fileSize;
                if (gzInputStream == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    this.logError((Function0<String>)new Serializable(file){
                        public static final long serialVersionUID = 0L;
                        private final File file$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot get file length of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1}));
                        }
                        {
                            this.file$1 = file$1;
                        }
                    }, throwable);
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    if (gzInputStream != null) {
                        gzInputStream.close();
                    }
                    throw throwable2;
                }
            }
            gzInputStream.close();
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    public String offsetBytes(String path, long length, long start2, long end) {
        File file = new File(path);
        long effectiveEnd = package$.MODULE$.min(length, end);
        long effectiveStart = package$.MODULE$.max(0L, start2);
        byte[] buff = new byte[(int)(effectiveEnd - effectiveStart)];
        InputStream stream = path.endsWith(".gz") ? new GZIPInputStream(new FileInputStream(file)) : new FileInputStream(file);
        try {
            ByteStreams.skipFully((InputStream)stream, (long)effectiveStart);
            ByteStreams.readFully((InputStream)stream, (byte[])buff);
        }
        catch (Throwable throwable) {
            void var14_9;
            var14_9.close();
            throw throwable;
        }
        stream.close();
        return Source$.MODULE$.fromBytes(buff, Codec$.MODULE$.fallbackSystemCodec()).mkString();
    }

    public String offsetBytes(Seq<File> files, Seq<Object> fileLengths, long start2, long end) {
        Predef$.MODULE$.assert(files.length() == fileLengths.length());
        long startIndex = package$.MODULE$.max(start2, 0L);
        long endIndex = package$.MODULE$.min(end, BoxesRunTime.unboxToLong((Object)fileLengths.sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
        scala.collection.immutable.Map fileToLength = ((TraversableOnce)files.zip(fileLengths, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.logDebug((Function0<String>)new Serializable(fileToLength){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map fileToLength$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Log files: \n").append((Object)this.fileToLength$1.mkString("\n")).toString();
            }
            {
                this.fileToLength$1 = fileToLength$1;
            }
        });
        StringBuffer stringBuffer = new StringBuffer((int)(endIndex - startIndex));
        LongRef sum2 = LongRef.create((long)0L);
        ((IterableLike)files.zip(fileLengths, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(startIndex, endIndex, fileToLength, stringBuffer, sum2){
            public static final long serialVersionUID = 0L;
            private final long startIndex$2;
            public final long endIndex$1;
            private final scala.collection.immutable.Map fileToLength$1;
            public final StringBuffer stringBuffer$1;
            private final LongRef sum$1;

            public final void apply(Tuple2<File, Object> x0$2) {
                Tuple2<File, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    Object object;
                    File file = (File)tuple2._1();
                    long fileLength = tuple2._2$mcJ$sp();
                    long startIndexOfFile = this.sum$1.elem;
                    long endIndexOfFile = this.sum$1.elem + BoxesRunTime.unboxToLong((Object)this.fileToLength$1.apply((Object)file));
                    Utils$.MODULE$.logDebug((Function0<String>)new Serializable(this, file, startIndexOfFile){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.offsetBytes.2 $outer;
                        private final File file$2;
                        private final long startIndexOfFile$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processing file ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$2}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"with start index = ", ", end index = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.startIndexOfFile$1), BoxesRunTime.boxToLong((long)this.$outer.endIndex$1)}))).toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.file$2 = file$2;
                            this.startIndexOfFile$1 = startIndexOfFile$1;
                        }
                    });
                    if (this.startIndex$2 <= startIndexOfFile && this.endIndex$1 >= endIndexOfFile) {
                        object = this.stringBuffer$1.append(Utils$.MODULE$.offsetBytes(file.getAbsolutePath(), fileLength, 0L, BoxesRunTime.unboxToLong((Object)this.fileToLength$1.apply((Object)file))));
                    } else if (this.startIndex$2 > startIndexOfFile && this.startIndex$2 < endIndexOfFile) {
                        long effectiveStartIndex = this.startIndex$2 - startIndexOfFile;
                        long effectiveEndIndex = package$.MODULE$.min(this.endIndex$1 - startIndexOfFile, BoxesRunTime.unboxToLong((Object)this.fileToLength$1.apply((Object)file)));
                        object = this.stringBuffer$1.append(Utils$.MODULE$.offsetBytes(file.getAbsolutePath(), fileLength, effectiveStartIndex, effectiveEndIndex));
                    } else if (this.endIndex$1 > startIndexOfFile && this.endIndex$1 < endIndexOfFile) {
                        long effectiveStartIndex = package$.MODULE$.max(this.startIndex$2 - startIndexOfFile, 0L);
                        long effectiveEndIndex = this.endIndex$1 - startIndexOfFile;
                        object = this.stringBuffer$1.append(Utils$.MODULE$.offsetBytes(file.getAbsolutePath(), fileLength, effectiveStartIndex, effectiveEndIndex));
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                    this.sum$1.elem += BoxesRunTime.unboxToLong((Object)this.fileToLength$1.apply((Object)file));
                    Utils$.MODULE$.logDebug((Function0<String>)new Serializable(this, file){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.offsetBytes.2 $outer;
                        private final File file$2;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"After processing file ", ", string built is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$2, this.$outer.stringBuffer$1.toString()}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.file$2 = file$2;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.startIndex$2 = startIndex$2;
                this.endIndex$1 = endIndex$1;
                this.fileToLength$1 = fileToLength$1;
                this.stringBuffer$1 = stringBuffer$1;
                this.sum$1 = sum$1;
            }
        });
        return stringBuffer.toString();
    }

    public <T> T clone(T value2, SerializerInstance serializer, ClassTag<T> evidence$2) {
        return serializer.deserialize(serializer.serialize(value2, evidence$2), evidence$2);
    }

    private boolean isSpace(char c) {
        return " \t\r\n".indexOf(c) != -1;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> splitCommandString(String s) {
        void var2_2;
        ArrayBuffer buf = new ArrayBuffer();
        boolean inWord = false;
        boolean inSingleQuote = false;
        boolean inDoubleQuote = false;
        StringBuilder curWord = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            BoxedUnit boxedUnit;
            char nextChar = s.charAt(i);
            if (inDoubleQuote) {
                if (nextChar == '\"') {
                    inDoubleQuote = false;
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (nextChar == '\\') {
                    if (i < s.length() - 1) {
                        curWord.append(s.charAt(i + 1));
                        ++i;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                boxedUnit = curWord.append(nextChar);
                continue;
            }
            if (inSingleQuote) {
                if (nextChar == '\'') {
                    inSingleQuote = false;
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                boxedUnit = curWord.append(nextChar);
                continue;
            }
            if (nextChar == '\"') {
                inWord = true;
                inDoubleQuote = true;
            } else if (nextChar == '\'') {
                inWord = true;
                inSingleQuote = true;
            } else if (this.isSpace(nextChar)) {
                if (inWord && this.isSpace(nextChar)) {
                    this.endWord$1(buf, curWord);
                    inWord = false;
                }
            } else {
                curWord.append(nextChar);
                inWord = true;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        if (inWord || inDoubleQuote || inSingleQuote) {
            this.endWord$1(buf, curWord);
        }
        return var2_2;
    }

    public int nonNegativeMod(int x, int mod) {
        int rawMod;
        return rawMod + ((rawMod = x % mod) < 0 ? mod : 0);
    }

    /*
     * WARNING - void declaration
     */
    public int nonNegativeHash(Object obj) {
        void var3_3;
        if (obj == null) {
            return 0;
        }
        int hash = obj.hashCode();
        int hashAbs = Integer.MIN_VALUE != hash ? package$.MODULE$.abs(hash) : 0;
        return (int)var3_3;
    }

    public int nanSafeCompareDoubles(double x, double y) {
        boolean xIsNan = Double.isNaN(x);
        boolean yIsNan = Double.isNaN(y);
        return xIsNan && yIsNan || x == y ? 0 : (xIsNan ? 1 : (yIsNan ? -1 : (x > y ? 1 : -1)));
    }

    public int nanSafeCompareFloats(float x, float y) {
        boolean xIsNan = Float.isNaN(x);
        boolean yIsNan = Float.isNaN(y);
        return xIsNan && yIsNan || x == y ? 0 : (xIsNan ? 1 : (yIsNan ? -1 : (x > y ? 1 : -1)));
    }

    public Map<String, String> getSystemProperties() {
        return ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(System.getProperties().stringPropertyNames()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(String key) {
                return new Tuple2((Object)key, (Object)System.getProperty(key));
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public void times(int numIters, Function0<BoxedUnit> f) {
        for (int i = 0; i < numIters; ++i) {
            f.apply$mcV$sp();
        }
    }

    public long timeIt(int numIters, Function0<BoxedUnit> f, Option<Function0<BoxedUnit>> prepare) {
        long l;
        if (prepare.isEmpty()) {
            long start2 = System.currentTimeMillis();
            this.times(numIters, f);
            l = System.currentTimeMillis() - start2;
        } else {
            long sum2 = 0L;
            for (int i = 0; i < numIters; ++i) {
                ((Function0)prepare.get()).apply$mcV$sp();
                long start3 = System.currentTimeMillis();
                f.apply$mcV$sp();
                sum2 += System.currentTimeMillis() - start3;
            }
            l = sum2;
        }
        return l;
    }

    public Option<Function0<BoxedUnit>> timeIt$default$3(int numIters) {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    public long getIteratorSize(Iterator<?> iterator2) {
        void var2_2;
        long count2 = 0L;
        while (iterator2.hasNext()) {
            ++count2;
            iterator2.next();
        }
        return (long)var2_2;
    }

    public <T> Iterator<Tuple2<T, Object>> getIteratorZipWithIndex(Iterator<T> iterator2, long startIndex) {
        return new Iterator<Tuple2<T, Object>>(iterator2, startIndex){
            private long index;
            private final Iterator iterator$1;

            public Iterator<Tuple2<T, Object>> seq() {
                return Iterator.class.seq((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.class.isEmpty((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.class.isTraversableAgain((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.class.hasDefiniteSize((Iterator)this);
            }

            public Iterator<Tuple2<T, Object>> take(int n) {
                return Iterator.class.take((Iterator)this, (int)n);
            }

            public Iterator<Tuple2<T, Object>> drop(int n) {
                return Iterator.class.drop((Iterator)this, (int)n);
            }

            public Iterator<Tuple2<T, Object>> slice(int from, int until) {
                return Iterator.class.slice((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<Tuple2<T, Object>, B> f) {
                return Iterator.class.map((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.class.$plus$plus((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<Tuple2<T, Object>, GenTraversableOnce<B>> f) {
                return Iterator.class.flatMap((Iterator)this, f);
            }

            public Iterator<Tuple2<T, Object>> filter(Function1<Tuple2<T, Object>, Object> p) {
                return Iterator.class.filter((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<Tuple2<T, Object>, B, Object> p) {
                return Iterator.class.corresponds((Iterator)this, that, p);
            }

            public Iterator<Tuple2<T, Object>> withFilter(Function1<Tuple2<T, Object>, Object> p) {
                return Iterator.class.withFilter((Iterator)this, p);
            }

            public Iterator<Tuple2<T, Object>> filterNot(Function1<Tuple2<T, Object>, Object> p) {
                return Iterator.class.filterNot((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<Tuple2<T, Object>, B> pf) {
                return Iterator.class.collect((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, Tuple2<T, Object>, B> op) {
                return Iterator.class.scanLeft((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<Tuple2<T, Object>, B, B> op) {
                return Iterator.class.scanRight((Iterator)this, z, op);
            }

            public Iterator<Tuple2<T, Object>> takeWhile(Function1<Tuple2<T, Object>, Object> p) {
                return Iterator.class.takeWhile((Iterator)this, p);
            }

            public Tuple2<Iterator<Tuple2<T, Object>>, Iterator<Tuple2<T, Object>>> partition(Function1<Tuple2<T, Object>, Object> p) {
                return Iterator.class.partition((Iterator)this, p);
            }

            public Tuple2<Iterator<Tuple2<T, Object>>, Iterator<Tuple2<T, Object>>> span(Function1<Tuple2<T, Object>, Object> p) {
                return Iterator.class.span((Iterator)this, p);
            }

            public Iterator<Tuple2<T, Object>> dropWhile(Function1<Tuple2<T, Object>, Object> p) {
                return Iterator.class.dropWhile((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<Tuple2<T, Object>, B>> zip(Iterator<B> that) {
                return Iterator.class.zip((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.class.padTo((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<Tuple2<T, Object>, Object>> zipWithIndex() {
                return Iterator.class.zipWithIndex((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.class.zipAll((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<Tuple2<T, Object>, U> f) {
                Iterator.class.foreach((Iterator)this, f);
            }

            public boolean forall(Function1<Tuple2<T, Object>, Object> p) {
                return Iterator.class.forall((Iterator)this, p);
            }

            public boolean exists(Function1<Tuple2<T, Object>, Object> p) {
                return Iterator.class.exists((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.class.contains((Iterator)this, (Object)elem);
            }

            public Option<Tuple2<T, Object>> find(Function1<Tuple2<T, Object>, Object> p) {
                return Iterator.class.find((Iterator)this, p);
            }

            public int indexWhere(Function1<Tuple2<T, Object>, Object> p) {
                return Iterator.class.indexWhere((Iterator)this, p);
            }

            public <B> int indexOf(B elem) {
                return Iterator.class.indexOf((Iterator)this, elem);
            }

            public BufferedIterator<Tuple2<T, Object>> buffered() {
                return Iterator.class.buffered((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.class.grouped((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.class.sliding((Iterator)this, (int)size, (int)step);
            }

            public int length() {
                return Iterator.class.length((Iterator)this);
            }

            public Tuple2<Iterator<Tuple2<T, Object>>, Iterator<Tuple2<T, Object>>> duplicate() {
                return Iterator.class.duplicate((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.class.patch((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start2, int len) {
                Iterator.class.copyToArray((Iterator)this, (Object)xs, (int)start2, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.class.sameElements((Iterator)this, that);
            }

            public Traversable<Tuple2<T, Object>> toTraversable() {
                return Iterator.class.toTraversable((Iterator)this);
            }

            public Iterator<Tuple2<T, Object>> toIterator() {
                return Iterator.class.toIterator((Iterator)this);
            }

            public Stream<Tuple2<T, Object>> toStream() {
                return Iterator.class.toStream((Iterator)this);
            }

            public String toString() {
                return Iterator.class.toString((Iterator)this);
            }

            public <B> int sliding$default$2() {
                return Iterator.class.sliding$default$2((Iterator)this);
            }

            public List<Tuple2<T, Object>> reversed() {
                return TraversableOnce.class.reversed((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.class.size((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.class.nonEmpty((TraversableOnce)this);
            }

            public int count(Function1<Tuple2<T, Object>, Object> p) {
                return TraversableOnce.class.count((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<Tuple2<T, Object>, B> pf) {
                return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, Tuple2<T, Object>, B> op) {
                return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<Tuple2<T, Object>, B, B> op) {
                return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, Tuple2<T, Object>, B> op) {
                return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<Tuple2<T, Object>, B, B> op) {
                return (B)TraversableOnce.class.foldRight((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, Tuple2<T, Object>, B> op) {
                return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<Tuple2<T, Object>, B, B> op) {
                return (B)TraversableOnce.class.reduceRight((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, Tuple2<T, Object>, B> op) {
                return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<Tuple2<T, Object>, B, B> op) {
                return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, Tuple2<T, Object>, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.class.product((TraversableOnce)this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.class.min((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.class.max((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.class.maxBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.class.minBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start2) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start2);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
            }

            public List<Tuple2<T, Object>> toList() {
                return TraversableOnce.class.toList((TraversableOnce)this);
            }

            public Iterable<Tuple2<T, Object>> toIterable() {
                return TraversableOnce.class.toIterable((TraversableOnce)this);
            }

            public Seq<Tuple2<T, Object>> toSeq() {
                return TraversableOnce.class.toSeq((TraversableOnce)this);
            }

            public IndexedSeq<Tuple2<T, Object>> toIndexedSeq() {
                return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.class.toBuffer((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.class.toSet((TraversableOnce)this);
            }

            public Vector<Tuple2<T, Object>> toVector() {
                return TraversableOnce.class.toVector((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, Tuple2<T, Object>, Col> cbf) {
                return (Col)TraversableOnce.class.to((TraversableOnce)this, cbf);
            }

            public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef.$less$colon$less<Tuple2<T, Object>, Tuple2<T, U>> ev) {
                return TraversableOnce.class.toMap((TraversableOnce)this, ev);
            }

            public String mkString(String start2, String sep, String end) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)start2, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.class.mkString((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start2, String sep, String end) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start2, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
            }

            private long index() {
                return this.index;
            }

            private void index_$eq(long x$1) {
                this.index = x$1;
            }

            public boolean hasNext() {
                return this.iterator$1.hasNext();
            }

            public Tuple2<T, Object> next() {
                this.index_$eq(this.index() + 1L);
                return new Tuple2(this.iterator$1.next(), (Object)BoxesRunTime.boxToLong((long)this.index()));
            }
            {
                this.iterator$1 = iterator$1;
                TraversableOnce.class.$init$((TraversableOnce)this);
                Iterator.class.$init$((Iterator)this);
                Predef$.MODULE$.require(startIndex$1 >= 0L, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "startIndex should be >= 0.";
                    }
                });
                this.index = startIndex$1 - 1L;
            }
        };
    }

    public void symlink(File src, File dst) {
        if (src.isAbsolute()) {
            if (dst.isAbsolute()) {
                throw new IOException("Destination must be relative");
            }
            java.nio.file.Files.createSymbolicLink(dst.toPath(), src.toPath(), new FileAttribute[0]);
            return;
        }
        throw new IOException("Source must be absolute");
    }

    public String getFormattedClassName(Object obj) {
        return this.getSimpleName(obj.getClass()).replace("$", "");
    }

    public FileSystem getHadoopFileSystem(URI path, Configuration conf) {
        return FileSystem.get((URI)path, (Configuration)conf);
    }

    public FileSystem getHadoopFileSystem(String path, Configuration conf) {
        return this.getHadoopFileSystem(new URI(path), conf);
    }

    public boolean isWindows() {
        return this.isWindows;
    }

    public boolean isMac() {
        return this.isMac;
    }

    public Regex windowsDrive() {
        return this.windowsDrive;
    }

    public boolean isTesting() {
        return scala.sys.package$.MODULE$.env().contains((Object)"SPARK_TESTING") || scala.sys.package$.MODULE$.props().contains("spark.testing");
    }

    public Option<Object> terminateProcess(Process process2, long timeoutMs) {
        Option option;
        process2.destroy();
        if (process2.waitFor(timeoutMs, TimeUnit.MILLISECONDS)) {
            option = Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)process2.exitValue()));
        } else {
            Process process3;
            try {
                process3 = process2.destroyForcibly();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option2 = NonFatal$.MODULE$.unapply(throwable2);
                if (option2.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option2.get();
                this.logWarning((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Exception when attempting to kill process";
                    }
                }, e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                process3 = boxedUnit;
            }
            if (process2.waitFor(timeoutMs, TimeUnit.MILLISECONDS)) {
                option = Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)process2.exitValue()));
            } else {
                this.logWarning((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Timed out waiting to forcibly kill process";
                    }
                });
                option = None$.MODULE$;
            }
        }
        return option;
    }

    public Option<String> getStderr(Process process2, long timeoutMs) {
        boolean terminated = process2.waitFor(timeoutMs, TimeUnit.MILLISECONDS);
        return terminated ? new Some((Object)Source$.MODULE$.fromInputStream(process2.getErrorStream(), Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString("\n")) : None$.MODULE$;
    }

    public <T> T logUncaughtExceptions(Function0<T> f) {
        try {
            return (T)f.apply();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ControlThrowable) {
                ControlThrowable controlThrowable = (ControlThrowable)throwable2;
                throw (Throwable)controlThrowable;
            }
            if (throwable2 != null) {
                Throwable throwable3 = throwable2;
                this.logError((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Uncaught exception in thread ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Thread.currentThread().getName()}));
                    }
                }, throwable3);
                throw throwable3;
            }
            throw throwable;
        }
    }

    public <T> Try<T> tryLog(Function0<T> f) {
        Throwable throwable2;
        block3: {
            Success success;
            try {
                Object res = f.apply();
                success = new Success(res);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                if (throwable3 instanceof ControlThrowable) {
                    ControlThrowable controlThrowable = (ControlThrowable)throwable3;
                    throw (Throwable)controlThrowable;
                }
                if (throwable3 == null) break block3;
                Throwable throwable4 = throwable3;
                this.logError((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Uncaught exception in thread ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Thread.currentThread().getName()}));
                    }
                }, throwable4);
                Failure failure = new Failure(throwable4);
                success = failure;
            }
            return success;
        }
        throw throwable2;
    }

    public boolean isFatalError(Throwable e) {
        Throwable throwable = e;
        Option option = NonFatal$.MODULE$.unapply(throwable);
        boolean bl = option.isEmpty() ? (throwable instanceof InterruptedException ? true : (throwable instanceof NotImplementedError ? true : (throwable instanceof ControlThrowable ? true : throwable instanceof LinkageError))) : true;
        boolean bl2 = !bl;
        return bl2;
    }

    public URI resolveURI(String path) {
        block4: {
            try {
                URI uri = new URI(path);
                if (uri.getScheme() == null) {
                    if (uri.getFragment() != null) {
                        URI absoluteURI = new File(uri.getPath()).getAbsoluteFile().toURI();
                        return new URI(absoluteURI.getScheme(), absoluteURI.getHost(), absoluteURI.getPath(), uri.getFragment());
                    }
                    break block4;
                }
                return uri;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return new File(path).getAbsoluteFile().toURI();
    }

    public String resolveURIs(String paths) {
        return paths == null || paths.trim().isEmpty() ? "" : Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])paths.split(",")).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$8) {
                return new StringOps(Predef$.MODULE$.augmentString(x$8.trim())).nonEmpty();
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final URI apply(String p) {
                return Utils$.MODULE$.resolveURI(p);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(URI.class)))).mkString(",");
    }

    public String[] nonLocalPaths(String paths, boolean testWindows) {
        boolean windows = this.isWindows() || testWindows;
        return paths == null || paths.trim().isEmpty() ? (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)) : (String[])Predef$.MODULE$.refArrayOps((Object[])paths.split(",")).filter((Function1)new Serializable(windows){
            public static final long serialVersionUID = 0L;
            private final boolean windows$1;

            public final boolean apply(String p) {
                boolean bl;
                URI uri = Utils$.MODULE$.resolveURI(p);
                CharSequence charSequence = (CharSequence)Option$.MODULE$.apply((Object)uri.getScheme()).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "file";
                    }
                });
                Option option = Utils$.MODULE$.windowsDrive().unapplySeq(charSequence);
                if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0 && this.windows$1) {
                    bl = false;
                } else {
                    boolean bl2 = "local".equals(charSequence) ? true : "file".equals(charSequence);
                    bl = !bl2;
                }
                return bl;
            }
            {
                this.windows$1 = windows$1;
            }
        });
    }

    public boolean nonLocalPaths$default$2() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public String loadDefaultSparkProperties(SparkConf conf, String filePath) {
        void var3_3;
        String path = (String)Option$.MODULE$.apply((Object)filePath).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return Utils$.MODULE$.getDefaultPropertiesFile(Utils$.MODULE$.getDefaultPropertiesFile$default$1());
            }
        });
        Option$.MODULE$.apply((Object)path).foreach((Function1)new Serializable(conf){
            public static final long serialVersionUID = 0L;
            public final SparkConf conf$2;

            public final void apply(String confFile) {
                ((IterableLike)Utils$.MODULE$.getPropertiesFromFile(confFile).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<String, String> x0$3) {
                        Tuple2<String, String> tuple2 = x0$3;
                        if (tuple2 != null) {
                            String k = (String)tuple2._1();
                            boolean bl = k.startsWith("spark.");
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                })).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.loadDefaultSparkProperties.1 $outer;

                    public final String apply(Tuple2<String, String> x0$4) {
                        Tuple2<String, String> tuple2 = x0$4;
                        if (tuple2 != null) {
                            String k = (String)tuple2._1();
                            String v = (String)tuple2._2();
                            this.$outer.conf$2.setIfMissing(k, v);
                            String string = (String)scala.sys.package$.MODULE$.props().getOrElseUpdate((Object)k, (Function0)new Serializable(this, v){
                                public static final long serialVersionUID = 0L;
                                private final String v$1;

                                public final String apply() {
                                    return this.v$1;
                                }
                                {
                                    this.v$1 = v$1;
                                }
                            });
                            return string;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.conf$2 = conf$2;
            }
        });
        return var3_3;
    }

    public String loadDefaultSparkProperties$default$2() {
        return null;
    }

    public void updateSparkConfigFromProperties(SparkConf conf, Map<String, String> properties) {
        ((IterableLike)properties.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> x0$5) {
                Tuple2<String, String> tuple2 = x0$5;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    boolean bl = k.startsWith("spark.");
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        })).foreach((Function1)new Serializable(conf){
            public static final long serialVersionUID = 0L;
            private final SparkConf conf$4;

            public final SparkConf apply(Tuple2<String, String> x0$6) {
                Tuple2<String, String> tuple2 = x0$6;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    SparkConf sparkConf = this.conf$4.set(k, v);
                    return sparkConf;
                }
                throw new MatchError(tuple2);
            }
            {
                this.conf$4 = conf$4;
            }
        });
    }

    public String trimExceptCRLF(String str) {
        Serializable nonSpaceOrNaturalLineDelimiter = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(char ch) {
                return ch > ' ' || ch == '\r' || ch == '\n';
            }
        };
        int firstPos = new StringOps(Predef$.MODULE$.augmentString(str)).indexWhere((Function1)nonSpaceOrNaturalLineDelimiter);
        int lastPos = new StringOps(Predef$.MODULE$.augmentString(str)).lastIndexWhere((Function1)nonSpaceOrNaturalLineDelimiter);
        return firstPos >= 0 && lastPos >= 0 ? str.substring(firstPos, lastPos + 1) : "";
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, String> getPropertiesFromFile(String filename) {
        scala.collection.immutable.Map map2;
        File file = new File(filename);
        Predef$.MODULE$.require(file.exists(), (Function0)new Serializable(file){
            public static final long serialVersionUID = 0L;
            private final File file$3;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Properties file ", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$3}));
            }
            {
                this.file$3 = file$3;
            }
        });
        Predef$.MODULE$.require(file.isFile(), (Function0)new Serializable(file){
            public static final long serialVersionUID = 0L;
            private final File file$3;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Properties file ", " is not a normal file"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$3}));
            }
            {
                this.file$3 = file$3;
            }
        });
        InputStreamReader inReader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
        try {
            Properties properties = new Properties();
            properties.load(inReader);
            map2 = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(properties.stringPropertyNames()).asScala()).map((Function1)new Serializable(properties){
                public static final long serialVersionUID = 0L;
                private final Properties properties$1;

                public final Tuple2<String, String> apply(String k) {
                    return new Tuple2((Object)k, (Object)Utils$.MODULE$.trimExceptCRLF(this.properties$1.getProperty(k)));
                }
                {
                    this.properties$1 = properties$1;
                }
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        }
        catch (IOException iOException) {
            try {
                throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed when loading Spark properties from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filename})), iOException);
            }
            catch (Throwable throwable) {
                void var3_3;
                var3_3.close();
                throw throwable;
            }
        }
        inReader.close();
        return map2;
    }

    public String getDefaultPropertiesFile(Map<String, String> env) {
        return (String)env.get((Object)"SPARK_CONF_DIR").orElse((Function0)new Serializable(env){
            public static final long serialVersionUID = 0L;
            private final Map env$1;

            public final Option<String> apply() {
                return this.env$1.get((Object)"SPARK_HOME").map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String t) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", "conf"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t, File.separator}));
                    }
                });
            }
            {
                this.env$1 = env$1;
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final File apply(String t) {
                return new File(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", "spark-defaults.conf"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t, File.separator})));
            }
        }).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$9) {
                return x$9.isFile();
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(File x$10) {
                return x$10.getAbsolutePath();
            }
        }).orNull(Predef$.MODULE$.$conforms());
    }

    public Map<String, String> getDefaultPropertiesFile$default$1() {
        return scala.sys.package$.MODULE$.env();
    }

    public String exceptionString(Throwable e) {
        String string;
        if (e == null) {
            string = "";
        } else {
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            string = stringWriter.toString();
        }
        return string;
    }

    public Utils.Lock org$apache$spark$util$Utils$$Lock(LockInfo lock) {
        return new Utils.Lock(lock);
    }

    public ThreadStackTrace[] getThreadDump() {
        ThreadInfo[] threadInfos = (ThreadInfo[])Predef$.MODULE$.refArrayOps((Object[])ManagementFactory.getThreadMXBean().dumpAllThreads(true, true)).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ThreadInfo x$11) {
                return x$11 != null;
            }
        });
        return (ThreadStackTrace[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])threadInfos).sortWith((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ThreadInfo x0$7, ThreadInfo x1$1) {
                Tuple2 tuple2 = new Tuple2((Object)x0$7, (Object)x1$1);
                if (tuple2 != null) {
                    String name2;
                    String name1;
                    int nameCmpRes;
                    boolean v2;
                    ThreadInfo threadTrace1 = (ThreadInfo)tuple2._1();
                    ThreadInfo threadTrace2 = (ThreadInfo)tuple2._2();
                    boolean v1 = threadTrace1.getThreadName().contains("Executor task launch");
                    boolean bl = v2 = threadTrace2.getThreadName().contains("Executor task launch");
                    boolean bl2 = v1 == v2 ? ((nameCmpRes = (name1 = threadTrace1.getThreadName().toLowerCase(Locale.ROOT)).compareTo(name2 = threadTrace2.getThreadName().toLowerCase(Locale.ROOT))) == 0 ? threadTrace1.getThreadId() < threadTrace2.getThreadId() : nameCmpRes < 0) : v1 > v2;
                    return bl2;
                }
                throw new MatchError((Object)tuple2);
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ThreadStackTrace apply(ThreadInfo threadInfo) {
                return Utils$.MODULE$.org$apache$spark$util$Utils$$threadInfoToThreadStackTrace(threadInfo);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ThreadStackTrace.class)));
    }

    public Option<ThreadStackTrace> getThreadDumpForThread(long threadId) {
        None$ none$;
        if (threadId <= 0L) {
            none$ = None$.MODULE$;
        } else {
            Option threadInfo = Option$.MODULE$.apply((Object)ManagementFactory.getThreadMXBean().getThreadInfo(threadId, Integer.MAX_VALUE));
            none$ = threadInfo.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final ThreadStackTrace apply(ThreadInfo threadInfo) {
                    return Utils$.MODULE$.org$apache$spark$util$Utils$$threadInfoToThreadStackTrace(threadInfo);
                }
            });
        }
        return none$;
    }

    public ThreadStackTrace org$apache$spark$util$Utils$$threadInfoToThreadStackTrace(ThreadInfo threadInfo) {
        scala.collection.immutable.Map monitors = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])threadInfo.getLockedMonitors()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<StackTraceElement, MonitorInfo> apply(MonitorInfo m) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)m.getLockedStackFrame()), (Object)m);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
        StackTrace stackTrace = new StackTrace((Seq<String>)((Seq)Predef$.MODULE$.refArrayOps((Object[])threadInfo.getStackTrace()).map((Function1)new Serializable(monitors){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map monitors$1;

            public final String apply(StackTraceElement frame) {
                Option option;
                block4: {
                    String string;
                    block3: {
                        block2: {
                            option = this.monitors$1.get((Object)frame);
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            MonitorInfo monitor = (MonitorInfo)some.x();
                            string = new StringBuilder().append((Object)monitor.getLockedStackFrame().toString()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" => holding ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Utils$.MODULE$.org$apache$spark$util$Utils$$Lock(monitor).lockString()}))).toString();
                            break block3;
                        }
                        if (!None$.MODULE$.equals(option)) break block4;
                        string = frame.toString();
                    }
                    return string;
                }
                throw new MatchError((Object)option);
            }
            {
                this.monitors$1 = monitors$1;
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))));
        Set heldLocks = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])threadInfo.getLockedSynchronizers()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])threadInfo.getLockedMonitors()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LockInfo.class)))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(LockInfo x$12) {
                return Utils$.MODULE$.org$apache$spark$util$Utils$$Lock(x$12).lockString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet();
        return new ThreadStackTrace(threadInfo.getThreadId(), threadInfo.getThreadName(), threadInfo.getThreadState(), stackTrace, (Option<Object>)(threadInfo.getLockOwnerId() < 0L ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)threadInfo.getLockOwnerId()))), (String)Option$.MODULE$.apply((Object)threadInfo.getLockInfo()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(LockInfo x$13) {
                return Utils$.MODULE$.org$apache$spark$util$Utils$$Lock(x$13).lockString();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }), (Seq<String>)heldLocks.toSeq());
    }

    public Seq<String> sparkJavaOpts(SparkConf conf, Function1<String, Object> filterKey) {
        return (Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])conf.getAll()).filter((Function1)new Serializable(filterKey){
            public static final long serialVersionUID = 0L;
            private final Function1 filterKey$1;

            public final boolean apply(Tuple2<String, String> x0$8) {
                Tuple2<String, String> tuple2 = x0$8;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    boolean bl = BoxesRunTime.unboxToBoolean((Object)this.filterKey$1.apply((Object)k));
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.filterKey$1 = filterKey$1;
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, String> x0$9) {
                Tuple2<String, String> tuple2 = x0$9;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-D", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{k, v}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public Function1<String, Object> sparkJavaOpts$default$2() {
        return new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$14) {
                return true;
            }
        };
    }

    public int portMaxRetries(SparkConf conf) {
        Option maxRetries = conf.getOption("spark.port.maxRetries").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$15) {
                return new StringOps(Predef$.MODULE$.augmentString(x$15)).toInt();
            }
        });
        return conf.contains("spark.testing") ? BoxesRunTime.unboxToInt((Object)maxRetries.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 100;
            }
        })) : BoxesRunTime.unboxToInt((Object)maxRetries.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 16;
            }
        }));
    }

    public int userPort(int base, int offset) {
        return (base + offset - 1024) % 64512 + 1024;
    }

    public <T> Tuple2<T, Object> startServiceOnPort(int startPort, Function1<Object, Tuple2<T, Object>> startService, SparkConf conf, String serviceName) {
        Object object = new Object();
        try {
            Predef$.MODULE$.require(startPort == 0 || 1024 <= startPort && startPort < 65536, (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "startPort should be between 1024 and 65535 (inclusive), or 0 for a random free port.";
                }
            });
            String serviceString = serviceName.isEmpty() ? "" : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{serviceName}));
            int maxRetries = this.portMaxRetries(conf);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), maxRetries).foreach$mVc$sp((Function1)new Serializable(startPort, startService, serviceString, maxRetries, object){
                public static final long serialVersionUID = 0L;
                private final int startPort$1;
                private final Function1 startService$1;
                public final String serviceString$1;
                private final int maxRetries$1;
                private final Object nonLocalReturnKey2$1;

                public final void apply(int offset) {
                    this.apply$mcVI$sp(offset);
                }

                public void apply$mcVI$sp(int offset) {
                    int tryPort = this.startPort$1 == 0 ? this.startPort$1 : Utils$.MODULE$.userPort(this.startPort$1, offset);
                    try {
                        Tuple2 tuple2 = (Tuple2)this.startService$1.apply((Object)BoxesRunTime.boxToInteger((int)tryPort));
                        if (tuple2 != null) {
                            Tuple2 tuple22;
                            Object service = tuple2._1();
                            int port = tuple2._2$mcI$sp();
                            Tuple2 tuple23 = tuple22 = new Tuple2(service, (Object)BoxesRunTime.boxToInteger((int)port));
                            Object service2 = tuple23._1();
                            int port2 = tuple23._2$mcI$sp();
                            Utils$.MODULE$.logInfo((Function0<String>)new Serializable(this, port2){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.startServiceOnPort.1 $outer;
                                private final int port$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Successfully started service", " on port ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.serviceString$1, BoxesRunTime.boxToInteger((int)this.port$1)}));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.port$1 = port$1;
                                }
                            });
                            throw new NonLocalReturnControl(this.nonLocalReturnKey2$1, (Object)new Tuple2(service2, (Object)BoxesRunTime.boxToInteger((int)port2)));
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    catch (Throwable throwable) {
                        Exception exception2;
                        Throwable throwable2 = throwable;
                        if (throwable2 instanceof Exception && Utils$.MODULE$.isBindCollision(exception2 = (Exception)throwable2)) {
                            BoxedUnit boxedUnit;
                            if (offset >= this.maxRetries$1) {
                                String exceptionMessage = this.startPort$1 == 0 ? new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Service", " failed after "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{exception2.getMessage(), this.serviceString$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " retries (on a random free port)! "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.maxRetries$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Consider explicitly setting the appropriate binding address for "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"the service", " (for example spark.driver.bindAddress "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.serviceString$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for SparkDriver) to the correct binding address."})).s((Seq)Nil$.MODULE$)).toString() : new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Service", " failed after "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{exception2.getMessage(), this.serviceString$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " retries (starting from ", ")! Consider explicitly setting "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.maxRetries$1), BoxesRunTime.boxToInteger((int)this.startPort$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"the appropriate port for the service", " (for example spark.ui.port "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.serviceString$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for SparkUI) to an available port or increasing spark.port.maxRetries."})).s((Seq)Nil$.MODULE$)).toString();
                                BindException exception3 = new BindException(exceptionMessage);
                                exception3.setStackTrace(exception2.getStackTrace());
                                throw exception3;
                            }
                            if (this.startPort$1 == 0) {
                                Utils$.MODULE$.logWarning((Function0<String>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun.startServiceOnPort.1 $outer;

                                    public final String apply() {
                                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Service", " could not bind on a random free port. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.serviceString$1}))).append((Object)"You may check whether configuring an appropriate binding address.").toString();
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                Utils$.MODULE$.logWarning((Function0<String>)new Serializable(this, tryPort){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun.startServiceOnPort.1 $outer;
                                    private final int tryPort$1;

                                    public final String apply() {
                                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Service", " could not bind on port ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.serviceString$1, BoxesRunTime.boxToInteger((int)this.tryPort$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempting port ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(this.tryPort$1 + 1))}))).toString();
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.tryPort$1 = tryPort$1;
                                    }
                                });
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit2 = boxedUnit;
                            return;
                        }
                        throw throwable;
                    }
                }
                {
                    this.startPort$1 = startPort$1;
                    this.startService$1 = startService$1;
                    this.serviceString$1 = serviceString$1;
                    this.maxRetries$1 = maxRetries$1;
                    this.nonLocalReturnKey2$1 = nonLocalReturnKey2$1;
                }
            });
            throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to start service", " on port ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{serviceString, BoxesRunTime.boxToInteger((int)startPort)})));
        }
        catch (NonLocalReturnControl nonLocalReturnControl) {
            if (nonLocalReturnControl.key() == object) {
                return (Tuple2)nonLocalReturnControl.value();
            }
            throw nonLocalReturnControl;
        }
    }

    public <T> String startServiceOnPort$default$4() {
        return "";
    }

    public boolean isBindCollision(Throwable exception2) {
        boolean bl;
        block6: {
            while (true) {
                Throwable throwable;
                if ((throwable = exception2) instanceof BindException) {
                    BindException bindException = (BindException)throwable;
                    if (bindException.getMessage() == null) {
                        exception2 = bindException.getCause();
                        continue;
                    }
                    return true;
                }
                if (throwable instanceof MultiException) {
                    MultiException multiException = (MultiException)throwable;
                    bl = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(multiException.getThrowables()).asScala()).exists((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Throwable exception2) {
                            return Utils$.MODULE$.isBindCollision(exception2);
                        }
                    });
                    break block6;
                }
                if (throwable instanceof Errors.NativeIoException) {
                    Errors.NativeIoException nativeIoException = (Errors.NativeIoException)throwable;
                    if (nativeIoException.getMessage() != null && nativeIoException.getMessage().startsWith("bind() failed: ")) {
                        bl = true;
                        break block6;
                    }
                    exception2 = nativeIoException.getCause();
                    continue;
                }
                if (!(throwable instanceof Exception)) break;
                Exception exception3 = (Exception)throwable;
                exception2 = exception3.getCause();
            }
            bl = false;
        }
        return bl;
    }

    public void setLogLevel(Level l) {
        org.apache.log4j.Logger.getRootLogger().setLevel(l);
    }

    public String libraryPathEnvName() {
        return this.isWindows() ? "PATH" : (this.isMac() ? "DYLD_LIBRARY_PATH" : "LD_LIBRARY_PATH");
    }

    public String libraryPathEnvPrefix(Seq<String> libraryPaths) {
        String libraryPathScriptVar = this.isWindows() ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"%", "%"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.libraryPathEnvName()})) : new StringBuilder().append((Object)"$").append((Object)this.libraryPathEnvName()).toString();
        String libraryPath = ((TraversableOnce)libraryPaths.$colon$plus((Object)libraryPathScriptVar, Seq$.MODULE$.canBuildFrom())).mkString("\"", File.pathSeparator, "\"");
        String ampersand = this.isWindows() ? " &" : "";
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "=", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.libraryPathEnvName(), libraryPath, ampersand}));
    }

    public String getSparkOrYarnConfig(SparkConf conf, String key, String string) {
        String string2;
        if (conf.contains(key)) {
            string2 = conf.get(key, string);
        } else {
            String string3 = conf.get("spark.master", null);
            String string4 = "yarn";
            string2 = !(string3 != null ? !string3.equals(string4) : string4 != null) ? new YarnConfiguration(SparkHadoopUtil$.MODULE$.get().newConfiguration(conf)).get(key, string) : string;
        }
        return string2;
    }

    public Tuple2<String, Object> extractHostPortFromSparkUrl(String sparkUrl) throws SparkException {
        try {
            URI uri = new URI(sparkUrl);
            String host = uri.getHost();
            int port = uri.getPort();
            String string = uri.getScheme();
            String string2 = "spark";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                if (host != null && port >= 0 && (uri.getPath() == null || uri.getPath().isEmpty()) && uri.getFragment() == null && uri.getQuery() == null && uri.getUserInfo() == null) {
                    return new Tuple2((Object)host, (Object)BoxesRunTime.boxToInteger((int)port));
                }
            }
            throw new SparkException(new StringBuilder().append((Object)"Invalid master URL: ").append((Object)sparkUrl).toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new SparkException(new StringBuilder().append((Object)"Invalid master URL: ").append((Object)sparkUrl).toString(), uRISyntaxException);
        }
    }

    public String getCurrentUserName() {
        return (String)Option$.MODULE$.apply((Object)System.getenv("SPARK_USER")).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return UserGroupInformation.getCurrentUser().getShortUserName();
            }
        });
    }

    public Set<String> EMPTY_USER_GROUPS() {
        return this.EMPTY_USER_GROUPS;
    }

    public Set<String> getCurrentUserGroups(SparkConf sparkConf, String username) {
        String groupProviderClassName;
        String string = groupProviderClassName = sparkConf.get("spark.user.groups.mapping", "org.apache.spark.security.ShellBasedGroupsMappingProvider");
        String string2 = "";
        if (string == null ? string2 != null : !string.equals(string2)) {
            try {
                GroupMappingServiceProvider groupMappingServiceProvider = (GroupMappingServiceProvider)this.classForName(groupProviderClassName).newInstance();
                Set<String> currentUserGroups = groupMappingServiceProvider.getGroups(username);
                return currentUserGroups;
            }
            catch (Exception exception2) {
                this.logError((Function0<String>)new Serializable(username){
                    public static final long serialVersionUID = 0L;
                    private final String username$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error getting groups for user=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.username$1}));
                    }
                    {
                        this.username$1 = username$1;
                    }
                }, exception2);
            }
        }
        return this.EMPTY_USER_GROUPS();
    }

    public String[] parseStandaloneMasterUrls(String masterUrls) {
        return (String[])Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(masterUrls)).stripPrefix("spark://").split(",")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$17) {
                return new StringBuilder().append((Object)"spark://").append((Object)x$17).toString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
    }

    public String BACKUP_STANDALONE_MASTER_PREFIX() {
        return this.BACKUP_STANDALONE_MASTER_PREFIX;
    }

    public boolean responseFromBackup(String msg) {
        return msg.startsWith(this.BACKUP_STANDALONE_MASTER_PREFIX());
    }

    /*
     * WARNING - void declaration
     */
    public <T> T withDummyCallSite(SparkContext sc, Function0<T> body2) {
        Object object;
        String oldShortCallSite = sc.getLocalProperty(CallSite$.MODULE$.SHORT_FORM());
        String oldLongCallSite = sc.getLocalProperty(CallSite$.MODULE$.LONG_FORM());
        try {
            sc.setLocalProperty(CallSite$.MODULE$.SHORT_FORM(), "");
            sc.setLocalProperty(CallSite$.MODULE$.LONG_FORM(), "");
            object = body2.apply();
            sc.setLocalProperty(CallSite$.MODULE$.SHORT_FORM(), oldShortCallSite);
            sc.setLocalProperty(CallSite$.MODULE$.LONG_FORM(), oldLongCallSite);
        }
        catch (Throwable throwable) {
            void var4_4;
            void var3_3;
            sc.setLocalProperty(CallSite$.MODULE$.SHORT_FORM(), (String)var3_3);
            sc.setLocalProperty(CallSite$.MODULE$.LONG_FORM(), (String)var4_4);
            throw throwable;
        }
        return (T)object;
    }

    public boolean isInDirectory(File parent, File child) {
        while (true) {
            if (child == null || parent == null) {
                return false;
            }
            if (!child.exists() || !parent.exists() || !parent.isDirectory()) break;
            if (parent.equals(child)) {
                return true;
            }
            child = child.getParentFile();
        }
        return false;
    }

    public boolean isLocalMaster(SparkConf conf) {
        String master;
        String string = master = conf.get("spark.master", "");
        String string2 = "local";
        return !(string == null ? string2 != null : !string.equals(string2)) || master.startsWith("local[");
    }

    public boolean isDynamicAllocationEnabled(SparkConf conf) {
        boolean dynamicAllocationEnabled = conf.getBoolean("spark.dynamicAllocation.enabled", false);
        return dynamicAllocationEnabled && (!this.isLocalMaster(conf) || conf.getBoolean("spark.dynamicAllocation.testing", false));
    }

    /*
     * WARNING - void declaration
     */
    public int getDynamicAllocationInitialExecutors(SparkConf conf) {
        void var2_2;
        if (BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_INITIAL_EXECUTORS())) < BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_MIN_EXECUTORS()))) {
            this.logWarning((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " less than "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_INITIAL_EXECUTORS().key()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is invalid, ignoring its setting, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_MIN_EXECUTORS().key()}))).append((Object)"please update your configs.").toString();
                }
            });
        }
        if (BoxesRunTime.unboxToInt((Object)((Option)conf.get(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_INSTANCES())).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 0;
            }
        })) < BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_MIN_EXECUTORS()))) {
            this.logWarning((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " less than "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_INSTANCES().key()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is invalid, ignoring its setting, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_MIN_EXECUTORS().key()}))).append((Object)"please update your configs.").toString();
                }
            });
        }
        int initialExecutors = BoxesRunTime.unboxToInt((Object)((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_MIN_EXECUTORS())), BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_INITIAL_EXECUTORS())), BoxesRunTime.unboxToInt((Object)((Option)conf.get(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_INSTANCES())).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 0;
            }
        }))}))).max((Ordering)Ordering.Int$.MODULE$));
        this.logInfo((Function0<String>)new Serializable(initialExecutors){
            public static final long serialVersionUID = 0L;
            private final int initialExecutors$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Using initial executors = ", ", max of "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.initialExecutors$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", ", " and "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_INITIAL_EXECUTORS().key(), org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_MIN_EXECUTORS().key()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_INSTANCES().key()}))).toString();
            }
            {
                this.initialExecutors$1 = initialExecutors$1;
            }
        });
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public <R extends Closeable, T> T tryWithResource(Function0<R> createResource, Function1<R, T> f) {
        Object object;
        Closeable resource = (Closeable)createResource.apply();
        try {
            object = f.apply((Object)resource);
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        resource.close();
        return (T)object;
    }

    public File tempFileWith(File path) {
        return new File(new StringBuilder().append((Object)path.getAbsolutePath()).append((Object)".").append((Object)UUID.randomUUID()).toString());
    }

    public String getProcessName() {
        return ManagementFactory.getRuntimeMXBean().getName();
    }

    public void initDaemon(Logger log2) {
        log2.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Started daemon with process name: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getProcessName()})));
        SignalUtils$.MODULE$.registerLogger(log2);
    }

    public Seq<String> getUserJars(SparkConf conf) {
        Option<String> sparkJars = conf.getOption("spark.jars");
        return (Seq)Option$.MODULE$.option2Iterable(sparkJars.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String x$18) {
                return x$18.split(",");
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String[] x$19) {
                return (String[])Predef$.MODULE$.refArrayOps((Object[])x$19).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(String x$20) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$20)).nonEmpty();
                    }
                });
            }
        })).toSeq().flatten((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<String> apply(String[] xs) {
                return Predef$.MODULE$.refArrayOps((Object[])xs);
            }
        });
    }

    public Seq<String> getLocalUserJarsForShell(SparkConf conf) {
        Option<String> localJars = conf.getOption("spark.repl.local.jars");
        return (Seq)Option$.MODULE$.option2Iterable(localJars.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String x$21) {
                return x$21.split(",");
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String[] x$22) {
                return (String[])Predef$.MODULE$.refArrayOps((Object[])x$22).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(String x$23) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$23)).nonEmpty();
                    }
                });
            }
        })).toSeq().flatten((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<String> apply(String[] xs) {
                return Predef$.MODULE$.refArrayOps((Object[])xs);
            }
        });
    }

    public String REDACTION_REPLACEMENT_TEXT() {
        return this.REDACTION_REPLACEMENT_TEXT;
    }

    public Seq<Tuple2<String, String>> redact(SparkConf conf, Seq<Tuple2<String, String>> kvs) {
        Regex redactionPattern = conf.get(org.apache.spark.internal.config.package$.MODULE$.SECRET_REDACTION_PATTERN());
        return this.redact(redactionPattern, kvs);
    }

    public Seq<Tuple2<String, String>> redact(Option<Regex> regex, Seq<Tuple2<String, String>> kvs) {
        Option<Regex> option;
        block4: {
            Seq<Tuple2<String, String>> seq;
            block3: {
                block2: {
                    option = regex;
                    if (!None$.MODULE$.equals(option)) break block2;
                    seq = kvs;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                Regex r = (Regex)some.x();
                seq = this.redact(r, kvs);
            }
            return seq;
        }
        throw new MatchError(option);
    }

    public String redact(Option<Regex> regex, String text) {
        Option<Regex> option;
        block4: {
            String string;
            block3: {
                block2: {
                    option = regex;
                    if (!None$.MODULE$.equals(option)) break block2;
                    string = text;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                Regex r = (Regex)some.x();
                string = text == null || text.isEmpty() ? text : r.replaceAllIn((CharSequence)text, this.REDACTION_REPLACEMENT_TEXT());
            }
            return string;
        }
        throw new MatchError(option);
    }

    private Seq<Tuple2<String, String>> redact(Regex redactionPattern, Seq<Tuple2<String, String>> kvs) {
        return (Seq)kvs.map((Function1)new Serializable(redactionPattern){
            public static final long serialVersionUID = 0L;
            public final Regex redactionPattern$1;

            public final Tuple2<String, String> apply(Tuple2<String, String> x0$10) {
                Tuple2<String, String> tuple2 = x0$10;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value2 = (String)tuple2._2();
                    Tuple2 tuple22 = (Tuple2)this.redactionPattern$1.findFirstIn((CharSequence)key).orElse((Function0)new Serializable(this, value2){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.redact.1 $outer;
                        private final String value$1;

                        public final Option<String> apply() {
                            return this.$outer.redactionPattern$1.findFirstIn((CharSequence)this.value$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.value$1 = value$1;
                        }
                    }).map((Function1)new Serializable(this, key){
                        public static final long serialVersionUID = 0L;
                        private final String key$1;

                        public final Tuple2<String, String> apply(String x$24) {
                            return new Tuple2((Object)this.key$1, (Object)Utils$.MODULE$.REDACTION_REPLACEMENT_TEXT());
                        }
                        {
                            this.key$1 = key$1;
                        }
                    }).getOrElse((Function0)new Serializable(this, key, value2){
                        public static final long serialVersionUID = 0L;
                        private final String key$1;
                        private final String value$1;

                        public final Tuple2<String, String> apply() {
                            return new Tuple2((Object)this.key$1, (Object)this.value$1);
                        }
                        {
                            this.key$1 = key$1;
                            this.value$1 = value$1;
                        }
                    });
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                this.redactionPattern$1 = redactionPattern$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<Tuple2<String, String>> redact(Map<String, String> kvs) {
        Regex redactionPattern = new StringOps(Predef$.MODULE$.augmentString((String)kvs.getOrElse((Object)org.apache.spark.internal.config.package$.MODULE$.SECRET_REDACTION_PATTERN().key(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return org.apache.spark.internal.config.package$.MODULE$.SECRET_REDACTION_PATTERN().defaultValueString();
            }
        }))).r();
        return this.redact(redactionPattern, (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])kvs.toArray(ClassTag$.MODULE$.apply(Tuple2.class))));
    }

    public Seq<String> stringToSeq(String str) {
        return Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])str.split(",")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$25) {
                return x$25.trim();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$26) {
                return new StringOps(Predef$.MODULE$.augmentString(x$26)).nonEmpty();
            }
        }));
    }

    public <T> Seq<T> loadExtensions(Class<T> extClass, Seq<String> classes, SparkConf conf) {
        return (Seq)classes.flatMap((Function1)new Serializable(extClass, conf){
            public static final long serialVersionUID = 0L;
            public final Class extClass$1;
            private final SparkConf conf$1;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Iterable<T> apply(String name2) {
                Throwable throwable;
                InvocationTargetException invocationTargetException2222;
                block5: {
                    Iterable iterable;
                    try {
                        Object object;
                        Class<?> klass = Utils$.MODULE$.classForName(name2);
                        Predef$.MODULE$.require(this.extClass$1.isAssignableFrom(klass), (Function0)new Serializable(this, name2){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.loadExtensions.1 $outer;
                            private final String name$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not a subclass of ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1, this.$outer.extClass$1.getName()}));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.name$1 = name$1;
                            }
                        });
                        Try try_ = Try$.MODULE$.apply((Function0)new Serializable(this, klass){
                            public static final long serialVersionUID = 0L;
                            private final Class klass$1;

                            public final Constructor<?> apply() {
                                return this.klass$1.getConstructor(SparkConf.class);
                            }
                            {
                                this.klass$1 = klass$1;
                            }
                        });
                        if (try_ instanceof Success) {
                            Success success = (Success)try_;
                            Constructor ctor = (Constructor)success.value();
                            object = ctor.newInstance(this.conf$1);
                        } else {
                            if (!(try_ instanceof Failure)) throw new MatchError((Object)try_);
                            object = klass.getConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                        ? ext = object;
                        iterable = Option$.MODULE$.option2Iterable((Option)new Some(ext));
                        return iterable;
                    }
                    catch (InvocationTargetException invocationTargetException2222) {
                        Iterable iterable2;
                        throwable = invocationTargetException2222.getCause();
                        if (!(throwable instanceof UnsupportedOperationException)) break block5;
                        UnsupportedOperationException unsupportedOperationException = (UnsupportedOperationException)throwable;
                        Utils$.MODULE$.logDebug((Function0<String>)new Serializable(this, name2){
                            public static final long serialVersionUID = 0L;
                            private final String name$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Extension ", " not being initialized."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1}));
                            }
                            {
                                this.name$1 = name$1;
                            }
                        }, unsupportedOperationException);
                        Utils$.MODULE$.logInfo((Function0<String>)new Serializable(this, name2){
                            public static final long serialVersionUID = 0L;
                            private final String name$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Extension ", " not being initialized."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1}));
                            }
                            {
                                this.name$1 = name$1;
                            }
                        });
                        iterable = iterable2 = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                        return iterable;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        throw new SparkException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " did not have a zero-argument constructor or a"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name2}))).append((Object)" single-argument constructor that accepts SparkConf. Note: if the class is").append((Object)" defined inside of another Scala class, then its constructors may accept an").append((Object)" implicit parameter that references the enclosing class; in this case, you must").append((Object)" define the class as a top-level class in order to prevent this extra").append((Object)" parameter from breaking Spark's ability to find a valid constructor.").toString());
                    }
                }
                if (throwable != null) throw throwable;
                throw invocationTargetException2222;
            }
            {
                this.extClass$1 = extClass$1;
                this.conf$1 = conf$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    public String checkAndGetK8sMasterUrl(String rawMasterURL) {
        void var2_2;
        block2: {
            void var4_3;
            block5: {
                String string;
                block4: {
                    String string2;
                    Some some;
                    boolean bl;
                    String masterWithoutK8sPrefix;
                    block3: {
                        Predef$.MODULE$.require(rawMasterURL.startsWith("k8s://"), (Function0)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Kubernetes master URL must start with k8s://.";
                            }
                        });
                        masterWithoutK8sPrefix = rawMasterURL.substring("k8s://".length());
                        if (!masterWithoutK8sPrefix.contains("://")) break block2;
                        String masterScheme = new URI(masterWithoutK8sPrefix).getScheme();
                        bl = false;
                        some = null;
                        Option option = Option$.MODULE$.apply((Object)masterScheme).map((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply(String x$27) {
                                return x$27.toLowerCase(Locale.ROOT);
                            }
                        });
                        if (!(option instanceof Some)) break block3;
                        bl = true;
                        some = (Some)option;
                        String string3 = (String)some.x();
                        if (!"https".equals(string3)) break block3;
                        string = masterWithoutK8sPrefix;
                        break block4;
                    }
                    if (!bl || !"http".equals(string2 = (String)some.x())) break block5;
                    this.logWarning((Function0<String>)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Kubernetes master URL uses HTTP instead of HTTPS.";
                        }
                    });
                    string = masterWithoutK8sPrefix;
                }
                String resolvedURL = string;
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k8s://", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resolvedURL}));
            }
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid Kubernetes master scheme: ").append((Object)var4_3).append((Object)" found in URL: ").append((Object)var2_2).toString());
        }
        String resolvedURL = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"https://", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var2_2}));
        this.logInfo((Function0<String>)new Serializable(resolvedURL){
            public static final long serialVersionUID = 0L;
            private final String resolvedURL$1;

            public final String apply() {
                return new StringBuilder().append((Object)"No scheme specified for kubernetes master URL, so defaulting to https. Resolved ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"URL is ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.resolvedURL$1}))).toString();
            }
            {
                this.resolvedURL$1 = resolvedURL$1;
            }
        });
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k8s://", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resolvedURL}));
    }

    public String substituteAppNExecIds(String opt, String appId, String execId) {
        return opt.replace("{{APP_ID}}", appId).replace("{{EXECUTOR_ID}}", execId);
    }

    public String substituteAppId(String opt, String appId) {
        return opt.replace("{{APP_ID}}", appId);
    }

    public String createSecret(SparkConf conf) {
        int bits = BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.AUTH_SECRET_BIT_LENGTH()));
        SecureRandom rnd = new SecureRandom();
        byte[] secretBytes = new byte[bits / 8];
        rnd.nextBytes(secretBytes);
        return HashCodes.fromBytes((byte[])secretBytes).toString();
    }

    public boolean isMemberClass(Class<?> cls) {
        boolean bl;
        try {
            bl = cls.isMemberClass();
        }
        catch (InternalError internalError) {
            bl = cls.getEnclosingMethod() == null && cls.getEnclosingClass() != null;
        }
        return bl;
    }

    public String getSimpleName(Class<?> cls) {
        try {
            return cls.getSimpleName();
        }
        catch (InternalError internalError) {
            return this.stripDollars(this.stripPackages(cls.getName()));
        }
    }

    private String stripPackages(String fullyQualifiedName) {
        return ((String[])Predef$.MODULE$.refArrayOps((Object[])fullyQualifiedName.split("\\.")).takeRight(1))[0];
    }

    private String stripDollars(String s) {
        Option option;
        while (true) {
            int lastNonDollarIndex;
            block8: {
                String string;
                block5: {
                    String string2;
                    block7: {
                        block6: {
                            block4: {
                                int lastDollarIndex;
                                if ((lastDollarIndex = s.lastIndexOf(36)) >= s.length() - 1) break block4;
                                string = lastDollarIndex != -1 && s.contains("$iw") ? s.substring(lastDollarIndex + 1) : s;
                                break block5;
                            }
                            Option lastNonDollarChar = new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(s)).reverse())).find((Function1)new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(char x$28) {
                                    return x$28 != '$';
                                }
                            });
                            option = lastNonDollarChar;
                            if (!None$.MODULE$.equals(option)) break block6;
                            string2 = s;
                            break block7;
                        }
                        if (!(option instanceof Some)) break;
                        Some some = (Some)option;
                        char c = BoxesRunTime.unboxToChar((Object)some.x());
                        lastNonDollarIndex = s.lastIndexOf(c);
                        if (lastNonDollarIndex != -1) break block8;
                        string2 = s;
                    }
                    string = string2;
                }
                return string;
            }
            s = s.substring(0, lastNonDollarIndex + 1);
        }
        throw new MatchError((Object)option);
    }

    private Regex fullWidthRegex() {
        return this.fullWidthRegex;
    }

    public int stringHalfWidth(String str) {
        return str == null ? 0 : str.length() + this.fullWidthRegex().findAllIn((CharSequence)str).size();
    }

    /*
     * WARNING - void declaration
     */
    public Properties cloneProperties(Properties props) {
        void var2_2;
        Properties resultProps = new Properties();
        ((IterableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).foreach((Function1)new Serializable(resultProps){
            public static final long serialVersionUID = 0L;
            private final Properties resultProps$1;

            public final Object apply(Tuple2<String, String> entry) {
                return this.resultProps$1.put(entry._1(), entry._2());
            }
            {
                this.resultProps$1 = resultProps$1;
            }
        });
        return var2_2;
    }

    public final void org$apache$spark$util$Utils$$log$1(String s) {
        this.logInfo((Function0<String>)new Serializable(s){
            public static final long serialVersionUID = 0L;
            private final String s$1;

            public final String apply() {
                return this.s$1;
            }
            {
                this.s$1 = s$1;
            }
        });
    }

    public final void org$apache$spark$util$Utils$$appendToOutput$1(String s, StringBuilder output$1) {
        output$1.append(s).append("\n");
    }

    private final void endWord$1(ArrayBuffer buf$1, StringBuilder curWord$1) {
        buf$1.$plus$eq((Object)curWord$1.toString());
        curWord$1.clear();
    }

    private Utils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.random = new Random();
        this.sparkUncaughtExceptionHandler = new SparkUncaughtExceptionHandler(SparkUncaughtExceptionHandler$.MODULE$.$lessinit$greater$default$1());
        this.cachedLocalDir = "";
        this.DEFAULT_DRIVER_MEM_MB = (int)1024L;
        this.MAX_DIR_CREATION_ATTEMPTS = 10;
        this.localRootDirs = null;
        this.DEFAULT_MAX_TO_STRING_FIELDS = 25;
        this.truncationWarningPrinted = new AtomicBoolean(false);
        this.customHostname = scala.sys.package$.MODULE$.env().get((Object)"SPARK_LOCAL_HOSTNAME");
        this.hostPortParseResults = new ConcurrentHashMap();
        this.SPARK_CORE_CLASS_REGEX = new StringOps(Predef$.MODULE$.augmentString("^org\\.apache\\.spark(\\.api\\.java)?(\\.util)?(\\.rdd)?(\\.broadcast)?\\.[A-Z]")).r();
        this.SPARK_SQL_CLASS_REGEX = new StringOps(Predef$.MODULE$.augmentString("^org\\.apache\\.spark\\.sql.*")).r();
        this.UNCOMPRESSED_LOG_FILE_LENGTH_CACHE_SIZE_CONF = "spark.worker.ui.compressedLogFileLengthCacheSize";
        this.DEFAULT_UNCOMPRESSED_LOG_FILE_LENGTH_CACHE_SIZE = 100;
        this.compressedLogFileLengthCache = null;
        this.isWindows = SystemUtils.IS_OS_WINDOWS;
        this.isMac = SystemUtils.IS_OS_MAC_OSX;
        this.windowsDrive = new StringOps(Predef$.MODULE$.augmentString("([a-zA-Z])")).r();
        this.EMPTY_USER_GROUPS = Predef$.MODULE$.Set().empty();
        this.BACKUP_STANDALONE_MASTER_PREFIX = "Current state is not alive";
        this.REDACTION_REPLACEMENT_TEXT = "*********(redacted)";
        this.fullWidthRegex = new StringOps(Predef$.MODULE$.augmentString("[\u1100-\u115f\u2e80-\ua4cf\uac00-\ud7a3\uf900-\ufaff\ufe10-\ufe19\ufe30-\ufe6f\uff00-\uff60\uffe0-\uffe6]")).r();
    }
}

