/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark.converter;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POMergeJoin;
import org.apache.pig.backend.hadoop.executionengine.spark.FlatMapFunctionAdapter;
import org.apache.pig.backend.hadoop.executionengine.spark.SparkUtil;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.OutputConsumerIterator;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.RDDConverter;
import org.apache.pig.data.Tuple;
import org.apache.spark.rdd.RDD;

public class MergeJoinConverter
implements RDDConverter<Tuple, Tuple, POMergeJoin> {
    @Override
    public RDD<Tuple> convert(List<RDD<Tuple>> predecessors, POMergeJoin poMergeJoin) throws IOException {
        SparkUtil.assertPredecessorSize(predecessors, poMergeJoin, 1);
        RDD<Tuple> rdd = predecessors.get(0);
        MergeJoinFunction mergeJoinFunction = new MergeJoinFunction(poMergeJoin);
        return rdd.toJavaRDD().mapPartitions(SparkUtil.flatMapFunction(mergeJoinFunction), true).rdd();
    }

    private static class MergeJoinFunction
    implements FlatMapFunctionAdapter<Iterator<Tuple>, Tuple>,
    Serializable {
        private POMergeJoin poMergeJoin;

        private MergeJoinFunction(POMergeJoin poMergeJoin) {
            this.poMergeJoin = poMergeJoin;
        }

        @Override
        public Iterator<Tuple> call(Iterator<Tuple> input) {
            return new OutputConsumerIterator(input){

                @Override
                protected void attach(Tuple tuple) {
                    poMergeJoin.setInputs(null);
                    poMergeJoin.attachInput(tuple);
                }

                @Override
                protected Result getNextResult() throws ExecException {
                    return poMergeJoin.getNextTuple();
                }

                @Override
                protected void endOfInput() {
                    poMergeJoin.setEndOfInput(true);
                }
            };
        }
    }
}

