/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchDeleter;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.MultiTableBatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.client.admin.InstanceOperations;
import org.apache.accumulo.core.client.admin.InstanceOperationsImpl;
import org.apache.accumulo.core.client.admin.SecurityOperations;
import org.apache.accumulo.core.client.admin.SecurityOperationsImpl;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.client.admin.TableOperationsImpl;
import org.apache.accumulo.core.client.impl.BatchWriterImpl;
import org.apache.accumulo.core.client.impl.ClientExec;
import org.apache.accumulo.core.client.impl.MultiTableBatchWriterImpl;
import org.apache.accumulo.core.client.impl.ScannerImpl;
import org.apache.accumulo.core.client.impl.ServerClient;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.TabletServerBatchDeleter;
import org.apache.accumulo.core.client.impl.TabletServerBatchReader;
import org.apache.accumulo.core.client.impl.thrift.ClientService;
import org.apache.accumulo.core.client.impl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.core.util.ArgumentChecker;
import org.apache.accumulo.trace.instrument.Tracer;

public class ConnectorImpl
extends Connector {
    private final Instance instance;
    private final TCredentials credentials;
    private SecurityOperations secops = null;
    private TableOperations tableops = null;
    private InstanceOperations instanceops = null;

    @Deprecated
    public ConnectorImpl(Instance instance, TCredentials cred) throws AccumuloException, AccumuloSecurityException {
        ArgumentChecker.notNull(instance, cred);
        this.instance = instance;
        this.credentials = cred;
        if (!cred.getPrincipal().equals("!SYSTEM")) {
            ServerClient.execute(instance, new ClientExec<ClientService.Client>(){

                @Override
                public void execute(ClientService.Client iface) throws Exception {
                    if (!iface.authenticate(Tracer.traceInfo(), ConnectorImpl.this.credentials)) {
                        throw new AccumuloSecurityException("Authentication failed, access denied", SecurityErrorCode.BAD_CREDENTIALS);
                    }
                }
            });
        }
    }

    private String getTableId(String tableName) throws TableNotFoundException {
        String tableId = Tables.getTableId(this.instance, tableName);
        if (Tables.getTableState(this.instance, tableId) == TableState.OFFLINE) {
            throw new TableOfflineException(this.instance, tableId);
        }
        return tableId;
    }

    @Override
    public Instance getInstance() {
        return this.instance;
    }

    @Override
    public BatchScanner createBatchScanner(String tableName, Authorizations authorizations, int numQueryThreads) throws TableNotFoundException {
        ArgumentChecker.notNull(tableName, authorizations);
        return new TabletServerBatchReader(this.instance, this.credentials, this.getTableId(tableName), authorizations, numQueryThreads);
    }

    @Override
    @Deprecated
    public BatchDeleter createBatchDeleter(String tableName, Authorizations authorizations, int numQueryThreads, long maxMemory, long maxLatency, int maxWriteThreads) throws TableNotFoundException {
        ArgumentChecker.notNull(tableName, authorizations);
        return new TabletServerBatchDeleter(this.instance, this.credentials, this.getTableId(tableName), authorizations, numQueryThreads, new BatchWriterConfig().setMaxMemory(maxMemory).setMaxLatency(maxLatency, TimeUnit.MILLISECONDS).setMaxWriteThreads(maxWriteThreads));
    }

    @Override
    public BatchDeleter createBatchDeleter(String tableName, Authorizations authorizations, int numQueryThreads, BatchWriterConfig config) throws TableNotFoundException {
        ArgumentChecker.notNull(tableName, authorizations);
        return new TabletServerBatchDeleter(this.instance, this.credentials, this.getTableId(tableName), authorizations, numQueryThreads, config);
    }

    @Override
    @Deprecated
    public BatchWriter createBatchWriter(String tableName, long maxMemory, long maxLatency, int maxWriteThreads) throws TableNotFoundException {
        ArgumentChecker.notNull(tableName);
        return new BatchWriterImpl(this.instance, this.credentials, this.getTableId(tableName), new BatchWriterConfig().setMaxMemory(maxMemory).setMaxLatency(maxLatency, TimeUnit.MILLISECONDS).setMaxWriteThreads(maxWriteThreads));
    }

    @Override
    public BatchWriter createBatchWriter(String tableName, BatchWriterConfig config) throws TableNotFoundException {
        ArgumentChecker.notNull(tableName);
        return new BatchWriterImpl(this.instance, this.credentials, this.getTableId(tableName), config);
    }

    @Override
    @Deprecated
    public MultiTableBatchWriter createMultiTableBatchWriter(long maxMemory, long maxLatency, int maxWriteThreads) {
        return new MultiTableBatchWriterImpl(this.instance, this.credentials, new BatchWriterConfig().setMaxMemory(maxMemory).setMaxLatency(maxLatency, TimeUnit.MILLISECONDS).setMaxWriteThreads(maxWriteThreads));
    }

    @Override
    public MultiTableBatchWriter createMultiTableBatchWriter(BatchWriterConfig config) {
        return new MultiTableBatchWriterImpl(this.instance, this.credentials, config);
    }

    @Override
    public Scanner createScanner(String tableName, Authorizations authorizations) throws TableNotFoundException {
        ArgumentChecker.notNull(tableName, authorizations);
        return new ScannerImpl(this.instance, this.credentials, this.getTableId(tableName), authorizations);
    }

    @Override
    public String whoami() {
        return this.credentials.getPrincipal();
    }

    @Override
    public synchronized TableOperations tableOperations() {
        if (this.tableops == null) {
            this.tableops = new TableOperationsImpl(this.instance, this.credentials);
        }
        return this.tableops;
    }

    @Override
    public synchronized SecurityOperations securityOperations() {
        if (this.secops == null) {
            this.secops = new SecurityOperationsImpl(this.instance, this.credentials);
        }
        return this.secops;
    }

    @Override
    public synchronized InstanceOperations instanceOperations() {
        if (this.instanceops == null) {
            this.instanceops = new InstanceOperationsImpl(this.instance, this.credentials);
        }
        return this.instanceops;
    }
}

