/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.blockfile.cache;

import java.util.LinkedList;
import java.util.PriorityQueue;
import org.apache.accumulo.core.file.blockfile.cache.CachedBlock;
import org.apache.accumulo.core.file.blockfile.cache.HeapSize;

public class CachedBlockQueue
implements HeapSize {
    private PriorityQueue<CachedBlock> queue;
    private long heapSize;
    private long maxSize;

    public CachedBlockQueue(long maxSize, long blockSize) {
        int initialSize = (int)Math.ceil((double)maxSize / (double)blockSize);
        if (initialSize == 0) {
            ++initialSize;
        }
        this.queue = new PriorityQueue(initialSize);
        this.heapSize = 0L;
        this.maxSize = maxSize;
    }

    public void add(CachedBlock cb) {
        if (this.heapSize < this.maxSize) {
            this.queue.add(cb);
            this.heapSize += cb.heapSize();
        } else {
            CachedBlock head = this.queue.peek();
            if (cb.compareTo(head) > 0) {
                this.heapSize += cb.heapSize();
                this.heapSize -= head.heapSize();
                if (this.heapSize > this.maxSize) {
                    this.queue.poll();
                } else {
                    this.heapSize += head.heapSize();
                }
                this.queue.add(cb);
            }
        }
    }

    public CachedBlock[] get() {
        LinkedList<CachedBlock> blocks = new LinkedList<CachedBlock>();
        while (!this.queue.isEmpty()) {
            blocks.addFirst(this.queue.poll());
        }
        return blocks.toArray(new CachedBlock[blocks.size()]);
    }

    public LinkedList<CachedBlock> getList() {
        LinkedList<CachedBlock> blocks = new LinkedList<CachedBlock>();
        while (!this.queue.isEmpty()) {
            blocks.addFirst(this.queue.poll());
        }
        return blocks;
    }

    @Override
    public long heapSize() {
        return this.heapSize;
    }
}

