/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.shell.commands;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.util.shell.Shell;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class ListShellIterCommand
extends Shell.Command {
    private Option nameOpt;
    private Option profileOpt;

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws Exception {
        if (shellState.iteratorProfiles.size() == 0) {
            return 0;
        }
        StringBuilder sb = new StringBuilder();
        String profile = null;
        if (cl.hasOption(this.profileOpt.getOpt())) {
            profile = cl.getOptionValue(this.profileOpt.getOpt());
        }
        String name = null;
        if (cl.hasOption(this.nameOpt.getOpt())) {
            name = cl.getOptionValue(this.nameOpt.getOpt());
        }
        Set<Map.Entry<String, List<IteratorSetting>>> es = shellState.iteratorProfiles.entrySet();
        for (Map.Entry<String, List<IteratorSetting>> entry : es) {
            if (profile != null && !profile.equals(entry.getKey())) continue;
            sb.append("-\n");
            sb.append("- Profile : " + entry.getKey() + "\n");
            for (IteratorSetting setting : entry.getValue()) {
                if (name != null && !name.equals(setting.getName())) continue;
                sb.append("-    Iterator ").append(setting.getName()).append(", ").append(" options:\n");
                sb.append("-        ").append("iteratorPriority").append(" = ").append(setting.getPriority()).append("\n");
                sb.append("-        ").append("iteratorClassName").append(" = ").append(setting.getIteratorClass()).append("\n");
                for (Map.Entry<String, String> optEntry : setting.getOptions().entrySet()) {
                    sb.append("-        ").append(optEntry.getKey()).append(" = ").append(optEntry.getValue()).append("\n");
                }
            }
        }
        if (sb.length() > 0) {
            sb.append("-\n");
        }
        shellState.getReader().printString(sb.toString());
        return 0;
    }

    @Override
    public String description() {
        return "lists iterators profiles configured in shell";
    }

    @Override
    public int numArgs() {
        return 0;
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        this.profileOpt = new Option("pn", "profile", true, "iterator profile name");
        this.profileOpt.setArgName("profile");
        this.nameOpt = new Option("n", "name", true, "iterator to list");
        this.nameOpt.setArgName("itername");
        o.addOption(this.profileOpt);
        o.addOption(this.nameOpt);
        return o;
    }
}

