/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Exchange;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.rules.MultiJoin;
import org.apache.calcite.rex.RexNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelCollation;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelDistribution;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortExchange;

public class HiveInsertExchange4JoinRule
extends RelOptRule {
    protected static final transient Log LOG = LogFactory.getLog(HiveInsertExchange4JoinRule.class);
    public static final HiveInsertExchange4JoinRule EXCHANGE_BELOW_MULTIJOIN = new HiveInsertExchange4JoinRule(MultiJoin.class);
    public static final HiveInsertExchange4JoinRule EXCHANGE_BELOW_JOIN = new HiveInsertExchange4JoinRule(Join.class);

    public HiveInsertExchange4JoinRule(Class<? extends RelNode> clazz) {
        super(RelOptRule.operand(clazz, (RelOptRuleOperandChildren)HiveInsertExchange4JoinRule.any()));
    }

    public void onMatch(RelOptRuleCall call) {
        RelNode newOp;
        HiveCalciteUtil.JoinPredicateInfo joinPredInfo;
        if (call.rel(0) instanceof MultiJoin) {
            MultiJoin multiJoin = (MultiJoin)call.rel(0);
            joinPredInfo = HiveCalciteUtil.JoinPredicateInfo.constructJoinPredicateInfo(multiJoin);
        } else if (call.rel(0) instanceof Join) {
            Join join = (Join)call.rel(0);
            joinPredInfo = HiveCalciteUtil.JoinPredicateInfo.constructJoinPredicateInfo(join);
        } else {
            return;
        }
        for (RelNode child : call.rel(0).getInputs()) {
            if (!(((HepRelVertex)child).getCurrentRel() instanceof Exchange)) continue;
            return;
        }
        ArrayList<HiveSortExchange> newInputs = new ArrayList<HiveSortExchange>();
        for (int i = 0; i < call.rel(0).getInputs().size(); ++i) {
            ArrayList<Integer> joinKeyPositions = new ArrayList<Integer>();
            ImmutableList.Builder keyListBuilder = new ImmutableList.Builder();
            ImmutableList.Builder collationListBuilder = new ImmutableList.Builder();
            for (int j = 0; j < joinPredInfo.getEquiJoinPredicateElements().size(); ++j) {
                HiveCalciteUtil.JoinLeafPredicateInfo joinLeafPredInfo = joinPredInfo.getEquiJoinPredicateElements().get(j);
                for (int pos : joinLeafPredInfo.getProjsJoinKeysInChildSchema(i)) {
                    if (joinKeyPositions.contains(pos)) continue;
                    joinKeyPositions.add(pos);
                    collationListBuilder.add((Object)new RelFieldCollation(pos));
                    keyListBuilder.add((Object)joinLeafPredInfo.getJoinKeyExprs(i).get(0));
                }
            }
            HiveSortExchange exchange = HiveSortExchange.create(call.rel(0).getInput(i), new HiveRelDistribution(RelDistribution.Type.HASH_DISTRIBUTED, joinKeyPositions), (RelCollation)new HiveRelCollation((ImmutableList<RelFieldCollation>)collationListBuilder.build()), (ImmutableList<RexNode>)keyListBuilder.build());
            newInputs.add(exchange);
        }
        if (call.rel(0) instanceof MultiJoin) {
            MultiJoin multiJoin = (MultiJoin)call.rel(0);
            newOp = multiJoin.copy(multiJoin.getTraitSet(), newInputs);
        } else if (call.rel(0) instanceof Join) {
            Join join = (Join)call.rel(0);
            newOp = join.copy(join.getTraitSet(), join.getCondition(), (RelNode)newInputs.get(0), (RelNode)newInputs.get(1), join.getJoinType(), join.isSemiJoinDone());
        } else {
            return;
        }
        call.getPlanner().onCopy(call.rel(0), newOp);
        call.transformTo(newOp);
    }
}

