/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.plan.ConditionalResolver;

public class ConditionalResolverCommonJoin
implements ConditionalResolver,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(ConditionalResolverCommonJoin.class);

    @Override
    public List<Task<? extends Serializable>> getTasks(HiveConf conf, Object objCtx) {
        ConditionalResolverCommonJoinCtx ctx = ((ConditionalResolverCommonJoinCtx)objCtx).clone();
        ArrayList<Task<? extends Serializable>> resTsks = new ArrayList<Task<? extends Serializable>>();
        Task<? extends Serializable> task = this.resolveDriverAlias(ctx, conf);
        if (task == null) {
            resTsks.add(ctx.getCommonJoinTask());
        } else {
            if (task.getBackupTask() != null) {
                task.getBackupTask().setTaskTag(6);
            }
            resTsks.add(task);
        }
        return resTsks;
    }

    private Task<? extends Serializable> resolveDriverAlias(ConditionalResolverCommonJoinCtx ctx, HiveConf conf) {
        try {
            this.resolveUnknownSizes(ctx, conf);
            return this.resolveMapJoinTask(ctx, conf);
        }
        catch (Exception e) {
            LOG.info((Object)"Failed to resolve driver alias by exception.. Falling back to common join", (Throwable)e);
            return null;
        }
    }

    protected Task<? extends Serializable> resolveMapJoinTask(ConditionalResolverCommonJoinCtx ctx, HiveConf conf) throws Exception {
        Set<String> participants = this.getParticipants(ctx);
        HashMap<String, Long> aliasToKnownSize = ctx.getAliasToKnownSize();
        HashMap<String, ArrayList<String>> pathToAliases = ctx.getPathToAliases();
        HashMap<Task<? extends Serializable>, Set<String>> taskToAliases = ctx.getTaskToAliases();
        long threshold = HiveConf.getLongVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVESMALLTABLESFILESIZE);
        Long bigTableSize = null;
        Long smallTablesSize = null;
        Map.Entry nextTask = null;
        for (Map.Entry entry : taskToAliases.entrySet()) {
            Set aliases = (Set)entry.getValue();
            long sumOfOthers = Utilities.sumOfExcept(aliasToKnownSize, participants, aliases);
            if (sumOfOthers < 0L || sumOfOthers > threshold) continue;
            long aliasSize = Utilities.sumOf(aliasToKnownSize, aliases);
            if (bigTableSize != null && aliasSize <= bigTableSize) continue;
            nextTask = entry;
            bigTableSize = aliasSize;
            smallTablesSize = sumOfOthers;
        }
        if (nextTask != null) {
            LOG.info((Object)("Driver alias is " + nextTask.getValue() + " with size " + bigTableSize + " (total size of others : " + smallTablesSize + ", threshold : " + threshold + ")"));
            return (Task)nextTask.getKey();
        }
        LOG.info((Object)("Failed to resolve driver alias (threshold : " + threshold + ", length mapping : " + aliasToKnownSize + ")"));
        return null;
    }

    private Set<String> getParticipants(ConditionalResolverCommonJoinCtx ctx) {
        HashSet<String> participants = new HashSet<String>();
        for (List list : ctx.getPathToAliases().values()) {
            participants.addAll(list);
        }
        return participants;
    }

    protected void resolveUnknownSizes(ConditionalResolverCommonJoinCtx ctx, HiveConf conf) throws Exception {
        Set<String> aliases = this.getParticipants(ctx);
        HashMap<String, Long> aliasToKnownSize = ctx.getAliasToKnownSize();
        HashMap<String, ArrayList<String>> pathToAliases = ctx.getPathToAliases();
        HashSet unknownPaths = new HashSet();
        block0: for (Map.Entry entry : pathToAliases.entrySet()) {
            for (String alias : (ArrayList)entry.getValue()) {
                if (!aliases.contains(alias) || aliasToKnownSize.containsKey(alias)) continue;
                unknownPaths.add(entry.getKey());
                continue block0;
            }
        }
        Path hdfsTmpDir = ctx.getHdfsTmpDir();
        Path localTmpDir = ctx.getLocalTmpDir();
        for (String p : unknownPaths) {
            if (!p.startsWith(hdfsTmpDir.toString()) && !p.startsWith(localTmpDir.toString())) continue;
            Path path = new Path(p);
            FileSystem fs = path.getFileSystem((Configuration)conf);
            long fileSize = fs.getContentSummary(path).getLength();
            for (String alias : (ArrayList)pathToAliases.get(p)) {
                Long length = (Long)aliasToKnownSize.get(alias);
                if (length != null) continue;
                aliasToKnownSize.put(alias, fileSize);
            }
        }
    }

    public static class ConditionalResolverCommonJoinCtx
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private HashMap<Task<? extends Serializable>, Set<String>> taskToAliases;
        HashMap<String, ArrayList<String>> pathToAliases;
        HashMap<String, Long> aliasToKnownSize;
        private Task<? extends Serializable> commonJoinTask;
        private Path localTmpDir;
        private Path hdfsTmpDir;

        public HashMap<Task<? extends Serializable>, Set<String>> getTaskToAliases() {
            return this.taskToAliases;
        }

        public void setTaskToAliases(HashMap<Task<? extends Serializable>, Set<String>> taskToAliases) {
            this.taskToAliases = taskToAliases;
        }

        public Task<? extends Serializable> getCommonJoinTask() {
            return this.commonJoinTask;
        }

        public void setCommonJoinTask(Task<? extends Serializable> commonJoinTask) {
            this.commonJoinTask = commonJoinTask;
        }

        public HashMap<String, Long> getAliasToKnownSize() {
            return this.aliasToKnownSize == null ? (this.aliasToKnownSize = new HashMap()) : this.aliasToKnownSize;
        }

        public void setAliasToKnownSize(HashMap<String, Long> aliasToKnownSize) {
            this.aliasToKnownSize = aliasToKnownSize;
        }

        public HashMap<String, ArrayList<String>> getPathToAliases() {
            return this.pathToAliases;
        }

        public void setPathToAliases(HashMap<String, ArrayList<String>> pathToAliases) {
            this.pathToAliases = pathToAliases;
        }

        public Path getLocalTmpDir() {
            return this.localTmpDir;
        }

        public void setLocalTmpDir(Path localTmpDir) {
            this.localTmpDir = localTmpDir;
        }

        public Path getHdfsTmpDir() {
            return this.hdfsTmpDir;
        }

        public void setHdfsTmpDir(Path hdfsTmpDir) {
            this.hdfsTmpDir = hdfsTmpDir;
        }

        public ConditionalResolverCommonJoinCtx clone() {
            ConditionalResolverCommonJoinCtx ctx = new ConditionalResolverCommonJoinCtx();
            ctx.setTaskToAliases(this.taskToAliases);
            ctx.setCommonJoinTask(this.commonJoinTask);
            ctx.setPathToAliases(this.pathToAliases);
            ctx.setHdfsTmpDir(this.hdfsTmpDir);
            ctx.setLocalTmpDir(this.localTmpDir);
            ctx.setAliasToKnownSize(new HashMap<String, Long>(this.aliasToKnownSize));
            return ctx;
        }
    }
}

