/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd;

import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLPrivilegeType;

public enum SQLPrivTypeGrant {
    SELECT_NOGRANT(SQLPrivilegeType.SELECT, false),
    SELECT_WGRANT(SQLPrivilegeType.SELECT, true),
    INSERT_NOGRANT(SQLPrivilegeType.INSERT, false),
    INSERT_WGRANT(SQLPrivilegeType.INSERT, true),
    UPDATE_NOGRANT(SQLPrivilegeType.UPDATE, false),
    UPDATE_WGRANT(SQLPrivilegeType.UPDATE, true),
    DELETE_NOGRANT(SQLPrivilegeType.DELETE, false),
    DELETE_WGRANT(SQLPrivilegeType.DELETE, true),
    OWNER_PRIV("OBJECT OWNERSHIP"),
    ADMIN_PRIV("ADMIN PRIVILEGE");

    private final SQLPrivilegeType privType;
    private final boolean withGrant;
    private final String privDesc;

    private SQLPrivTypeGrant(SQLPrivilegeType privType, boolean isGrant) {
        this.privType = privType;
        this.withGrant = isGrant;
        this.privDesc = privType.toString() + (this.withGrant ? " with grant" : "");
    }

    private SQLPrivTypeGrant(String privDesc) {
        this.privDesc = privDesc;
        this.privType = null;
        this.withGrant = false;
    }

    public static SQLPrivTypeGrant getSQLPrivTypeGrant(SQLPrivilegeType privType, boolean isGrant) {
        String typeName = privType.name() + (isGrant ? "_WGRANT" : "_NOGRANT");
        return SQLPrivTypeGrant.valueOf(typeName);
    }

    public static SQLPrivTypeGrant getSQLPrivTypeGrant(String privTypeStr, boolean isGrant) throws HiveAuthzPluginException {
        SQLPrivilegeType ptype = SQLPrivilegeType.getRequirePrivilege(privTypeStr);
        return SQLPrivTypeGrant.getSQLPrivTypeGrant(ptype, isGrant);
    }

    public SQLPrivilegeType getPrivType() {
        return this.privType;
    }

    public boolean isWithGrant() {
        return this.withGrant;
    }

    public String toString() {
        return this.privDesc;
    }
}

