/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.WindowingSpec;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.ISupportStreamingModeForWindowing;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

public abstract class GenericUDAFStreamingEvaluator<T1>
extends GenericUDAFEvaluator
implements ISupportStreamingModeForWindowing {
    protected final GenericUDAFEvaluator wrappedEval;
    protected final int numPreceding;
    protected final int numFollowing;

    public GenericUDAFStreamingEvaluator(GenericUDAFEvaluator wrappedEval, int numPreceding, int numFollowing) {
        this.wrappedEval = wrappedEval;
        this.numPreceding = numPreceding;
        this.numFollowing = numFollowing;
        this.mode = wrappedEval.mode;
    }

    @Override
    public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
        return this.wrappedEval.init(m, parameters);
    }

    @Override
    public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
        StreamingState ss = (StreamingState)agg;
        this.wrappedEval.reset(ss.wrappedBuf);
        ss.reset();
    }

    @Override
    public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
        throw new HiveException(this.getClass().getSimpleName() + ": terminatePartial not supported");
    }

    @Override
    public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
        throw new HiveException(this.getClass().getSimpleName() + ": merge not supported");
    }

    @Override
    public Object getNextResult(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
        StreamingState ss = (StreamingState)agg;
        if (!ss.results.isEmpty()) {
            Object res = ss.results.remove(0);
            if (res == null) {
                return ISupportStreamingModeForWindowing.NULL_RESULT;
            }
            return res;
        }
        return null;
    }

    public static abstract class SumAvgEnhancer<T1, T2>
    extends GenericUDAFStreamingEvaluator<T1> {
        public SumAvgEnhancer(GenericUDAFEvaluator wrappedEval, int numPreceding, int numFollowing) {
            super(wrappedEval, numPreceding, numFollowing);
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            GenericUDAFEvaluator.AggregationBuffer underlying = this.wrappedEval.getNewAggregationBuffer();
            return new SumAvgStreamingState(this.numPreceding, this.numFollowing, underlying);
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            SumAvgStreamingState ss = (SumAvgStreamingState)agg;
            this.wrappedEval.iterate(ss.wrappedBuf, parameters);
            if (ss.numRows >= ss.numFollowing) {
                ss.results.add(this.getNextResult(ss));
            }
            if (ss.numPreceding != WindowingSpec.BoundarySpec.UNBOUNDED_AMOUNT) {
                ss.intermediateVals.add(this.getCurrentIntermediateResult(ss));
            }
            ++ss.numRows;
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            SumAvgStreamingState ss = (SumAvgStreamingState)agg;
            Object o = this.wrappedEval.terminate(ss.wrappedBuf);
            for (int i = 0; i < ss.numFollowing; ++i) {
                ss.results.add(this.getNextResult(ss));
                ++ss.numRows;
            }
            return o;
        }

        @Override
        public int getRowsRemainingAfterTerminate() throws HiveException {
            throw new UnsupportedOperationException();
        }

        protected abstract T1 getNextResult(SumAvgStreamingState var1) throws HiveException;

        protected abstract T2 getCurrentIntermediateResult(SumAvgStreamingState var1) throws HiveException;

        class SumAvgStreamingState
        extends StreamingState {
            final List<T2> intermediateVals;

            SumAvgStreamingState(int numPreceding, int numFollowing, GenericUDAFEvaluator.AggregationBuffer buf) {
                super(numPreceding, numFollowing, buf);
                this.intermediateVals = new ArrayList();
            }

            @Override
            public int estimate() {
                if (!(this.wrappedBuf instanceof GenericUDAFEvaluator.AbstractAggregationBuffer)) {
                    return -1;
                }
                int underlying = ((GenericUDAFEvaluator.AbstractAggregationBuffer)this.wrappedBuf).estimate();
                if (underlying == -1) {
                    return -1;
                }
                if (this.numPreceding == WindowingSpec.BoundarySpec.UNBOUNDED_AMOUNT) {
                    return -1;
                }
                int wdwSz = this.numPreceding + this.numFollowing + 1;
                return underlying + underlying * wdwSz + underlying * wdwSz + 12;
            }

            @Override
            protected void reset() {
                this.intermediateVals.clear();
                super.reset();
            }
        }
    }

    class StreamingState
    extends GenericUDAFEvaluator.AbstractAggregationBuffer {
        final GenericUDAFEvaluator.AggregationBuffer wrappedBuf;
        final int numPreceding;
        final int numFollowing;
        final List<T1> results;
        int numRows;

        StreamingState(int numPreceding, int numFollowing, GenericUDAFEvaluator.AggregationBuffer buf) {
            this.wrappedBuf = buf;
            this.numPreceding = numPreceding;
            this.numFollowing = numFollowing;
            this.results = new ArrayList();
            this.numRows = 0;
        }

        protected void reset() {
            this.results.clear();
            this.numRows = 0;
        }
    }
}

